/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bcr.formplugin.robotscheme;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.lang.StringUtils;

public class RobotSchemeEdit
extends AbstractBasePlugIn {
    private static final String CALLBACKID_PROCESS_FORM = "callbackid_process_form";
    private static final String CALLBACKID_CLIENT_FORM = "callbackid_client_form";

    public void afterCreateNewData(EventObject e) {
        long userId = RequestContext.get().getCurrUserId();
        long userMainOrgId = UserServiceHelper.getUserMainOrgId((long)userId);
        this.getModel().setValue("org", (Object)userMainOrgId);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"procname", "client"});
        this.fillUshieldSet();
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("procname".equals(key)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bcr_process");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACKID_PROCESS_FORM);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        } else if ("client".equals(key)) {
            if (StringUtils.isEmpty((String)((String)this.getModel().getValue("procname")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9RPA\u6d41\u7a0b\u3002", (String)"RobotSchemeEdit_0", (String)"tmc-bcr-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bcr_client");
            showParameter.setCustomParam("procid", this.getModel().getValue("procid"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.VIEW);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACKID_CLIENT_FORM);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (StringUtils.equals((String)closedCallBackEvent.getActionId(), (String)CALLBACKID_PROCESS_FORM) && closedCallBackEvent.getReturnData() != null) {
            HashMap paramMap = (HashMap)closedCallBackEvent.getReturnData();
            this.getModel().setValue("procname", paramMap.get("procname"));
            this.getModel().setValue("proccode", paramMap.get("proccode"));
            this.getModel().setValue("procid", paramMap.get("procid"));
            this.getModel().setValue("client", null);
            this.getModel().setValue("clientid", null);
        } else if (StringUtils.equals((String)closedCallBackEvent.getActionId(), (String)CALLBACKID_CLIENT_FORM) && closedCallBackEvent.getReturnData() != null) {
            HashMap paramMap = (HashMap)closedCallBackEvent.getReturnData();
            this.getModel().setValue("client", paramMap.get("agentalias"));
            this.getModel().setValue("clientid", paramMap.get("clientid"));
        }
    }

    private void fillUshieldSet() {
        BasedataEdit ushieldEdit = (BasedataEdit)this.getControl("ushield");
        ushieldEdit.setF7MultipleSelect(false);
        BasedataEdit acctbank = (BasedataEdit)this.getControl("acctbank");
        acctbank.setF7MultipleSelect(false);
        acctbank.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject ushield = (DynamicObject)this.getModel().getValue("ushield");
            if (ushield == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7f51\u94f6\u767b\u5f55\u4fe1\u606f\u3002", (String)"RobotSchemeEdit_1", (String)"tmc-bcr-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            }
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            if (ushield != null && !ushield.getDynamicObjectCollection(3).isEmpty()) {
                DynamicObjectCollection acctbankCols = ushield.getDynamicObjectCollection(3);
                String sql = "select facctbankid from t_bcr_bankudset_entry where fid = ?";
                Object[] params = new Object[]{((DynamicObject)((DynamicObject)acctbankCols.get(0)).getParent()).getPkValue()};
                List bankIDs = (List)DB.query((DBRoute)new DBRoute("tmc"), (String)sql, (Object[])params, rs -> {
                    ArrayList<Long> ret = new ArrayList<Long>(16);
                    while (rs.next()) {
                        ret.add(rs.getLong(1));
                    }
                    return ret;
                });
                qFilter.and(new QFilter("id", "in", (Object)bankIDs));
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }
}

