/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bcr.opplugin.execlog;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bcr.common.enums.ExeStatusEnum;
import kd.tmc.bcr.common.helper.RpaServiceHelper;
import kd.tmc.bcr.opplugin.execlog.ExecLogSyncStatusValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ExecLogSyncStatusOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ExecLogSyncStatusOp.class);
    public static final String FORMAT_YMDHMS = "yyyy-MM-dd HH:mm:ss";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List sic = e.getFieldKeys();
        sic.add("taskid");
        sic.add("exestatus");
        sic.add("executestarttime");
        sic.add("executeendtime");
        sic.add("errorinfo");
        sic.add("robotscheme");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ExecLogSyncStatusValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        ArrayList<DynamicObject> bcrSchemeExeLogList = new ArrayList<DynamicObject>();
        for (DynamicObject robotSchemeLog : e.getDataEntities()) {
            String taskId = (String)robotSchemeLog.get("taskid");
            if (!taskId.equals("")) {
                String taskStatus;
                Map map;
                try {
                    map = RpaServiceHelper.getTaskInfo((String)taskId);
                }
                catch (Exception exception) {
                    logger.error((Throwable)exception);
                    e.setCancel(true);
                    e.setCancelMessage(ResManager.loadKDString((String)"\u65b9\u6848%s\u5bf9\u5e94\u7684\u4efb\u52a1\u4e0d\u5b58\u5728\u3002", (String)"ExecLogSyncStatusOp_1", (String)"tmc-bcr-opplugin", (Object[])new Object[]{robotSchemeLog.getString("robotscheme.name")}));
                    return;
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat(FORMAT_YMDHMS);
                switch (taskStatus = (String)map.get("status")) {
                    case "pending": {
                        robotSchemeLog.set("exestatus", (Object)ExeStatusEnum.PENDING.getValue());
                        break;
                    }
                    case "running": {
                        robotSchemeLog.set("exestatus", (Object)ExeStatusEnum.RUNNING.getValue());
                        break;
                    }
                    case "success": {
                        robotSchemeLog.set("exestatus", (Object)ExeStatusEnum.SUCCESS.getValue());
                        break;
                    }
                    case "failed": 
                    case "pendout": {
                        robotSchemeLog.set("exestatus", (Object)ExeStatusEnum.FAILED.getValue());
                        break;
                    }
                    case "stopping": {
                        robotSchemeLog.set("exestatus", (Object)ExeStatusEnum.STOPPING.getValue());
                        break;
                    }
                    case "stopped": {
                        robotSchemeLog.set("exestatus", (Object)ExeStatusEnum.STOPPED.getValue());
                        break;
                    }
                    case "cancelled": {
                        robotSchemeLog.set("exestatus", (Object)ExeStatusEnum.CANCELLED.getValue());
                    }
                }
                if (EmptyUtil.isNoEmpty(map.get("startTime"))) {
                    try {
                        robotSchemeLog.set("executestarttime", (Object)dateFormat.parse(map.get("startTime").toString()));
                    }
                    catch (ParseException e1) {
                        throw new KDBizException(e1.getMessage());
                    }
                }
                if (EmptyUtil.isNoEmpty(map.get("endTime"))) {
                    try {
                        robotSchemeLog.set("executeendtime", (Object)dateFormat.parse(map.get("endTime").toString()));
                    }
                    catch (ParseException e1) {
                        throw new KDBizException(e1.getMessage());
                    }
                }
                if (EmptyUtil.isNoEmpty(map.get("description"))) {
                    robotSchemeLog.set("errorinfo", (Object)new LocaleString((String)map.get("description")));
                }
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"taskId\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u540c\u6b65\u72b6\u6001\u3002", (String)"ExecLogSyncStatusOp_0", (String)"tmc-bcr-opplugin", (Object[])new Object[0]));
            }
            bcrSchemeExeLogList.add(robotSchemeLog);
        }
        DynamicObject[] exeLogArray = new DynamicObject[bcrSchemeExeLogList.size()];
        bcrSchemeExeLogList.toArray(exeLogArray);
        SaveServiceHelper.save((DynamicObject[])exeLogArray);
    }
}

