/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bcr.opplugin.robotscheme;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bcr.common.helper.RobotExecuteHelper;
import kd.tmc.bcr.opplugin.robotscheme.RobotExecuteValidator;

public class RobotExecuteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List sic = e.getFieldKeys();
        sic.add("procid");
        sic.add("proccode");
        sic.add("clientid");
        sic.add("startdate");
        sic.add("enddate");
        sic.add("acctbank.bankaccountnumber");
        sic.add("entry");
        sic.add("executeuser");
        sic.add("org");
        sic.add("procname");
        sic.add("client");
        sic.add("entry.ushield");
        sic.add("appSecuret");
        sic.add("ccuser");
        sic.add("ccpassword");
        sic.add("url");
        sic.add("bankpath");
        sic.add("dirpath");
        sic.add("querytype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new RobotExecuteValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        Date startDate = KDDateUtils.parseDate((String)this.getOption().getVariableValue("startdate"));
        Date endDate = KDDateUtils.parseDate((String)this.getOption().getVariableValue("enddate"));
        ArrayList<DynamicObject> bcrSchemeExeLogList = new ArrayList<DynamicObject>();
        for (DynamicObject robotScheme : e.getDataEntities()) {
            DynamicObjectCollection bankAcctInfo = (DynamicObjectCollection)robotScheme.get("entry");
            Map<Object, List<DynamicObject>> groupMap = bankAcctInfo.parallelStream().collect(Collectors.groupingBy(obj -> ((DynamicObject)obj.get("ushield")).getPkValue()));
            for (Map.Entry<Object, List<DynamicObject>> oneGroup : groupMap.entrySet()) {
                DynamicObject execLog = RobotExecuteHelper.execute((DynamicObject)robotScheme, (Date)startDate, (Date)endDate, (Long)((Long)oneGroup.getKey()));
                bcrSchemeExeLogList.add(execLog);
            }
        }
        DynamicObject[] exeLogArray = new DynamicObject[bcrSchemeExeLogList.size()];
        bcrSchemeExeLogList.toArray(exeLogArray);
        SaveServiceHelper.save((DynamicObject[])exeLogArray);
    }
}

