/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bcr.opplugin.robotscheme;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;

public class RobotExecuteValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(RobotExecuteValidator.class);

    public void validate() {
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            Date startDate = null;
            Date endDate = null;
            if (this.getOption().getVariables().containsKey("startdate") && this.getOption().getVariables().containsKey("enddate")) {
                logger.info("START_DATE = " + this.getOption().getVariableValue("startdate"));
                logger.info("END_DATE = " + this.getOption().getVariableValue("enddate"));
                startDate = KDDateUtils.parseDate((String)this.getOption().getVariableValue("startdate"));
                endDate = KDDateUtils.parseDate((String)this.getOption().getVariableValue("enddate"));
            } else if (this.getOption().getVariables().containsKey("interval")) {
                logger.info("interval = " + this.getOption().getVariableValue("interval"));
                int interval = Integer.parseInt(this.getOption().getVariableValue("interval"));
                endDate = interval == 0 ? this.getCurrentDate() : this.getNextDay(this.getCurrentDate(), -1);
                startDate = this.getNextDay(this.getCurrentDate(), -interval);
                this.getOption().setVariableValue("startdate", this.formatString(startDate));
                this.getOption().setVariableValue("enddate", this.formatString(endDate));
            }
            if (startDate != null && endDate != null) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5f00\u59cb\u65e5\u671f\u6216\u7ed3\u675f\u65e5\u671f\u3002", (String)"RobotExecuteValidator_0", (String)"tmc-bcr-opplugin", (Object[])new Object[0]));
        }
    }

    public Date getCurrentDate() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public Date getNextDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) + i);
        return cal.getTime();
    }

    public String formatString(Date date) {
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd");
        return formater.format(date);
    }
}

