/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bdim.business.validate.costshare;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.CostShareServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CostShareSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("feeamount");
        selector.add("amount");
        selector.add("billno");
        selector.add("sourcebillid");
        selector.add("org");
        selector.add("currency");
        selector.add("day");
        selector.add("entryentity");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject data = dataEntity.getDataEntity();
            if (data.getInt("day") > 0) continue;
            BigDecimal feeAmount = data.getBigDecimal("feeamount");
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("entryentity");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)entrys)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u644a\u9500\u660e\u7ec6\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"CostShareSubmitValidator_4", (String)"tmc-bdim-business", (Object[])new Object[0]));
                continue;
            }
            Object[] bondArr = TmcDataServiceHelper.load((String)"cfm_loanbill_bond", (String)"billstatus,publishprice,ticketamt", (QFilter[])new QFilter[]{new QFilter("id", "=", data.get("sourcebillid"))});
            if (EmptyUtil.isEmpty((Object[])bondArr)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u503a\u5238\u53d1\u884c[%s]\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CostShareSubmitValidator_2", (String)"tmc-bdim-business", (Object[])new Object[]{data.getString("billno")}));
                continue;
            }
            if (!BillStatusEnum.AUDIT.getValue().equals(bondArr[0].get("billstatus"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u503a\u5238\u53d1\u884c[%s]\u975e\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u8d39\u7528\u644a\u9500\u3002", (String)"CostShareSubmitValidator_1", (String)"tmc-bdim-business", (Object[])new Object[]{data.getString("billno")}));
                continue;
            }
            boolean isHasCost = TmcDataServiceHelper.exists((String)"bdim_costshare", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", data.get("sourcebillid")), new QFilter("id", "!=", data.getPkValue())});
            if (isHasCost) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u503a\u5238\u53d1\u884c\u5df2\u5b58\u5728\u503a\u5238\u6210\u672c\u644a\u9500\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"LoanBondCostShareValidator_1", (String)"tmc-bdim-business", (Object[])new Object[0]));
            }
            BigDecimal pubAmt = bondArr[0].getBigDecimal("publishprice");
            BigDecimal tickAmt = bondArr[0].getBigDecimal("ticketamt");
            BigDecimal amount = data.getBigDecimal("amount");
            DynamicObject currency = data.getDynamicObject("currency");
            if (currency == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d1\u884c\u5e01\u79cd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"LoanBondCostShareValidator_4", (String)"tmc-bdim-business", (Object[])new Object[0]));
                continue;
            }
            BigDecimal feeTotalAmt = CostShareServiceHelper.getFeeAmount((Long)data.getLong("sourcebillid"), (Long)data.getDynamicObject("company").getLong("id"), (Long)currency.getLong("id"), (String)"bond");
            BigDecimal actFeeTotalAmt = CostShareServiceHelper.getActFeeTotalAmt((BigDecimal)feeTotalAmt, (BigDecimal)pubAmt, (BigDecimal)tickAmt, (BigDecimal)amount);
            if (actFeeTotalAmt.compareTo(BigDecimal.ZERO) == 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6e90\u5355[%s]\u5173\u8054\u7684\u644a\u9500\u91d1\u989d\u4e3a0\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6210\u672c\u644a\u9500\u3002", (String)"CostShareSubmitValidator_3", (String)"tmc-bdim-business", (Object[])new Object[]{data.getString("billno")}));
            }
            if (feeAmount.compareTo(actFeeTotalAmt = actFeeTotalAmt.setScale(currency.getInt("amtprecision"), RoundingMode.HALF_UP)) == 0) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6e90\u5355[%1$s]\u5173\u8054\u7684\u644a\u9500\u91d1\u989d\u4e3a[%2$s]\uff0c\u8bf7\u91cd\u65b0\u8fdb\u884c\u6210\u672c\u644a\u9500\u8ba1\u7b97\u3002", (String)"CostShareSubmitValidator_0", (String)"tmc-bdim-business", (Object[])new Object[0]), data.getString("billno"), actFeeTotalAmt));
        }
    }
}

