/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bdim.formplugin.bondlimit;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class BondLimitList
extends AbstractTmcBillBaseList {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn commonFilterColumn : commonFilterColumns) {
            ListShowParameter listShowParameter;
            String fieldName = commonFilterColumn.getFieldName();
            if ("org.name".equals(fieldName)) {
                commonFilterColumn.setDefaultValue(null);
                continue;
            }
            if (!"status".equals(fieldName) || !"bdim_bondlimit_convert".equals((listShowParameter = (ListShowParameter)this.getView().getFormShowParameter()).getParentFormId())) continue;
            commonFilterColumn.setDefaultValue(BillStatusEnum.AUDIT.getValue());
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        if (this.getView().getParentView() == null) {
            return;
        }
        final Object pkValue = this.getView().getParentView().getModel().getDataEntity().getPkValue();
        if (pkValue == null) {
            return;
        }
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObject[] limits;
                DynamicObjectCollection dataList = super.getData(arg0, arg1);
                if (dataList.isEmpty()) {
                    return dataList;
                }
                Set ids = dataList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
                for (DynamicObject limit : limits = TmcDataServiceHelper.load((String)"bdim_bond_limit", (String)"totalamt,advanceamt,usedamt,availamt,limittype,entry.limitbilltype,entry.limitbillno,entry.limitbillid,entry.limitorg,entry.limitstartdate,entry.limitenddate,entry.limitadvanceamt,entry.limitreleasedamt,entry.limitusedamt,entry.limitactualoccupyamt,entry.limitcurrency", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)})) {
                    DynamicObjectCollection entry = limit.getDynamicObjectCollection("entry");
                    Optional<DynamicObject> first = entry.stream().filter(e -> e.getLong("limitbillid") == ((Long)pkValue).longValue()).findFirst();
                    if (!first.isPresent()) continue;
                    Optional<DynamicObject> firstDataOptional = dataList.stream().filter(e -> e.getLong("id") == ((Long)limit.getPkValue()).longValue()).findFirst();
                    DynamicObject dynamicObject = first.get();
                    if (!firstDataOptional.isPresent()) break;
                    DynamicObject firstData = firstDataOptional.get();
                    firstData.set("advanceamt", (Object)limit.getBigDecimal("advanceamt").subtract(dynamicObject.getBigDecimal("limitadvanceamt")));
                    firstData.set("availamt", (Object)limit.getBigDecimal("availamt").add(dynamicObject.getBigDecimal("limitadvanceamt")));
                    break;
                }
                return dataList;
            }
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "change": {
                if (!this.changeValidator()) break;
                args.setCancel(true);
                break;
            }
        }
    }

    private boolean changeValidator() {
        Long selectedId = this.getSelectedId();
        String selectFields = "id, status, enable, usedamt, advanceamt";
        DynamicObject bondBillDo = TmcDataServiceHelper.loadSingle((Object)selectedId, (String)"bdim_bond_limit", (String)selectFields);
        String status = bondBillDo.getString("status");
        String enable = bondBillDo.getString("enable");
        BigDecimal usedAmt = bondBillDo.getBigDecimal("usedamt");
        BigDecimal advanceAmt = bondBillDo.getBigDecimal("advanceamt");
        if (!BillStatusEnum.AUDIT.getValue().equals(status) || "0".equals(enable) || usedAmt.compareTo(BigDecimal.ZERO) == 0 && advanceAmt.compareTo(BigDecimal.ZERO) == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\uff0c\u4f7f\u7528\u72b6\u6001\u4e3a\u53ef\u7528\uff0c\u4e14\u5df2\u7528\u989d\u5ea6\u6216\u9884\u5360\u989d\u5ea6\u5927\u4e8e0\u624d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"BondLimitList_1", (String)"tmc-bdim-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "change": {
                this.showBondLimitBill();
                break;
            }
        }
    }

    private void showBondLimitBill() {
        Long selectedId = this.getSelectedId();
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId("bdim_bond_limit");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setPkId((Object)selectedId);
        parameter.setStatus(OperationStatus.EDIT);
        parameter.getCustomParams().put("fromchange", "true");
        this.getView().showForm((FormShowParameter)parameter);
    }
}

