/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bdim.formplugin.home;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bdim.common.helper.BondHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AppHomeBondLimitPlugin
extends AbstractBasePlugIn {
    private static String BDIM_BOND_LIMIT_SET = "id,number,currency,totalamt,availamt";
    private static BigDecimal TEN_THOUSAND = new BigDecimal("10000");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_refresh", "total", "available"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.refreshData();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("btn_refresh".equals(key)) {
            this.refreshData();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f\u3002", (String)"AppHomeBondLimitPlugin_1", (String)"tmc-bdim-formplugin", (Object[])new Object[0]));
        } else if ("total".equals(key) || "available".equals(key)) {
            ListShowParameter fsp = new ListShowParameter();
            fsp.setBillFormId("bdim_bond_limit");
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)fsp);
        }
    }

    private void refreshData() {
        String appId = this.getView().getFormShowParameter().getAppId();
        List authorizedBankOrgId = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"bdim_bond_limit", (String)"47150e89000000ac");
        QFilter qFilter = new QFilter("org", "in", (Object)authorizedBankOrgId).and("status", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("enable", "=", (Object)true);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"bondlimithome", (String)"bdim_bond_limit", (String)BDIM_BOND_LIMIT_SET, (QFilter[])qFilter.toArray(), null);
        DynamicObject currentOrg = TmcOrgDataHelper.getCurrentOrg();
        DynamicObject standardCurrency = TmcBusinessBaseHelper.getBaseCurrency((long)currentOrg.getLong("id"));
        if (EmptyUtil.isEmpty((DynamicObject)standardCurrency)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u672c\u4f4d\u5e01\u3002", (String)"AppHomeBondLimitPlugin_0", (String)"tmc-bdim-formplugin", (Object[])new Object[0]));
        }
        BigDecimal sumToal = BigDecimal.ZERO;
        BigDecimal sumAvailable = BigDecimal.ZERO;
        for (Row row : dataSet) {
            Long currencyId = row.getLong("currency");
            String number = row.getString("number");
            BigDecimal rate = BondHelper.getRate((Long)currencyId, (DynamicObject)standardCurrency, (DynamicObject)currentOrg, (String)number);
            BigDecimal totalAmt = row.getBigDecimal("totalamt");
            BigDecimal availAmt = row.getBigDecimal("availamt");
            if (EmptyUtil.isNoEmpty((BigDecimal)totalAmt)) {
                sumToal = sumToal.add(totalAmt.multiply(rate));
            }
            if (!EmptyUtil.isNoEmpty((BigDecimal)availAmt)) continue;
            sumAvailable = sumAvailable.add(availAmt.multiply(rate));
        }
        sumToal = sumToal.divide(TEN_THOUSAND, 2, 1);
        sumAvailable = sumAvailable.divide(TEN_THOUSAND, 2, 1);
        Label totalLabel = (Label)this.getView().getControl("total");
        totalLabel.setText(sumToal.toString());
        Label availLabel = (Label)this.getView().getControl("available");
        availLabel.setText(sumAvailable.toString());
    }
}

