/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bdim.formplugin.intermediaryorgan;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;

public class IntermediarySelectList
extends AbstractTmcListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        CommonFilterColumn companyFilterCol = filterColumnList.stream().filter(filterCol -> org.apache.commons.lang3.StringUtils.equals((CharSequence)filterCol.getFieldName(), (CharSequence)"org.name")).findFirst().orElse(null);
        if (companyFilterCol == null) {
            return;
        }
        companyFilterCol.getDefaultValues().clear();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        Set selectIds = selectedRows.stream().map(o -> o.getPrimaryKeyValue()).collect(Collectors.toSet());
        if ("winningbidderreport".equals(key)) {
            DynamicObjectCollection selectBills = QueryServiceHelper.query((String)"bdim_intermediaryselect", (String)"id,billstatus,callbizstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", selectIds)});
            if (selectIds.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u6267\u884c\u3002", (String)"IntermediarySelectEdit_5", (String)"tmc-bdim-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject selectBill = (DynamicObject)selectBills.get(0);
            String billStatus = selectBill.getString("billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"IntermediarySelectEdit_4", (String)"tmc-bdim-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        AbstractOperate op = (AbstractOperate)afterDoOperationEventArgs.getSource();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        String key = op.getOperateKey();
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        if ("winningbidderreport".equals(key) && operationResult != null && operationResult.isSuccess()) {
            ListSelectedRow row = selectedRows.get(0);
            Object primaryKeyValue = row.getPrimaryKeyValue();
            DynamicObject selectBill = TmcDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"bdim_intermediaryselect");
            DynamicObjectCollection selectEntry = selectBill.getDynamicObjectCollection("selectentry");
            DynamicObject currency = selectBill.getDynamicObject("currency");
            HashSet<String> midOrgTypeList = new HashSet<String>(5);
            for (DynamicObject entry : selectEntry) {
                midOrgTypeList.add(entry.getString("e_midorgtype"));
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("bdim_winningbidder");
            formShowParameter.setCustomParam("midOrgType", midOrgTypeList);
            formShowParameter.setCustomParam("pkid", primaryKeyValue);
            formShowParameter.setCustomParam("currencyid", (Object)currency.getLong("id"));
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bdim_winningbidder"));
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String action = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)action, (CharSequence)"bdim_winningbidder")) {
            this.getView().invokeOperation("refresh");
        }
    }
}

