/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.compare;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.extension.ConcurrentHashSet;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.compare.CompareUnit;
import kd.tmc.fbp.common.compare.comparator.AmountEqualsComparator;
import kd.tmc.fbp.common.compare.data.CompareData;
import kd.tmc.fbp.common.compare.data.CompareDataGetter;
import kd.tmc.fbp.common.compare.data.ComparePropValue;
import kd.tmc.fbp.common.compare.data.CompareRule;
import kd.tmc.fbp.common.compare.data.CompareRuleGroup;
import kd.tmc.fbp.common.compare.result.CompareResult;
import kd.tmc.fbp.common.compare.strategy.AbstractMultiRuleCompareStrategy;
import kd.tmc.fbp.common.enums.MatchRelEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SmartRecCompareStrategy
extends AbstractMultiRuleCompareStrategy {
    private static final Log logger = LogFactory.getLog(SmartRecCompareStrategy.class);

    public SmartRecCompareStrategy(List<CompareRuleGroup> ruleList) {
        super(ruleList, true);
    }

    protected List<CompareResult> handleResult(List<CompareResult> resultList, List<CompareData> srcDataList, List<CompareData> tarDataList, CompareRuleGroup compareRuleGrp) {
        List result;
        logger.info("SmartRecCompareStrategy.handleResult strat, resultList: {}", resultList);
        List successList = super.handleResult(resultList, srcDataList, tarDataList, compareRuleGrp);
        MatchRelEnum matchRelEnum = MatchRelEnum.getByValue((String)compareRuleGrp.getMatchRel());
        if (MatchRelEnum.ONE_TO_ONE != matchRelEnum) {
            Set matchedTarIds;
            String matchRel = compareRuleGrp.getMatchRel();
            HashMap<Object, Set> srcResultMap = new HashMap<Object, Set>();
            HashMap<Object, Set> tarResultMap = new HashMap<Object, Set>();
            for (CompareResult compareResult : resultList) {
                Set comparedIdSet;
                Set set = compareResult.getSrcIdSet();
                Set tarIdSet = compareResult.getTarIdSet();
                for (Object e : set) {
                    comparedIdSet = srcResultMap.computeIfAbsent(e, o -> new HashSet());
                    comparedIdSet.addAll(tarIdSet);
                }
                for (Object e : tarIdSet) {
                    comparedIdSet = tarResultMap.computeIfAbsent(e, o -> new HashSet());
                    comparedIdSet.addAll(set);
                }
            }
            ArrayList<CompareResult> notOneToOneResult = new ArrayList<CompareResult>(10);
            if (MatchRelEnum.ONE_TO_MANY == matchRelEnum) {
                for (Map.Entry entry : srcResultMap.entrySet()) {
                    Object srcId = entry.getKey();
                    Set tarIds = (Set)entry.getValue();
                    matchedTarIds = notOneToOneResult.stream().map(CompareResult::getTarIdSet).flatMap(Collection::stream).collect(Collectors.toSet());
                    for (CompareRule compareRule : compareRuleGrp.getCompareRuleList()) {
                        if (!compareRule.isAmountMatch() || !EmptyUtil.isNoEmpty((String)matchRel)) continue;
                        CompareUnit unit = new CompareUnit();
                        for (CompareData srcData : srcDataList) {
                            Set srcValues;
                            ComparePropValue srcValue;
                            if (!srcData.getPropName().equals(compareRule.getPropNameSrc()) || (srcValue = (ComparePropValue)(srcValues = srcData.getPropValues()).stream().filter(v -> v.getId().equals(srcId)).findFirst().orElse(null)) == null) continue;
                            HashSet<ComparePropValue> srcValueList = new HashSet<ComparePropValue>();
                            srcValueList.add(srcValue);
                            unit.setSrcValList(srcValueList);
                        }
                        for (CompareData tarData : tarDataList) {
                            if (!tarData.getPropName().equals(compareRule.getPropNameTgt())) continue;
                            Set tarValues = tarData.getPropValues();
                            unit.setTarValList(tarValues.stream().filter(v -> !matchedTarIds.contains(v.getId())).filter(o -> tarIds.contains(o.getId())).collect(Collectors.toSet()));
                        }
                        AmountEqualsComparator comparator = new AmountEqualsComparator();
                        if (!compareRuleGrp.isEnableMultiRes() && this.checkMultiRes(unit.getSrcValList(), unit.getTarValList())) {
                            resultList = new ArrayList<CompareResult>();
                            continue;
                        }
                        List result3 = comparator.notOneToOneCompare(unit.getSrcValList(), unit.getTarValList(), matchRel);
                        if (result3.isEmpty()) {
                            resultList = new ArrayList<CompareResult>();
                            continue;
                        }
                        notOneToOneResult.addAll(result3);
                    }
                }
            } else {
                for (Map.Entry entry : tarResultMap.entrySet()) {
                    Object tarId = entry.getKey();
                    Set srcIds = (Set)entry.getValue();
                    matchedTarIds = notOneToOneResult.stream().map(CompareResult::getTarIdSet).flatMap(Collection::stream).collect(Collectors.toSet());
                    Set set = notOneToOneResult.stream().map(CompareResult::getSrcIdSet).flatMap(Collection::stream).collect(Collectors.toSet());
                    for (CompareRule rule : compareRuleGrp.getCompareRuleList()) {
                        if (!rule.isAmountMatch() || !EmptyUtil.isNoEmpty((String)matchRel)) continue;
                        CompareUnit unit = new CompareUnit();
                        for (CompareData srcData : srcDataList) {
                            if (!srcData.getPropName().equals(rule.getPropNameSrc())) continue;
                            Set srcValues = srcData.getPropValues();
                            unit.setSrcValList(srcValues.stream().filter(v -> !matchedSrcIds.contains(v.getId())).filter(o -> srcIds.contains(o.getId())).collect(Collectors.toSet()));
                        }
                        for (CompareData tarData : tarDataList) {
                            if (!tarData.getPropName().equals(rule.getPropNameTgt())) continue;
                            Set tarValues = tarData.getPropValues();
                            unit.setTarValList(tarValues.stream().filter(v -> !matchedTarIds.contains(v.getId())).filter(o -> tarId.equals(o.getId())).collect(Collectors.toSet()));
                        }
                        AmountEqualsComparator comparator = new AmountEqualsComparator();
                        if (!compareRuleGrp.isEnableMultiRes() && this.checkMultiRes(unit.getSrcValList(), unit.getTarValList())) {
                            resultList = new ArrayList<CompareResult>();
                            continue;
                        }
                        result = comparator.notOneToOneCompare(unit.getSrcValList(), unit.getTarValList(), matchRel);
                        if (result.isEmpty()) {
                            resultList = new ArrayList<CompareResult>();
                            continue;
                        }
                        notOneToOneResult.addAll(result);
                    }
                }
            }
            if (notOneToOneResult.size() > 0) {
                resultList = notOneToOneResult;
            }
        }
        BizDateComparator srcComparator = new BizDateComparator(new CompareDataGetter(srcDataList));
        BizDateComparator tarComparator = new BizDateComparator(new CompareDataGetter(tarDataList));
        if (compareRuleGrp.isEnableMultiRes()) {
            Object srcId;
            Set tarIdSet;
            ConcurrentHashSet waitRemoveSrcIdSet = new ConcurrentHashSet();
            ConcurrentHashSet waitRemoveTarIdSet = new ConcurrentHashSet();
            List list = resultList.stream().filter(CompareResult::isMultiRes).collect(Collectors.toList());
            ArrayList<CompareResult> arrayList = new ArrayList<CompareResult>();
            for (CompareResult res : list) {
                LinkedList<Object> srcIdList = new LinkedList<Object>(res.getSrcIdSet());
                LinkedList<Object> linkedList = new LinkedList<Object>(res.getTarIdSet());
                srcIdList.sort(srcComparator);
                linkedList.sort(tarComparator);
                Iterator iterator = srcIdList.iterator();
                Iterator tarIterator = linkedList.iterator();
                while (iterator.hasNext() && tarIterator.hasNext()) {
                    CompareResult result5 = new CompareResult(new HashSet(), new HashSet());
                    result5.getSrcIdSet().add(iterator.next());
                    result5.getTarIdSet().add(tarIterator.next());
                    arrayList.add(result5);
                }
            }
            successList.addAll(arrayList);
            resultList.removeAll(list);
            for (CompareResult result2 : arrayList) {
                waitRemoveSrcIdSet.addAll(result2.getSrcIdSet());
                waitRemoveTarIdSet.addAll(result2.getTarIdSet());
            }
            HashMap srcResultMap = new HashMap();
            HashMap<Object, Set<Object>> tarResultMap = new HashMap<Object, Set<Object>>();
            for (CompareResult compareResult : resultList) {
                Set comparedIdSet;
                Set set = compareResult.getSrcIdSet();
                Set tarIdSet2 = compareResult.getTarIdSet();
                for (Object srcId2 : set) {
                    comparedIdSet = srcResultMap.computeIfAbsent(srcId2, o -> new HashSet());
                    comparedIdSet.addAll(tarIdSet2);
                }
                for (Object tarId : tarIdSet2) {
                    comparedIdSet = tarResultMap.computeIfAbsent(tarId, o -> new HashSet());
                    comparedIdSet.addAll(set);
                }
            }
            ArrayList<CompareResult> oneToOneResult = new ArrayList<CompareResult>();
            if (MatchRelEnum.ONE_TO_ONE == matchRelEnum) {
                for (Map.Entry entry : tarResultMap.entrySet()) {
                    Object tarId = entry.getKey();
                    if (((Set)entry.getValue()).size() != 1 || (tarIdSet = (Set)srcResultMap.get(srcId = ((Set)entry.getValue()).iterator().next())).size() != 1 || !tarIdSet.iterator().next().equals(tarId)) continue;
                    result = new CompareResult(new HashSet(), new HashSet());
                    result.getSrcIdSet().add(srcId);
                    result.getTarIdSet().add(tarId);
                    oneToOneResult.add((CompareResult)result);
                }
            }
            successList.addAll(oneToOneResult);
            this.removeSuccessData(oneToOneResult, srcResultMap, tarResultMap, (Set<Object>)waitRemoveSrcIdSet, (Set<Object>)waitRemoveTarIdSet);
            if (MatchRelEnum.MANY_TO_ONE != matchRelEnum) {
                ArrayList<CompareResult> arrayList2 = new ArrayList<CompareResult>();
                for (Map.Entry entry : tarResultMap.entrySet()) {
                    Object tarId = entry.getKey();
                    Set srcIdSet3 = (Set)entry.getValue();
                    if (srcIdSet3.size() <= 1) continue;
                    LinkedList<Object> srcIdList = new LinkedList<Object>();
                    for (Object srcId3 : srcIdSet3) {
                        Set tarIdSet3 = (Set)srcResultMap.get(srcId3);
                        if (tarIdSet3.size() != 1 || !tarIdSet3.iterator().next().equals(tarId)) continue;
                        srcIdList.add(srcId3);
                    }
                    if (srcIdList.size() <= 0) continue;
                    srcIdList.sort(srcComparator);
                    Iterator firstSrcId = srcIdList.get(0);
                    CompareResult result4 = new CompareResult(new HashSet(), new HashSet());
                    result4.getTarIdSet().add(tarId);
                    result4.getSrcIdSet().add(firstSrcId);
                    arrayList2.add(result4);
                }
                successList.addAll(arrayList2);
                this.removeSuccessData(arrayList2, srcResultMap, tarResultMap, (Set<Object>)waitRemoveSrcIdSet, (Set<Object>)waitRemoveTarIdSet);
            }
            if (MatchRelEnum.ONE_TO_ONE == matchRelEnum) {
                ArrayList<CompareResult> arrayList3 = new ArrayList<CompareResult>();
                for (Map.Entry entry : srcResultMap.entrySet()) {
                    srcId = entry.getKey();
                    tarIdSet = (Set)entry.getValue();
                    if (tarIdSet.size() <= 1) continue;
                    LinkedList<Object> tarIdList = new LinkedList<Object>();
                    for (Object tarId : tarIdSet) {
                        Set srcIdSet4 = (Set)tarResultMap.get(tarId);
                        if (srcIdSet4.size() != 1 || !srcIdSet4.iterator().next().equals(srcId)) continue;
                        tarIdList.add(tarId);
                    }
                    if (tarIdList.size() <= 0) continue;
                    tarIdList.sort(tarComparator);
                    Object firstTarId = tarIdList.get(0);
                    CompareResult result3 = new CompareResult(new HashSet(), new HashSet());
                    result3.getSrcIdSet().add(srcId);
                    result3.getTarIdSet().add(firstTarId);
                    arrayList3.add(result3);
                }
                successList.addAll(arrayList3);
                this.removeSuccessData(arrayList3, srcResultMap, tarResultMap, (Set<Object>)waitRemoveSrcIdSet, (Set<Object>)waitRemoveTarIdSet);
            } else {
                for (CompareResult compareResult : resultList) {
                    waitRemoveSrcIdSet.addAll(compareResult.getSrcIdSet());
                    waitRemoveTarIdSet.addAll(compareResult.getTarIdSet());
                    successList.add(new CompareResult(compareResult.getTarIdSet(), compareResult.getSrcIdSet()));
                }
            }
            this.removeFromDataList(srcDataList, (Collection)waitRemoveSrcIdSet);
            this.removeFromDataList(tarDataList, (Collection)waitRemoveTarIdSet);
        } else {
            HashMap<Object, Integer> srcIdPresentCntMap = new HashMap<Object, Integer>();
            for (CompareResult compareResult : resultList) {
                Set set = compareResult.getSrcIdSet();
                for (Object srcId : set) {
                    Integer pCnt = srcIdPresentCntMap.computeIfAbsent(srcId, t -> 0);
                    int n = compareResult.getTarIdSet().size();
                    srcIdPresentCntMap.put(srcId, pCnt + n);
                }
            }
            if (MatchRelEnum.ONE_TO_MANY != matchRelEnum) {
                Set multiSrcIdSet = srcIdPresentCntMap.entrySet().stream().filter(o -> (Integer)o.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toSet());
                for (CompareResult compareResult : resultList) {
                    compareResult.getSrcIdSet().removeAll(multiSrcIdSet);
                }
            }
            ConcurrentHashSet waitRemoveSrcIdSet = new ConcurrentHashSet();
            ConcurrentHashSet concurrentHashSet = new ConcurrentHashSet();
            HashMap hashMap = new HashMap();
            for (CompareResult result6 : resultList) {
                Set tarIdSet = result6.getTarIdSet();
                Iterator iterator = tarIdSet.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    Integer pCnt = srcIdPresentCntMap.computeIfAbsent(e, t -> 0);
                    int srcSize = result6.getSrcIdSet().size();
                    hashMap.put(e, pCnt + srcSize);
                }
            }
            Set singleMatchTarIdSet = hashMap.entrySet().stream().filter(o -> (Integer)o.getValue() == 1).map(Map.Entry::getKey).collect(Collectors.toSet());
            ArrayList<CompareResult> waitRemoveResultList = new ArrayList<CompareResult>();
            for (CompareResult compareResult : resultList) {
                Sets.SetView setView;
                if (compareResult.getSrcIdSet().size() == 0 || (setView = Sets.intersection(singleMatchTarIdSet, (Set)compareResult.getTarIdSet())).size() <= 0) continue;
                successList.add(compareResult);
                waitRemoveSrcIdSet.addAll(compareResult.getSrcIdSet());
                concurrentHashSet.addAll(compareResult.getTarIdSet());
                waitRemoveResultList.add(compareResult);
            }
            resultList.removeAll(waitRemoveResultList);
            if (MatchRelEnum.MANY_TO_ONE != matchRelEnum) {
                Set multiMatchTarIdSet = hashMap.entrySet().stream().filter(o -> (Integer)o.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toSet());
                HashSet hashSet = new HashSet();
                for (CompareResult result10 : resultList) {
                    Set tarIdSet = result10.getTarIdSet();
                    if (result10.getSrcIdSet().size() == 0) continue;
                    for (Object tarId : tarIdSet) {
                        if (!multiMatchTarIdSet.contains(tarId) || !hashSet.add(tarId)) continue;
                        LinkedList<Object> srcIdList = new LinkedList<Object>(result10.getSrcIdSet());
                        srcIdList.sort(srcComparator);
                        Object firstSrcId = srcIdList.get(0);
                        waitRemoveSrcIdSet.add(firstSrcId);
                        concurrentHashSet.add(tarId);
                        successList.add(new CompareResult(Collections.singleton(tarId), Collections.singleton(firstSrcId)));
                    }
                }
            } else {
                for (CompareResult compareResult : resultList) {
                    waitRemoveSrcIdSet.addAll(compareResult.getSrcIdSet());
                    concurrentHashSet.addAll(compareResult.getTarIdSet());
                    successList.add(new CompareResult(compareResult.getTarIdSet(), compareResult.getSrcIdSet()));
                }
            }
            this.removeFromDataList(srcDataList, (Collection)waitRemoveSrcIdSet);
            this.removeFromDataList(tarDataList, (Collection)concurrentHashSet);
        }
        return successList;
    }

    private boolean checkMultiRes(Set<ComparePropValue> srcValList, Set<ComparePropValue> tarValList) {
        BigDecimal value;
        for (ComparePropValue srcVal : srcValList) {
            value = this.getBigDecimalValue(srcVal.getData());
            if (tarValList.stream().filter(v -> value.compareTo(new BigDecimal(String.valueOf(v.getData()))) == 0).count() <= 1L) continue;
            return true;
        }
        for (ComparePropValue tarVal : tarValList) {
            value = this.getBigDecimalValue(tarVal.getData());
            if (srcValList.stream().filter(v -> value.compareTo(new BigDecimal(String.valueOf(v.getData()))) == 0).count() <= 1L) continue;
            return true;
        }
        return false;
    }

    private BigDecimal getBigDecimalValue(Object val) {
        return null != val ? new BigDecimal(val.toString()) : BigDecimal.ZERO;
    }

    private void removeSuccessData(List<CompareResult> successList, Map<Object, Set<Object>> srcResultMap, Map<Object, Set<Object>> tarResultMap, Set<Object> waitRemoveSrcIdSet, Set<Object> waitRemoveTarIdSet) {
        for (CompareResult result : successList) {
            for (Object e : result.getSrcIdSet()) {
                srcResultMap.remove(e);
            }
            for (Object e : result.getTarIdSet()) {
                tarResultMap.remove(e);
            }
            for (Set set : srcResultMap.values()) {
                set.removeAll(result.getTarIdSet());
            }
            for (Set set : tarResultMap.values()) {
                set.removeAll(result.getTarIdSet());
            }
            waitRemoveSrcIdSet.addAll(result.getSrcIdSet());
            waitRemoveTarIdSet.addAll(result.getTarIdSet());
        }
    }

    private static class BizDateComparator
    implements Comparator<Object> {
        private CompareDataGetter dataGetter;

        public BizDateComparator(CompareDataGetter dataGetter) {
            this.dataGetter = dataGetter;
        }

        @Override
        public int compare(Object o1, Object o2) {
            Date bizDate2;
            Date bizDate1 = (Date)this.dataGetter.getCompareValue("__bizdate", o1);
            int bizDateCompareResult = this.compareDate(bizDate1, bizDate2 = (Date)this.dataGetter.getCompareValue("__bizdate", o2));
            if (bizDateCompareResult == 0) {
                Date createTime1 = (Date)this.dataGetter.getCompareValue("__createtime", o1);
                Date createTime2 = (Date)this.dataGetter.getCompareValue("__createtime", o2);
                return this.compareDate(createTime1, createTime2);
            }
            return bizDateCompareResult;
        }

        private int compareDate(Date date1, Date date2) {
            if (date1 == null && date2 == null) {
                return 0;
            }
            if (date1 == null) {
                return -1;
            }
            if (date2 == null) {
                return 1;
            }
            return date1.compareTo(date2);
        }
    }
}

