/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;

public class BankBillMergeHandler {
    private static final String GROUP_SEPARATOR = "__";

    public static List<List<DynamicObject>> merge(List<DynamicObject> bankBillList) {
        if (bankBillList == null || bankBillList.size() == 0) {
            return Collections.emptyList();
        }
        String entityName = bankBillList.get(0).getDataEntityType().getName();
        ArrayList<List<DynamicObject>> groupList = new ArrayList<List<DynamicObject>>(10);
        Map<String, List<DynamicObject>> collect = bankBillList.stream().collect(Collectors.groupingBy(o -> {
            ArrayList<String> groupStringList = new ArrayList<String>(3);
            String bankAcctId = o.getString("accountbank.id");
            String currencyId = o.getString("currency.id");
            groupStringList.add(bankAcctId);
            groupStringList.add(currencyId);
            if ("bei_bankpaybill".equals(entityName) || "bei_bankagentpay".equals(entityName)) {
                String isOverseaPay = o.getString("istranspay");
                groupStringList.add(isOverseaPay);
                String businessType = o.getString("businesstype");
                groupStringList.add(businessType);
            }
            if ("bei_bankpaybill".equals(entityName)) {
                String isLinkPay = o.getString("islinkpay");
                String parentAcctBankId = o.getString("parentacctbank.id");
                String childAcctBankId = o.getString("childacctbank.id");
                groupStringList.add(isLinkPay);
                groupStringList.add(parentAcctBankId);
                groupStringList.add(childAcctBankId);
            }
            return String.join((CharSequence)GROUP_SEPARATOR, groupStringList);
        }));
        groupList.addAll(collect.values());
        return groupList;
    }
}

