/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.tmc.bei.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.BeiParameterHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.bean.PayDetail;
import kd.tmc.fbp.service.ebservice.bean.PayInfo;
import kd.tmc.fbp.service.ebservice.bean.TransDetail;
import kd.tmc.fbp.service.ebservice.bean.TransInfo;
import kd.tmc.fbp.service.ebservice.utils.BeServiceHelper;
import org.apache.commons.lang3.tuple.Triple;

public class BankPayBillFactory {
    private static Log logger = LogFactory.getLog(BankPayBillFactory.class);

    public static List<Triple<DynamicObject, Boolean, String>> generateBankBill(String entityName, List<PayInfo> payInfoList) {
        if ("bei_bankpaybill".equals(entityName)) {
            return BankPayBillFactory.generateBankPayBill(payInfoList);
        }
        if ("bei_bankagentpay".equals(entityName)) {
            return BankPayBillFactory.generateBankAgentPayBill(payInfoList);
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u4ed8\u6b3e\u5355\u636e\u7c7b\u578b: %s\u3002", (String)"BankPayBillFactory_0", (String)"tmc-bei-business", (Object[])new Object[0]), entityName));
    }

    public static List<Triple<DynamicObject, Boolean, String>> generateBankPayBill(List<PayInfo> payInfoList) {
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(payInfoList.size());
        HashSet<Long> orgIdSet = new HashSet<Long>(payInfoList.size());
        HashSet<Long> acctIdSet = new HashSet<Long>(payInfoList.size());
        HashSet<Long> currencyIdSet = new HashSet<Long>(payInfoList.size());
        HashSet<Long> bankIdSet = new HashSet<Long>(payInfoList.size());
        if (!EmptyUtil.isEmpty(payInfoList)) {
            for (PayInfo payInfo : payInfoList) {
                orgIdSet.add(payInfo.getCompanyId());
                acctIdSet.add(payInfo.getPayAcctId());
                currencyIdSet.add(payInfo.getPayCurrencyId());
                bankIdSet.add(payInfo.getPayBankId());
                if (EmptyUtil.isEmpty((Collection)payInfo.getPayDetails())) continue;
                for (PayDetail payDetail : payInfo.getPayDetails()) {
                    currencyIdSet.add(payDetail.getFeeCurrency());
                }
            }
        }
        Map<Long, DynamicObject> orgMap = BankPayBillFactory.getDataMap("bos_org", orgIdSet);
        Map<Long, DynamicObject> currencyMap = BankPayBillFactory.getDataMap("bd_currency", currencyIdSet);
        Map<Long, DynamicObject> acctMap = BankPayBillFactory.getDataMap("bd_accountbanks", acctIdSet);
        Map<Long, DynamicObject> bankMap = BankPayBillFactory.getDataMap("bd_finorginfo", bankIdSet);
        MainEntityType bankPayBillEntityType = EntityMetadataCache.getDataEntityType((String)"bei_bankpaybill");
        long[] idArr = DB.genLongIds((String)"bei_bankpaybill", (int)payInfoList.size());
        for (int k = 0; k < payInfoList.size(); ++k) {
            PayInfo payInfo = payInfoList.get(k);
            DynamicObject bankPayBill = new DynamicObject((DynamicObjectType)bankPayBillEntityType);
            bankPayBill.set("id", (Object)idArr[k]);
            bankPayBill.set("company", (Object)orgMap.get(payInfo.getCompanyId()));
            String serialNumber = BeServiceHelper.generateSerialNumber();
            bankPayBill.set("batchseqid", (Object)serialNumber);
            bankPayBill.set("serialnumber", (Object)serialNumber);
            bankPayBill.set("applyorg", (Object)orgMap.get(payInfo.getCompanyId()));
            bankPayBill.set("accountbank", (Object)acctMap.get(payInfo.getPayAcctId()));
            bankPayBill.set("bank", (Object)bankMap.get(payInfo.getPayBankId()));
            bankPayBill.set("currency", (Object)currencyMap.get(payInfo.getPayCurrencyId()));
            bankPayBill.set("amount", (Object)payInfo.getTotalPayAmt());
            bankPayBill.set("locamt", (Object)payInfo.getTotalLocalAmt());
            bankPayBill.set("sourcebillid", (Object)payInfo.getBillId());
            bankPayBill.set("payunique", (Object)-1L);
            bankPayBill.set("isprivatepay", (Object)payInfo.isPersonalPay());
            bankPayBill.set("istranspay", (Object)payInfo.isOverseaPay());
            bankPayBill.set("srcbillno", (Object)payInfo.getBillNo());
            bankPayBill.set("recemail", (Object)payInfo.getRecEmail());
            PayDetail payDetail = (PayDetail)payInfo.getPayDetails().get(0);
            bankPayBill.set("expectdealtime", (Object)payDetail.getExpectDate());
            bankPayBill.set("usage", (Object)payDetail.getRemark());
            bankPayBill.set("payeename", (Object)payDetail.getRecName());
            bankPayBill.set("payeeacct", (Object)payDetail.getRecBankAcct());
            bankPayBill.set("payeebank", (Object)payDetail.getRecBankName());
            bankPayBill.set("recbanknumber", (Object)payDetail.getRecBankNum());
            bankPayBill.set("reccountry", (Object)payDetail.getCountry());
            bankPayBill.set("recprovince", (Object)payDetail.getProvince());
            bankPayBill.set("reccity", (Object)payDetail.getCity());
            bankPayBill.set("srcbilltype", (Object)payInfo.getBillType());
            bankPayBill.set("bizdate", (Object)new Date());
            bankPayBill.set("isbitback", (Object)Boolean.FALSE);
            bankPayBill.set("bankpaystate", (Object)BeBillStatusEnum.OP.getValue());
            bankPayBill.set("bankinterface", (Object)BeBillStatusEnum.OP.getValue());
            bankPayBill.set("creator", (Object)RequestContext.get().getCurrUserId());
            bankPayBill.set("createtime", (Object)new Date());
            boolean isBankBillAudit = BeiParameterHelper.getAppBoolParameter((long)payInfo.getCompanyId(), (String)"bei002");
            boolean isNeedCommitBe = BeiParameterHelper.isBizBillCommitBe((long)payInfo.getCompanyId());
            if (!isNeedCommitBe && isBankBillAudit) {
                bankPayBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            } else {
                bankPayBill.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
            }
            if (payInfo.isOverseaPay()) {
                bankPayBill.set("usecn", (Object)payDetail.getUseCN());
                bankPayBill.set("incomeswiftcode", (Object)payDetail.getRecSwiftCode());
                bankPayBill.set("payerfeetype", (Object)payDetail.getFeePayer());
                bankPayBill.set("payerfeecurrency", (Object)currencyMap.get(payDetail.getFeeCurrency()));
                bankPayBill.set("paymentmethod", (Object)payDetail.getPayMethod());
                bankPayBill.set("servicelevel", (Object)payDetail.getServiceLevel());
                bankPayBill.set("tolexchangerate", (Object)payDetail.getAgreeRate());
                bankPayBill.set("incomebankcode", (Object)payDetail.getRecRoutingNum());
                bankPayBill.set("excontract", (Object)payDetail.getContractNo());
                bankPayBill.set("incomeradds", (Object)payDetail.getRecBankAddress());
                bankPayBill.set("deliverymethod", (Object)payDetail.getSendWay());
                bankPayBill.set("chequetype", (Object)payDetail.getCheckType());
                bankPayBill.set("chequeusage", (Object)payDetail.getCheckUsage());
                bankPayBill.set("proxyaccno", (Object)payDetail.getProxyAcctNo());
                bankPayBill.set("proxyaccname", (Object)payDetail.getProxyAcctName());
                bankPayBill.set("proxybankcountry", (Object)payDetail.getProxyBankCountry());
                bankPayBill.set("proxybankarea", (Object)payDetail.getProxyBankArea());
                bankPayBill.set("proxyswiftcode", (Object)payDetail.getProxySwiftCode());
                bankPayBill.set("proxybankname", (Object)payDetail.getProxyBankName());
                bankPayBill.set("proxybankadds", (Object)payDetail.getProxyBankAddress());
                bankPayBill.set("payerfeeaccno", (Object)payDetail.getPayerFeeAcctNo());
                bankPayBill.set("transremarks", (Object)payDetail.getTransRemarks());
                bankPayBill.set("settlementmethod", (Object)payDetail.getSettlementMethod());
                bankPayBill.set("mobile", (Object)payDetail.getMobile());
            }
            bankPayBill.set("billno", (Object)BankPayBillFactory.generateNumber("bei_bankpaybill", bankPayBill, payInfo.getCompanyId().toString(), null));
            billList.add(bankPayBill);
        }
        return BankPayBillFactory.doSaveBankBill(billList, "bei_bankpaybill", "cas_paybill", "sourcebillid");
    }

    public static List<Triple<DynamicObject, Boolean, String>> generateBankAgentPayBill(List<PayInfo> payInfoList) {
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(payInfoList.size());
        HashSet<Long> orgIdSet = new HashSet<Long>(payInfoList.size());
        HashSet<Long> acctIdSet = new HashSet<Long>(payInfoList.size());
        HashSet<Long> currencyIdSet = new HashSet<Long>(payInfoList.size());
        if (!EmptyUtil.isEmpty(payInfoList)) {
            for (PayInfo payInfo : payInfoList) {
                orgIdSet.add(payInfo.getCompanyId());
                acctIdSet.add(payInfo.getPayAcctId());
                currencyIdSet.add(payInfo.getPayCurrencyId());
                if (EmptyUtil.isEmpty((Collection)payInfo.getPayDetails())) continue;
                for (PayDetail payDetail : payInfo.getPayDetails()) {
                    currencyIdSet.add(payDetail.getFeeCurrency());
                }
            }
        }
        Map<Long, DynamicObject> orgMap = BankPayBillFactory.getDataMap("bos_org", orgIdSet);
        Map<Long, DynamicObject> currencyMap = BankPayBillFactory.getDataMap("bd_currency", currencyIdSet);
        Map<Long, DynamicObject> acctMap = BankPayBillFactory.getDataMap("bd_accountbanks", acctIdSet);
        MainEntityType bankAgentBillEntityType = EntityMetadataCache.getDataEntityType((String)"bei_bankagentpay");
        long[] idArr = DB.genLongIds((String)"bei_bankagentpay", (int)payInfoList.size());
        for (int k = 0; k < payInfoList.size(); ++k) {
            PayInfo payInfo = payInfoList.get(k);
            DynamicObject bankAgentPayBill = new DynamicObject((DynamicObjectType)bankAgentBillEntityType);
            bankAgentPayBill.set("id", (Object)idArr[k]);
            bankAgentPayBill.set("company", (Object)orgMap.get(payInfo.getCompanyId()));
            bankAgentPayBill.set("accountbank", (Object)acctMap.get(payInfo.getPayAcctId()));
            bankAgentPayBill.set("currency", (Object)currencyMap.get(payInfo.getPayCurrencyId()));
            bankAgentPayBill.set("amount", (Object)payInfo.getTotalPayAmt());
            bankAgentPayBill.set("locamt", (Object)payInfo.getTotalLocalAmt());
            bankAgentPayBill.set("agentpaybillno", (Object)payInfo.getBillNo());
            bankAgentPayBill.set("sourcebillid", (Object)payInfo.getBillId());
            bankAgentPayBill.set("payunique", (Object)-1L);
            bankAgentPayBill.set("ispersonpay", (Object)payInfo.isPersonalPay());
            bankAgentPayBill.set("isencryption", (Object)payInfo.isEncryption());
            bankAgentPayBill.set("istranspay", (Object)payInfo.isOverseaPay());
            boolean isBankBillAudit = BeiParameterHelper.getAppBoolParameter((long)payInfo.getCompanyId(), (String)"bei002");
            boolean isNeedCommitBe = BeiParameterHelper.isBizBillCommitBe((long)payInfo.getCompanyId());
            if (!isNeedCommitBe && isBankBillAudit) {
                bankAgentPayBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            } else {
                bankAgentPayBill.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
            }
            bankAgentPayBill.set("bizdate", (Object)new Date());
            bankAgentPayBill.set("creator", (Object)RequestContext.get().getUserId());
            bankAgentPayBill.set("createtime", (Object)new Date());
            bankAgentPayBill.set("paystate", (Object)BeBillStatusEnum.OP.getValue());
            bankAgentPayBill.set("count", (Object)payInfo.getPayDetails().size());
            DynamicObjectCollection entryList = bankAgentPayBill.getDynamicObjectCollection("entrys");
            for (int i = 0; i < payInfo.getPayDetails().size(); ++i) {
                PayDetail payDetail = (PayDetail)payInfo.getPayDetails().get(i);
                DynamicObject entry = new DynamicObject(entryList.getDynamicObjectType());
                entry.set("status", (Object)BeBillStatusEnum.OP.getValue());
                entry.set("isagencypersonpay", (Object)payInfo.isAgencyPersonPay());
                entry.set("recname", (Object)payDetail.getRecName());
                entry.set("recbank", (Object)payDetail.getRecBankName());
                entry.set("recaccountbank", (Object)payDetail.getRecBankAcct());
                entry.set("recbanknumber", (Object)payDetail.getRecBankNum());
                entry.set("remark", (Object)payDetail.getRemark());
                entry.set("recprovince", (Object)payDetail.getProvince());
                entry.set("reccity", (Object)payDetail.getCity());
                entry.set("sourceentryid", (Object)payDetail.getEntryId());
                entry.set("recamount", (Object)payDetail.getRecAmount());
                entry.set("recemail", (Object)payDetail.getRecEmail());
                if (i == 0) {
                    bankAgentPayBill.set("usecn", (Object)payDetail.getUseCN());
                    if (payInfo.isOverseaPay()) {
                        bankAgentPayBill.set("payerfeetype", (Object)payDetail.getFeePayer());
                        bankAgentPayBill.set("payerfeecurrency", (Object)currencyMap.get(payDetail.getFeeCurrency()));
                        bankAgentPayBill.set("servicelevel", (Object)payDetail.getServiceLevel());
                        bankAgentPayBill.set("tolexchangerate", (Object)payDetail.getAgreeRate());
                        bankAgentPayBill.set("excontract", (Object)payDetail.getContractNo());
                        bankAgentPayBill.set("proxyaccno", (Object)payDetail.getProxyAcctNo());
                        bankAgentPayBill.set("proxyaccname", (Object)payDetail.getProxyAcctName());
                        bankAgentPayBill.set("proxybankcountry", (Object)payDetail.getProxyBankCountry());
                        bankAgentPayBill.set("proxybankarea", (Object)payDetail.getProxyBankArea());
                        bankAgentPayBill.set("proxyswiftcode", (Object)payDetail.getProxySwiftCode());
                        bankAgentPayBill.set("proxybankname", (Object)payDetail.getProxyBankName());
                        bankAgentPayBill.set("proxybankadds", (Object)payDetail.getProxyBankAddress());
                        bankAgentPayBill.set("payerfeeaccno", (Object)payDetail.getPayerFeeAcctNo());
                        bankAgentPayBill.set("settlementmethod", (Object)payDetail.getSettlementMethod());
                        bankAgentPayBill.set("mobile", (Object)payDetail.getMobile());
                    }
                }
                if (payInfo.isOverseaPay()) {
                    entry.set("incomeswiftcode", (Object)payDetail.getRecSwiftCode());
                    entry.set("deliverymethod", (Object)payDetail.getSendWay());
                    entry.set("chequetype", (Object)payDetail.getCheckType());
                    entry.set("chequeusage", (Object)payDetail.getCheckUsage());
                    entry.set("incomeradds", (Object)payDetail.getRecBankAddress());
                    entry.set("incomebankcode", (Object)payDetail.getRecRoutingNum());
                    entry.set("paymentmethod", (Object)payDetail.getPayMethod());
                    entry.set("transremarks", (Object)payDetail.getTransRemarks());
                }
                entryList.add((Object)entry);
            }
            bankAgentPayBill.set("billno", (Object)BankPayBillFactory.generateNumber("bei_bankagentpay", bankAgentPayBill, payInfo.getCompanyId().toString(), null));
            billList.add(bankAgentPayBill);
        }
        return BankPayBillFactory.doSaveBankBill(billList, "bei_bankagentpay", "cas_agentpaybill", "sourcebillid");
    }

    public static List<Triple<DynamicObject, Boolean, String>> generateBankTransBill(String entityName, List<TransInfo> transInfos) {
        ArrayList<DynamicObject> bankTransBillList = new ArrayList<DynamicObject>(transInfos.size());
        if (!CollectionUtils.isEmpty(transInfos)) {
            MainEntityType bankTransEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            Long currUser = RequestContext.get().getCurrUserId();
            Timestamp currDate = DateUtils.getCurrentTime();
            for (TransInfo transInfo : transInfos) {
                long pkId = DB.genLongId((String)bankTransEntityType.getAlias());
                DynamicObject bankTransBill = new DynamicObject((DynamicObjectType)bankTransEntityType, (Object)pkId);
                bankTransBill.set("bizdate", (Object)currDate);
                bankTransBill.set("creator", (Object)currUser);
                bankTransBill.set("createtime", (Object)currDate);
                boolean isBankBillAudit = BeiParameterHelper.getAppBoolParameter((long)transInfo.getMonAcctOrgId(), (String)"bei002");
                boolean isNeedCommitBe = BeiParameterHelper.isBizBillCommitBe((long)transInfo.getMonAcctOrgId());
                if (!isNeedCommitBe && isBankBillAudit) {
                    bankTransBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
                } else {
                    bankTransBill.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
                }
                bankTransBill.set("auditdate", (Object)currDate);
                bankTransBill.set("auditor", (Object)currUser);
                bankTransBill.set("paystate", (Object)BeBillStatusEnum.OP.getValue());
                bankTransBill.set("company", (Object)transInfo.getMonAcctOrgId());
                bankTransBill.set("accountbank", (Object)transInfo.getMonAcctId());
                bankTransBill.set("bank", (Object)transInfo.getBankId());
                bankTransBill.set("currency", (Object)transInfo.getMonAcctCurrencyId());
                bankTransBill.set("exchangerate", (Object)transInfo.getExchangeRate());
                bankTransBill.set("amount", (Object)transInfo.getTotalTransAmt());
                bankTransBill.set("sourcebillid", (Object)transInfo.getBillId());
                bankTransBill.set("payunique", (Object)-1L);
                bankTransBill.set("sourcetype", (Object)transInfo.getBillType());
                bankTransBill.set("locamt", (Object)transInfo.getTotalLocalAmt());
                bankTransBill.set("transbillno", (Object)transInfo.getBillNo());
                bankTransBill.set("expectdealtime", (Object)transInfo.getExpectDealTime());
                bankTransBill.set("ispersonpay", (Object)transInfo.isPersonalPay());
                if (entityName.equals("bei_banktransupbill")) {
                    bankTransBill.set("monacctname", (Object)transInfo.getMonAcctName());
                    bankTransBill.set("monacctorg", (Object)transInfo.getMonAcctOrgName());
                    bankTransBill.set("monacctnumber", (Object)transInfo.getMonAcctBankNum());
                    bankTransBill.set("monacctbankname", (Object)transInfo.getMonAcctBankName());
                    bankTransBill.set("monacctcity", (Object)transInfo.getMonAcctCity());
                    bankTransBill.set("monacctprovince", (Object)transInfo.getMonAcctProvince());
                }
                String transferNote = StringUtils.equals((CharSequence)"bei_banktransupbill", (CharSequence)entityName) ? ResManager.loadKDString((String)"\u8d44\u91d1\u4e0a\u5212", (String)"BankTransBillConverter_0", (String)"tmc-fca-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8d44\u91d1\u4e0b\u62e8", (String)"BankTransBillConverter_1", (String)"tmc-fca-common", (Object[])new Object[0]);
                DynamicObjectCollection entry = bankTransBill.getDynamicObjectCollection("entrys");
                List transDetails = transInfo.getTransDetails();
                int seq = 1;
                BigDecimal totalAmount = BigDecimal.ZERO;
                for (TransDetail transDetail : transDetails) {
                    DynamicObject newEntry = entry.addNew();
                    newEntry.set("seq", (Object)seq++);
                    newEntry.set("sourceentryid", (Object)transDetail.getEntryId());
                    newEntry.set("subacct", (Object)transDetail.getSubAcctId());
                    newEntry.set("remark", (Object)transferNote);
                    newEntry.set("transamt", (Object)transDetail.getAmount());
                    newEntry.set("status", (Object)BeBillStatusEnum.OP.getValue());
                    totalAmount = totalAmount.add(newEntry.getBigDecimal("transamt"));
                    newEntry.set("sonacctname", (Object)transDetail.getSubAcctName());
                    newEntry.set("sonacctorg", (Object)transDetail.getSubAcctOrgName());
                    newEntry.set("sonacctnumber", (Object)transDetail.getSubAcctBankNum());
                    newEntry.set("sonacctbankname", (Object)transDetail.getSubAcctBankName());
                    newEntry.set("sonacctcity", (Object)transDetail.getSubAcctCity());
                    newEntry.set("sonacctprovince", (Object)transDetail.getSubAcctProvince());
                }
                if (entry.size() == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6b63\u5e38\u4e14\u4ed8\u6b3e\u6210\u529f/\u88ab\u6253\u56de\u4e14\u4ed8\u6b3e\u5931\u8d25\u90e8\u5206\u7684\u5212\u62e8\u5355\u5206\u5f55", (String)"BankTransBillConverter_2", (String)"tmc-fca-common", (Object[])new Object[0]));
                }
                bankTransBill.set("count", (Object)entry.size());
                bankTransBill.set("amount", (Object)totalAmount);
                bankTransBill.set("billno", (Object)CodeRuleHelper.generateNumber((String)entityName, (DynamicObject)bankTransBill, null, null));
                bankTransBillList.add(bankTransBill);
            }
        }
        return BankPayBillFactory.doSaveBankBill(bankTransBillList, entityName, transInfos.get(0).getBillType(), "sourcebillid");
    }

    private static List<Triple<DynamicObject, Boolean, String>> doSaveBankBill(List<DynamicObject> bankBillList, String entityName, String srcEntity, String srcBillProp) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("srcEntityNumber", srcEntity);
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"save", (String)entityName, (DynamicObject[])bankBillList.toArray(new DynamicObject[0]), (OperateOption)option);
        if (!opResult.isSuccess()) {
            String errInfo = TmcOperateServiceHelper.decodeMultiErrorMsg((OperationResult)opResult);
            logger.error(errInfo);
        }
        List successIdList = opResult.getSuccessPkIds();
        ArrayList<Triple<DynamicObject, Boolean, String>> resultList = new ArrayList<Triple<DynamicObject, Boolean, String>>();
        if (successIdList.size() > 0) {
            DynamicObject[] bankAgentBill = TmcDataServiceHelper.load((Object[])successIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
            List successResultList = Arrays.stream(bankAgentBill).map(o -> Triple.of((Object)o, (Object)Boolean.TRUE, (Object)"")).collect(Collectors.toList());
            resultList.addAll(successResultList);
        }
        if (!opResult.isSuccess()) {
            List errInfo = opResult.getAllErrorOrValidateInfo();
            Map errMap = errInfo.stream().collect(Collectors.groupingBy(IOperateInfo::getPkValue, Collectors.mapping(IOperateInfo::getMessage, Collectors.reducing((a, b) -> a + " " + b))));
            List errBillList = bankBillList.stream().filter(o -> !successIdList.contains(o.getPkValue())).collect(Collectors.toList());
            String defErrMsg = ResManager.loadKDString((String)"\u751f\u6210\u94f6\u884c\u5355\u636e\u5931\u8d25\u3002", (String)"BankPayBillFactory_1", (String)"tmc-bei-business", (Object[])new Object[0]) + "\uff0c" + TmcOperateServiceHelper.decodeErrorMsg((OperationResult)opResult);
            for (DynamicObject errBill : errBillList) {
                Object errPk = errBill.getPkValue();
                Optional<String> errMsgOption = errMap.getOrDefault(errPk, Optional.empty());
                String errMsg = errMsgOption.orElse(defErrMsg);
                Triple result = Triple.of((Object)errBill, (Object)Boolean.FALSE, (Object)errMsg);
                resultList.add((Triple<DynamicObject, Boolean, String>)result);
            }
        }
        return resultList;
    }

    private static Map<Long, DynamicObject> getDataMap(String entityName, Collection<Long> idList) {
        DynamicObject[] dataArr = TmcDataServiceHelper.load((Object[])idList.stream().filter(Objects::nonNull).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(dataArr.length);
        for (DynamicObject data : dataArr) {
            dataMap.put((Long)data.getPkValue(), data);
        }
        return dataMap;
    }

    private static String generateNumber(String entityId, DynamicObject dataInfo, String orgID, String defaultVal) {
        String number;
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)entityId, (DynamicObject)dataInfo, (String)orgID);
        if (codeRuleInfo != null) {
            CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)dataInfo);
            number = codeRuleInfo.getNumber();
        } else {
            number = defaultVal;
        }
        return number;
    }
}

