/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bei.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.bei.business.opservice.param.BalanceQueryParam;
import kd.tmc.bei.business.opservice.queryinfo.BalanceQueryInfo;
import kd.tmc.bei.business.opservice.result.BalanceResult;
import kd.tmc.bei.common.resource.BeiBizResource;
import kd.tmc.fbp.common.util.DateUtils;

public class EBBalanceQueryService {
    private static final Log logger = LogFactory.getLog(EBBalanceQueryService.class);
    private List<BalanceResult> results = new ArrayList<BalanceResult>();
    private BalanceQueryParam balanceQueryParam;

    public EBBalanceQueryService(BalanceQueryParam balanceQueryParam) {
        this.balanceQueryParam = balanceQueryParam;
    }

    public List<BalanceResult> queryBatchBalance() {
        DynamicObject[] accountBanks = BusinessDataServiceHelper.load((Object[])this.balanceQueryParam.getIdList().toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_accountbanks"));
        int size = accountBanks.length;
        HashMap<String, DynamicObject> accountBankMap = new HashMap<String, DynamicObject>(size);
        HashMap<String, String> number_BankId = new HashMap<String, String>(size);
        HashMap<String, String> bankId_Number = new HashMap<String, String>(size);
        HashMap<Map<String, Object>, Set<String>> bankInterface_AcctIds = new HashMap<Map<String, Object>, Set<String>>();
        for (DynamicObject accountBank : accountBanks) {
            String accountBankId = accountBank.getString("id");
            String accountBankNumber = accountBank.getString("bankaccountnumber");
            String bankinterface = accountBank.getString("bankinterface");
            accountBankMap.put(accountBankId, accountBank);
            number_BankId.put(accountBankNumber, accountBankId);
            bankId_Number.put(accountBankId, accountBankNumber);
            DynamicObjectCollection currencys = new DynamicObjectCollection();
            if (this.balanceQueryParam.getCurr() == null) {
                for (DynamicObject currency : accountBank.getDynamicObjectCollection("currency")) {
                    currencys.add((Object)currency.getDynamicObject("fbasedataid"));
                }
            } else {
                currencys.add((Object)this.balanceQueryParam.getCurr());
            }
            for (DynamicObject currency : currencys) {
                HashMap<String, Object> mapForCurrAndBankInterFace = new HashMap<String, Object>();
                mapForCurrAndBankInterFace.put("currency", currency);
                mapForCurrAndBankInterFace.put("bankinterface", bankinterface);
                if (CollectionUtils.isEmpty((Collection)((Collection)bankInterface_AcctIds.get(mapForCurrAndBankInterFace)))) {
                    HashSet<String> bankAccIds = new HashSet<String>();
                    bankAccIds.add(accountBankId);
                    bankInterface_AcctIds.put(mapForCurrAndBankInterFace, bankAccIds);
                    continue;
                }
                Set bankIdSet = (Set)bankInterface_AcctIds.get(mapForCurrAndBankInterFace);
                bankIdSet.add(accountBankId);
            }
        }
        int batchDownAcctCount = 1;
        DynamicObjectCollection servConfInits = QueryServiceHelper.query((String)"bei_serviceconfig", (String)"id,batchdownstrategy,batchdownaccountsnum", null);
        if (servConfInits.size() > 0 && 0 == (batchDownAcctCount = ((DynamicObject)servConfInits.get(0)).getInt("batchdownaccountsnum"))) {
            batchDownAcctCount = 1;
        }
        BalanceQueryInfo balanceQueryInfoCurr = new BalanceQueryInfo(this.balanceQueryParam);
        Date beginDate = balanceQueryInfoCurr.getBalanceQueryParam().getBeginDate();
        Date endDate = balanceQueryInfoCurr.getBalanceQueryParam().getEndDate();
        if (endDate.compareTo(DateUtils.getCurrentDate()) >= 0) {
            logger.info("is start to get curr data ");
            balanceQueryInfoCurr.getBalanceQueryParam().setBeginDate(endDate);
            this.getBalanceData(accountBankMap, bankInterface_AcctIds, number_BankId, bankId_Number, balanceQueryInfoCurr, batchDownAcctCount);
            logger.info("start to get history data after get curr ");
            Date endBeforeDay = DateUtils.getLastDay((Date)endDate, (int)1);
            if (endBeforeDay.compareTo(beginDate) >= 0) {
                balanceQueryInfoCurr.getBalanceQueryParam().setEndDate(endBeforeDay);
                balanceQueryInfoCurr.getBalanceQueryParam().setBeginDate(beginDate);
                this.getBalanceData(accountBankMap, bankInterface_AcctIds, number_BankId, bankId_Number, balanceQueryInfoCurr, batchDownAcctCount);
            }
            logger.info("end to get history data after get curr ");
        } else {
            logger.info("start to get history data");
            this.getBalanceData(accountBankMap, bankInterface_AcctIds, number_BankId, bankId_Number, balanceQueryInfoCurr, batchDownAcctCount);
            logger.info("end to get history data ");
        }
        return this.results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getBalanceData(Map<String, DynamicObject> accountBankMap, Map<Map<String, Object>, Set<String>> bankInterface_AcctIds, Map<String, String> number_BankId, Map<String, String> bankId_Number, BalanceQueryInfo balanceQueryInfo, Integer batchDownAcctCount) {
        logger.info("bankInterfaceAccounMap is that:" + SerializationUtils.toJsonString(bankInterface_AcctIds));
        for (Map.Entry<Map<String, Object>, Set<String>> group : bankInterface_AcctIds.entrySet()) {
            Set<String> bankIds = group.getValue();
            Map<String, Object> keyMap = group.getKey();
            ArrayList<String> bankAccts = new ArrayList<String>(bankIds);
            int bankSize = bankIds.size();
            for (int i = 0; i < bankSize; i += batchDownAcctCount.intValue()) {
                Map<String, Object> balanceResultMap;
                List subList = i + batchDownAcctCount >= bankSize ? bankAccts.subList(i, bankSize) : bankAccts.subList(i, i + batchDownAcctCount);
                ArrayList<String> bankNumList = new ArrayList<String>(10);
                ArrayList<String> swCodeList = new ArrayList<String>(10);
                for (String bankId : subList) {
                    bankNumList.add(bankId_Number.get(bankId));
                    DynamicObject account = accountBankMap.get(bankId);
                    DynamicObject bank = account.getDynamicObject("bank");
                    String swCode = "";
                    if (bank != null) {
                        swCode = bank.getString("swift_code");
                    }
                    swCodeList.add(swCode);
                }
                balanceQueryInfo.setBankAccts(bankNumList);
                balanceQueryInfo.setSwiftCode(swCodeList);
                DynamicObject accountBankDy = accountBankMap.get(subList.get(0));
                DynamicObject currency = (DynamicObject)keyMap.get("currency");
                balanceQueryInfo.setBankAcct(accountBankDy);
                balanceQueryInfo.setCurrency(currency);
                balanceQueryInfo.setBankVersion(keyMap.get("bankinterface").toString());
                balanceQueryInfo.setOrgId(accountBankDy.getDynamicObject("openorg").getLong("id"));
                String flag = SerializationUtils.toJsonString(keyMap);
                logger.info("the " + i + "time keyMap is:" + flag + " is start!");
                logger.info("the " + i + "time param is:" + SerializationUtils.toJsonString((Object)balanceQueryInfo));
                BalanceResult balanceResult = null;
                String errorMsg = "";
                try {
                    balanceResult = EBServiceFacadeFactory.getBankService().queryBatchBalance(balanceQueryInfo, new DynamicObject[0]);
                    errorMsg = balanceResult.getErrMsg();
                }
                catch (Exception e) {
                    logger.error("queryBatchBalance Exception:", (Throwable)e);
                    errorMsg = e.getMessage();
                }
                finally {
                    logger.info("the " + i + "time keyMap is:" + flag + " is end!");
                }
                if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
                    logger.info("queryBatchBalance errorMsg:", (Object)errorMsg);
                    for (String bankId : bankIds) {
                        Map.Entry<String, Object> bankNumber = bankId_Number.get(bankId);
                        this.errorsInfo((String)((Object)bankNumber), currency, number_BankId, errorMsg);
                    }
                    continue;
                }
                if (balanceResult == null || (balanceResultMap = balanceResult.getBalanceMap()) == null) continue;
                for (Map.Entry<String, Object> bankNumber : balanceResultMap.entrySet()) {
                    if (!(balanceResultMap.get(bankNumber.getKey()) instanceof String)) continue;
                    this.errorsInfo((String)bankNumber.getKey(), currency, number_BankId, balanceResultMap.get(bankNumber.getKey()).toString());
                }
            }
        }
    }

    private void errorsInfo(String bankNumber, DynamicObject currency, Map<String, String> maps, String errMsg) {
        String message = String.format(new BeiBizResource().getTipsDownloadFail(), bankNumber, currency.getString("number"), errMsg);
        BalanceResult result = new BalanceResult();
        result.setErrMsg(message);
        result.setBillId(Long.valueOf(maps.get(bankNumber)));
        this.results.add(result);
    }
}

