/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusDetail;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;

public class SyncStatusInfoFactory {
    public static List<SyncStatusInfo> createSyncStatusInfo(String entityName, List<DynamicObject> bankBillList) {
        if ("bei_bankpaybill".equals(entityName)) {
            return SyncStatusInfoFactory.createSyncPayBillStatusInfo(bankBillList);
        }
        if ("bei_bankagentpay".equals(entityName)) {
            return SyncStatusInfoFactory.createSyncAgentPayBillStatusInfo(bankBillList);
        }
        if ("bei_banktransupbill".equals(entityName) || "bei_banktransdownbill".equals(entityName)) {
            return SyncStatusInfoFactory.createSyncTransPayBillStatusInfo(bankBillList, entityName);
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u4ed8\u6b3e\u5355\u636e\u7c7b\u578b: %s\u3002", (String)"BankPayBillFactory_0", (String)"tmc-bei-business", (Object[])new Object[0]), entityName));
    }

    public static List<SyncStatusInfo> createSyncPayBillStatusInfo(List<DynamicObject> bankPayBillList) {
        ArrayList<SyncStatusInfo> infoList = new ArrayList<SyncStatusInfo>(bankPayBillList.size());
        for (DynamicObject bankPayBill : bankPayBillList) {
            SyncStatusInfo syncInfo = new SyncStatusInfo();
            ArrayList<SyncStatusDetail> detailList = new ArrayList<SyncStatusDetail>(bankPayBillList.size());
            syncInfo.setDetailList(detailList);
            syncInfo.setEntityType("cas_paybill");
            SyncStatusDetail syncDetail = new SyncStatusDetail();
            detailList.add(syncDetail);
            syncInfo.setStatusCode(EBResultStatusCode.SUCCESS);
            syncInfo.setBankBillId((Long)bankPayBill.getPkValue());
            syncInfo.setPayBillId(Long.valueOf(bankPayBill.getLong("sourcebillid")));
            syncInfo.setBankPayStatus(bankPayBill.getString("bankpaystate"));
            syncDetail.setEbStatusMsg(bankPayBill.getString("bankreturnmsg"));
            syncDetail.setBankDetailSeqId(bankPayBill.getString("statementrefno"));
            if (BeBillStatusEnum.TS.getValue().equals(bankPayBill.getString("bankpaystate"))) {
                syncDetail.setPayDate(bankPayBill.getDate("paytime"));
            }
            infoList.add(syncInfo);
        }
        return infoList;
    }

    public static List<SyncStatusInfo> createSyncAgentPayBillStatusInfo(List<DynamicObject> bankAgentBillList) {
        ArrayList<SyncStatusInfo> infoList = new ArrayList<SyncStatusInfo>(bankAgentBillList.size());
        for (DynamicObject bankAgentBill : bankAgentBillList) {
            SyncStatusInfo syncInfo = new SyncStatusInfo();
            ArrayList<SyncStatusDetail> syncStatusList = new ArrayList<SyncStatusDetail>(bankAgentBillList.size());
            syncInfo.setStatusCode(EBResultStatusCode.SUCCESS);
            syncInfo.setBankBillId((Long)bankAgentBill.getPkValue());
            syncInfo.setPayBillId(Long.valueOf(bankAgentBill.getLong("sourcebillid")));
            syncInfo.setDetailList(syncStatusList);
            syncInfo.setEntityType("cas_agentpaybill");
            syncInfo.setBankPayStatus(bankAgentBill.getString("paystate"));
            DynamicObjectCollection entryList = bankAgentBill.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entryList) {
                SyncStatusDetail syncDetail = new SyncStatusDetail();
                syncStatusList.add(syncDetail);
                syncDetail.setEbStatusMsg(entry.getString("bankreturnmsg"));
                syncDetail.setBankDetailSeqId(entry.getString("bankcheckflag"));
                syncDetail.setBankEntryPayStatus(entry.getString("status"));
                syncDetail.setPayBillEntryId(Long.valueOf(entry.getLong("sourceentryid")));
            }
            infoList.add(syncInfo);
        }
        return infoList;
    }

    public static List<SyncStatusInfo> createSyncTransPayBillStatusInfo(List<DynamicObject> bankTransBillList, String entityName) {
        ArrayList<SyncStatusInfo> infoList = new ArrayList<SyncStatusInfo>(bankTransBillList.size());
        for (DynamicObject bankTransBill : bankTransBillList) {
            SyncStatusInfo syncInfo = new SyncStatusInfo();
            ArrayList<SyncStatusDetail> syncStatusList = new ArrayList<SyncStatusDetail>(bankTransBillList.size());
            syncInfo.setStatusCode(EBResultStatusCode.SUCCESS);
            syncInfo.setBankBillId((Long)bankTransBill.getPkValue());
            syncInfo.setPayBillId(Long.valueOf(bankTransBill.getLong("sourcebillid")));
            syncInfo.setDetailList(syncStatusList);
            if ("bei_banktransupbill".equals(entityName)) {
                syncInfo.setEntityType("fca_transupbill");
            } else {
                syncInfo.setEntityType("fca_transdownbill");
            }
            syncInfo.setBankPayStatus(bankTransBill.getString("paystate"));
            DynamicObjectCollection entryList = bankTransBill.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entryList) {
                SyncStatusDetail syncDetail = new SyncStatusDetail();
                syncStatusList.add(syncDetail);
                syncDetail.setBankMsg(entry.getString("bankreturnmsg"));
                syncDetail.setEbStatusMsg(entry.getString("bankreturnmsg"));
                syncDetail.setBankDetailSeqId(entry.getString("bankcheckflag"));
                syncDetail.setBankEntryPayStatus(entry.getString("status"));
                syncDetail.setPayBillEntryId(Long.valueOf(entry.getLong("sourceentryid")));
            }
            infoList.add(syncInfo);
        }
        return infoList;
    }
}

