/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.log;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.log.bean.BankLogDetail;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;

public class BankLogInfoFactory {
    public static BankLogInfo generateBankLogInfo(List<DynamicObject> dataList) {
        String entityName;
        switch (entityName = dataList.get(0).getDynamicObjectType().getName()) {
            case "bei_bankagentpay": {
                return BankLogInfoFactory.generateBankAgentPayLog(dataList);
            }
            case "bei_bankpaybill": {
                return BankLogInfoFactory.generateBankPayLog(dataList);
            }
            case "bei_banktransupbill": 
            case "bei_banktransdownbill": {
                return BankLogInfoFactory.generateBankTransLog(dataList);
            }
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u4e1a\u52a1\u7c7b\u578b:%s\u3002", (String)"BankLogInfoFactory_0", (String)"tmc-bei-business", (Object[])new Object[0]), entityName));
    }

    public static BankLogInfo generateBankPayLog(List<DynamicObject> dataList) {
        BankLogInfo logInfo = new BankLogInfo();
        ArrayList<BankLogDetail> detailList = new ArrayList<BankLogDetail>(dataList.size());
        logInfo.setLogDetailList(detailList);
        String entityName = "bei_bankpaybill";
        BigDecimal totalAmt = BigDecimal.ZERO;
        Long currencyId = dataList.get(0).getLong("currency.id");
        DynamicObject bankAcct = dataList.get(0).getDynamicObject("accountbank");
        long bankAcctCompanyId = bankAcct.getLong("company.id");
        logInfo.setOrgid(Long.valueOf(bankAcctCompanyId));
        for (DynamicObject data : dataList) {
            BankLogDetail bankDetail = new BankLogDetail();
            bankDetail.setBillId(Long.valueOf(data.getLong("id")));
            bankDetail.setBillNumber(data.getString("billno"));
            bankDetail.setBillType(entityName);
            if (EmptyUtil.isNoEmpty((DynamicObject)data.getDynamicObject("company"))) {
                bankDetail.setBillOrgId((Long)data.getDynamicObject("company").getPkValue());
            } else {
                bankDetail.setBillOrgId(Long.valueOf(RequestContext.get().getOrgId()));
            }
            bankDetail.setAcctBankId((Long)data.getDynamicObject("accountbank").getPkValue());
            bankDetail.setBillType(entityName);
            bankDetail.setPayAmt(data.getBigDecimal("amount"));
            totalAmt = totalAmt.add(bankDetail.getPayAmt());
            if (data.getDynamicObjectType().getProperties().containsKey((Object)"sourcebillid")) {
                bankDetail.setPayBillId(Long.valueOf(data.getLong("sourcebillid")));
                bankDetail.setPayBillType("cas_paybill");
            }
            detailList.add(bankDetail);
        }
        logInfo.setPayTotalAmt(totalAmt);
        logInfo.setPayCurrencyId(currencyId);
        logInfo.setEntityName(entityName);
        return logInfo;
    }

    public static BankLogInfo generateBankAgentPayLog(List<DynamicObject> dataList) {
        BankLogInfo logInfo = new BankLogInfo();
        ArrayList<BankLogDetail> detailList = new ArrayList<BankLogDetail>(dataList.size());
        logInfo.setLogDetailList(detailList);
        BigDecimal totalAmt = BigDecimal.ZERO;
        Long currencyId = dataList.get(0).getLong("currency.id");
        DynamicObject bankAcct = dataList.get(0).getDynamicObject("accountbank");
        if (EmptyUtil.isNoEmpty((DynamicObject)bankAcct)) {
            long bankAcctCompanyId = bankAcct.getLong("company.id");
            logInfo.setOrgid(Long.valueOf(bankAcctCompanyId));
        } else {
            logInfo.setOrgid(Long.valueOf(RequestContext.get().getOrgId()));
        }
        String entityName = "bei_bankagentpay";
        for (DynamicObject data : dataList) {
            BankLogDetail bankDetail = new BankLogDetail();
            bankDetail.setBillId(Long.valueOf(data.getLong("id")));
            bankDetail.setBillNumber(data.getString("billno"));
            bankDetail.setBillType(entityName);
            if (EmptyUtil.isNoEmpty((DynamicObject)data.getDynamicObject("company"))) {
                bankDetail.setBillOrgId((Long)data.getDynamicObject("company").getPkValue());
            } else {
                bankDetail.setBillOrgId(Long.valueOf(RequestContext.get().getOrgId()));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)data.getDynamicObject("accountbank"))) {
                bankDetail.setAcctBankId((Long)data.getDynamicObject("accountbank").getPkValue());
            }
            bankDetail.setBillType(entityName);
            bankDetail.setPayAmt(data.getBigDecimal("amount"));
            totalAmt = totalAmt.add(bankDetail.getPayAmt());
            if (data.getDynamicObjectType().getProperties().containsKey((Object)"sourcebillid")) {
                bankDetail.setPayBillId(Long.valueOf(data.getLong("sourcebillid")));
                bankDetail.setPayBillType("cas_agentpaybill");
            }
            detailList.add(bankDetail);
        }
        logInfo.setPayCurrencyId(currencyId);
        logInfo.setPayTotalAmt(totalAmt);
        logInfo.setEntityName(entityName);
        return logInfo;
    }

    public static BankLogInfo generateBankTransLog(List<DynamicObject> dataList) {
        BankLogInfo logInfo = new BankLogInfo();
        ArrayList<BankLogDetail> detailList = new ArrayList<BankLogDetail>(dataList.size());
        logInfo.setLogDetailList(detailList);
        DynamicObject bankAcct = dataList.get(0).getDynamicObject("accountbank");
        long bankAcctCompanyId = bankAcct.getLong("company.id");
        logInfo.setOrgid(Long.valueOf(bankAcctCompanyId));
        String entityName = dataList.get(0).getDynamicObjectType().getName();
        BigDecimal totalAmt = BigDecimal.ZERO;
        Long currencyId = dataList.get(0).getLong("currency.id");
        for (DynamicObject data : dataList) {
            BankLogDetail bankDetail = new BankLogDetail();
            bankDetail.setBillId(Long.valueOf(data.getLong("id")));
            bankDetail.setBillNumber(data.getString("billno"));
            bankDetail.setBillType(entityName);
            bankDetail.setBillOrgId((Long)data.getDynamicObject("company").getPkValue());
            bankDetail.setAcctBankId((Long)data.getDynamicObject("accountbank").getPkValue());
            bankDetail.setBillType(entityName);
            bankDetail.setPayAmt(data.getBigDecimal("amount"));
            totalAmt = totalAmt.add(bankDetail.getPayAmt());
            if (data.getDynamicObjectType().getProperties().containsKey((Object)"sourcebillid")) {
                bankDetail.setPayBillId(Long.valueOf(data.getLong("sourcebillid")));
                String payBillType = "bei_banktransupbill".equalsIgnoreCase(entityName) ? "fca_transupbill" : "fca_transdownbill";
                bankDetail.setPayBillType(payBillType);
            }
            detailList.add(bankDetail);
        }
        logInfo.setPayCurrencyId(currencyId);
        logInfo.setPayTotalAmt(totalAmt);
        logInfo.setEntityName(entityName);
        return logInfo;
    }

    public static BankLogInfo generateBankAcctLog(DynamicObject bankAcct) {
        BankLogInfo info = new BankLogInfo();
        info.setSourceId(Long.valueOf(bankAcct.getLong("id")));
        info.setBillNo(bankAcct.getString("bankaccountnumber"));
        info.setOrgid(Long.valueOf(bankAcct.getLong("company.id")));
        info.setEntityName("bd_accountbanks");
        return info;
    }
}

