/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.bei.business.ebservice.request.PayRequestBuilder;
import kd.tmc.bei.business.ebservice.request.datasource.IEBRequestDataSource;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayBody;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayDetail;

public class OverseaPayRequestBuilder
extends PayRequestBuilder {
    private static final Log logger = LogFactory.getLog(OverseaPayRequestBuilder.class);

    public OverseaPayRequestBuilder(IEBRequestDataSource dataSource, boolean batchRollBack) {
        super("overseaPay", dataSource, batchRollBack);
    }

    @Override
    protected String getBizType() {
        return "overseaPay";
    }

    @Override
    protected String getOperationName() {
        return "overseaPay";
    }

    @Override
    protected PayBody buildBody() {
        PayBody body = super.buildBody();
        List payDetailList = body.getDetails();
        for (PayDetail payDetail : payDetailList) {
            String bankBillId = payDetail.getDetailSeqID();
            List attachmentList = AttachmentServiceHelper.getAttachments((String)"bei_bankpaybill", (Object)bankBillId, (String)"attachmentpanel", (boolean)false);
            logger.info("bei_bankpaybill bankBillId:{} attachment file size is {}", (Object)bankBillId, (Object)attachmentList.size());
            String fileList = "";
            if (CollectionUtils.isNotEmpty((Collection)attachmentList)) {
                ArrayList<String> fileUrlList = new ArrayList<String>(attachmentList.size());
                for (Map attachment : attachmentList) {
                    String url = (String)attachment.get("url");
                    fileUrlList.add(url);
                }
                if (!fileUrlList.isEmpty()) {
                    fileList = String.join((CharSequence)";", fileUrlList);
                }
            }
            payDetail.setFileList(fileList);
        }
        return body;
    }
}

