/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.request.datasource.bankagent;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.bei.business.ebservice.request.datasource.IEBRequestDataSource;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.enums.BankReturnStatusEnum;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayDetail;
import kd.tmc.fbp.webapi.ebentity.biz.paystatus.PayStatusBody;
import kd.tmc.fbp.webapi.ebentity.biz.paystatus.PayStatusDetail;

public class BankAgentRequestDataSource
implements IEBRequestDataSource {
    private List<DynamicObject> bankAgentBillList;
    private String batchSeqId;

    public BankAgentRequestDataSource(DynamicObject bankAgentBill) {
        this.batchSeqId = bankAgentBill.getString("serialnumber");
        this.bankAgentBillList = Collections.singletonList(bankAgentBill);
    }

    public BankAgentRequestDataSource(String batchSeqId, List<DynamicObject> bankAgentBillList) {
        this.batchSeqId = batchSeqId;
        this.bankAgentBillList = bankAgentBillList;
    }

    @Override
    public String getBatchSeqId() {
        return this.batchSeqId;
    }

    @Override
    public String getBatchBizNo() {
        return this.batchSeqId;
    }

    @Override
    public String getAcctNo() {
        return this.bankAgentBillList.get(0).getDynamicObject("accountbank").getString("bankaccountnumber");
    }

    @Override
    public String getCurrency() {
        return this.bankAgentBillList.get(0).getDynamicObject("currency").getString("number");
    }

    @Override
    public List<PayDetail> getPayDetail() {
        ArrayList<PayDetail> details = new ArrayList<PayDetail>(10);
        for (DynamicObject bankAgentBill : this.bankAgentBillList) {
            boolean isIndividual = bankAgentBill.getBoolean("ispersonpay");
            boolean isTranspay = bankAgentBill.getBoolean("istranspay");
            DynamicObjectCollection entry = bankAgentBill.getDynamicObjectCollection("entrys");
            Date date = new Date();
            HashMap<String, String> extDatas = new HashMap<String, String>(16);
            String abstractMsg = EmptyUtil.isEmpty((String)bankAgentBill.getString("description")) ? "" : bankAgentBill.getString("description");
            for (DynamicObject entryInfo : entry) {
                PayDetail detail = new PayDetail();
                detail.setBatchSeqID(this.batchSeqId);
                extDatas.put("idempotency", "true");
                detail.setDetailSeqID(entryInfo.getPkValue().toString());
                detail.setDetailBizNo(entryInfo.getString("sourceentryid"));
                detail.setIncomeAccName(entryInfo.getString("recname"));
                detail.setIncomeAccNo(entryInfo.getString("recaccountbank"));
                detail.setIncomeBankName(entryInfo.getString("recbank"));
                detail.setIncomeCnapsCode(entryInfo.getString("recbanknumber"));
                detail.setIncomeBankAddress(entryInfo.getString("reccity"));
                detail.setIncomeCountry("CHN");
                detail.setIncomeProvince(entryInfo.getString("recprovince"));
                detail.setIncomeCity(entryInfo.getString("reccity"));
                BigDecimal amount = entryInfo.getBigDecimal("recamount").setScale(2, 4);
                detail.setAmount(String.valueOf(amount));
                Date expectDealTime = bankAgentBill.getDate("expectdealtime") == null ? date : bankAgentBill.getDate("expectdealtime");
                detail.setBookingTime(String.valueOf(expectDealTime.getTime()));
                String entryRemark = entryInfo.getString("remark");
                if (EmptyUtil.isEmpty((String)entryRemark)) {
                    entryRemark = ResManager.loadKDString((String)"\u4ee3\u53d1", (String)"BankRequestBodyHelper_0", (String)"tmc-bei-business", (Object[])new Object[0]);
                }
                detail.setExplanation(entryRemark);
                detail.setAbstractMsg(abstractMsg);
                detail.setUrgent(bankAgentBill.getBoolean("isurgent"));
                detail.setForce(false);
                detail.setUseCode("-1");
                detail.setUseCN(bankAgentBill.getString("usecn"));
                detail.setVerifyField("");
                detail.setEmail(entryInfo.getString("recemail"));
                if (isIndividual) {
                    detail.setIncomeType("individual");
                } else {
                    detail.setIncomeType("company");
                }
                detail.setMergeFlag(entryInfo.getBoolean("isagencypersonpay"));
                detail.setCertType(entryInfo.getString("certtype"));
                detail.setCertNum(entryInfo.getString("certnum"));
                if (isTranspay) {
                    detail.setIncomeAreaCode("");
                    detail.setIncomeSwiftCode(entryInfo.getString("incomeswiftcode"));
                    detail.setFeeNo("");
                    detail.setPayerFeeType(bankAgentBill.getString("payerfeetype"));
                    detail.setPayerFeeAccNo(bankAgentBill.getString("payerfeeaccno"));
                    DynamicObject feeCurrency = bankAgentBill.getDynamicObject("payerfeecurrency");
                    if (feeCurrency != null) {
                        detail.setPayerFeeCurrency(feeCurrency.getString("number"));
                    }
                    detail.setPaymentMethod(entryInfo.getString("paymentmethod"));
                    detail.setServiceLevel(bankAgentBill.getString("servicelevel"));
                    detail.setExchangeRate(bankAgentBill.getBigDecimal("tolexchangerate").setScale(6, 4).toString());
                    detail.setActualAmount(detail.getAmount());
                    detail.setIncomeBankCode(entryInfo.getString("incomebankcode"));
                    detail.setTransactionRemarks(entryInfo.getString("transremarks"));
                    detail.setPayCurrency(bankAgentBill.getDynamicObject("currency").getString("number"));
                    detail.setExContract(bankAgentBill.getString("excontract"));
                    detail.setProxyAccNo(bankAgentBill.getString("proxyaccno"));
                    detail.setProxyAccName(bankAgentBill.getString("proxyaccname"));
                    detail.setProxyBankCountry(bankAgentBill.getString("proxybankcountry"));
                    detail.setProxyBankArea(bankAgentBill.getString("proxybankarea"));
                    detail.setProxyBankSwiftCode(bankAgentBill.getString("proxyswiftcode"));
                    detail.setProxyBankName(bankAgentBill.getString("proxybankname"));
                    detail.setProxyBankAddress(bankAgentBill.getString("proxybankadds"));
                    detail.setProxyFeeType(detail.getPayerFeeType());
                    detail.setProxyFeeCurrency(detail.getPayerFeeCurrency());
                    detail.setIncomeAddress(entryInfo.getString("incomeradds"));
                    detail.setIncomeBankLocalClearingCode("");
                    detail.setIncomeBankLocalClearingBranchCode("");
                    detail.setIncomeBankLocalClearingBranchsubCode("");
                    detail.setReceiverName(detail.getIncomeAccName());
                    detail.setReceiverAddress(entryInfo.getString("incomeradds"));
                    detail.setIncomeBankCountry(detail.getIncomeCountry());
                    detail.setDeliveryMethod(entryInfo.getString("deliverymethod"));
                    detail.setChequeType(entryInfo.getString("chequetype"));
                    detail.setChequeUsage(entryInfo.getString("chequeusage"));
                    detail.setSettlementMethod(bankAgentBill.getString("settlementmethod"));
                    detail.setMobile(entryInfo.getString("mobile"));
                    detail.setBeneFPSId(entryInfo.getString("paymentfps"));
                    detail.setBeneCountryCode(entryInfo.getString("paymentareacode"));
                    detail.setNotify(Boolean.valueOf(entryInfo.getBoolean("inforpayment")));
                    detail.setBeneEmail(entryInfo.getString("informrecemail"));
                    extDatas.put("applyname", bankAgentBill.getString("applyname"));
                    extDatas.put("applyphone", bankAgentBill.getString("applyphone"));
                }
                detail.setExtData(JSON.toJSONString(extDatas));
                details.add(detail);
            }
        }
        return details;
    }

    @Override
    public PayStatusBody getUpdateBody(Map<Long, String> updateStatusMap) {
        if (this.bankAgentBillList.size() != 1) {
            throw new IllegalArgumentException("Bank bill size can not > 1");
        }
        DynamicObject bankAgentBill = this.bankAgentBillList.get(0);
        ArrayList<PayStatusDetail> details = new ArrayList<PayStatusDetail>(updateStatusMap.size());
        for (DynamicObject entry : bankAgentBill.getDynamicObjectCollection("entrys")) {
            Long key = entry.getLong("id");
            if (!updateStatusMap.containsKey(key)) continue;
            String entry_Status = updateStatusMap.get(key);
            if (BeBillStatusEnum.NC.getValue().equals(entry_Status)) continue;
            PayStatusDetail detail = new PayStatusDetail();
            detail.setDetailSeqID(key.toString());
            detail.setBatchSeqID(bankAgentBill.getString("serialnumber"));
            detail.setModifyStatus(entry_Status.equals(BeBillStatusEnum.TS.getValue()) ? 12 : 13);
            detail.setUpdateStatus(BankReturnStatusEnum.BANK_SUCCESS.getValue());
            detail.setUpdateReason(ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u7ecf\u6838\u5b9e\uff0c\u624b\u5de5\u4fee\u6539\u72b6\u6001\u3002", (String)"BankRequestBodyHelper_2", (String)"tmc-bei-business", (Object[])new Object[0]));
            DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getUserId(), (String)"bos_user");
            detail.setOperator(user.getLocaleString("name").getLocaleValue());
            details.add(detail);
        }
        PayStatusBody body = new PayStatusBody();
        if (details.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u6570\u636e\u672a\u53d8\u5316\uff0c\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BankRequestBodyHelper_3", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
        body.setTotalCount(details.size());
        body.setDetails(details);
        return body;
    }
}

