/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.request.datasource.bankpay;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.bei.business.ebservice.request.datasource.IEBRequestDataSource;
import kd.tmc.bei.common.constants.BizConstant;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.enums.BankReturnStatusEnum;
import kd.tmc.fbp.service.ebservice.errorcode.BankPayingErrorCode;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayDetail;
import kd.tmc.fbp.webapi.ebentity.biz.paystatus.PayStatusBody;
import kd.tmc.fbp.webapi.ebentity.biz.paystatus.PayStatusDetail;
import org.apache.commons.lang3.StringUtils;

public class BankPayRequestDataSource
implements IEBRequestDataSource {
    private List<DynamicObject> bankPayBillList;
    private String batchSeqId;

    public BankPayRequestDataSource(DynamicObject bankPayBill) {
        this.batchSeqId = bankPayBill.getString("batchseqid");
        this.bankPayBillList = Collections.singletonList(bankPayBill);
    }

    public BankPayRequestDataSource(String batchSeqId, List<DynamicObject> bankPayBillList) {
        this.batchSeqId = batchSeqId;
        this.bankPayBillList = bankPayBillList;
    }

    @Override
    public List<PayDetail> getPayDetail() {
        ArrayList<PayDetail> details = new ArrayList<PayDetail>(10);
        for (DynamicObject bankPayBill : this.bankPayBillList) {
            PayDetail detail = new PayDetail();
            detail.setDetailSeqID(bankPayBill.getPkValue().toString());
            detail.setBatchSeqID(this.batchSeqId);
            HashMap<String, String> extDatas = new HashMap<String, String>(16);
            if (bankPayBill.getDynamicObject("paybillauditor") != null) {
                extDatas.put("paybillauditor", bankPayBill.getDynamicObject("paybillauditor").getString("username"));
            }
            if (bankPayBill.getDynamicObject("paybillcreator") != null) {
                extDatas.put("paybillcreator", bankPayBill.getDynamicObject("paybillcreator").getString("username"));
            }
            extDatas.put("idempotency", "true");
            detail.setDetailBizNo(bankPayBill.getString("sourcebillid"));
            detail.setIncomeAccNo(bankPayBill.getString("payeeacct"));
            detail.setIncomeAccName(bankPayBill.getString("payeename"));
            boolean isPersonPay = bankPayBill.getBoolean("isprivatepay");
            if (isPersonPay) {
                detail.setIncomeType("individual");
            } else {
                detail.setIncomeType("company");
            }
            if (bankPayBill.getString("payeraddress") != null) {
                detail.setPayerAddress(bankPayBill.getString("payeraddress"));
            }
            detail.setIncomeBankName(bankPayBill.getString("payeebank"));
            detail.setIncomeBankAddress(bankPayBill.getString("recbankadds"));
            detail.setIncomeCnapsCode(bankPayBill.getString("recbanknumber"));
            detail.setAmount(bankPayBill.getBigDecimal("amount").setScale(2, 4).toString());
            Date expectDealTime = bankPayBill.getDate("expectdealtime");
            expectDealTime = expectDealTime == null ? new Date() : expectDealTime;
            detail.setBookingTime(DateUtils.formatString((Date)expectDealTime, (String)"yyyyMMdd"));
            detail.setExplanation(bankPayBill.getString("usage") == null ? "" : bankPayBill.getString("usage"));
            detail.setAbstractMsg(EmptyUtil.isEmpty((String)bankPayBill.getString("description")) ? "" : bankPayBill.getString("description"));
            detail.setUseCode("-1");
            detail.setIncomeProvince(bankPayBill.getString("recprovince"));
            detail.setIncomeCity(bankPayBill.getString("reccity"));
            detail.setEmail(bankPayBill.getString("recemail"));
            boolean istranspay = bankPayBill.getBoolean("istranspay");
            boolean isDiffCurrency = bankPayBill.getBoolean("isdiffcur");
            detail.setIsDiffCurrency(Boolean.valueOf(isDiffCurrency));
            DynamicObject netBankAcct = bankPayBill.getDynamicObject("netbankacct");
            if (netBankAcct != null) {
                detail.setAgentAccNo(netBankAcct.getString("bankaccount"));
            }
            detail.setUrgent(bankPayBill.getBoolean("isurgent"));
            if (!istranspay) {
                detail.setIncomeBankAddress(bankPayBill.getString("reccity"));
                detail.setIncomeCountry(bankPayBill.getDynamicObject("reccountry").getLocaleString("name").getLocaleValue());
                detail.setUseCN(new BizConstant().getBisinesspay());
                detail.setIncomeBranchNo(bankPayBill.getString("institutioncode"));
                detail.setIncomeBranchName(bankPayBill.getString("institutionname"));
            } else {
                DynamicObject country = bankPayBill.getDynamicObject("reccountry");
                if (null != country) {
                    String countryCode;
                    String threeCountryCode = (country = TmcDataServiceHelper.loadSingle((Object)country.getPkValue(), (String)country.getDataEntityType().getName())).getString("threecountrycode");
                    String string = countryCode = StringUtils.isNotBlank((CharSequence)threeCountryCode) ? threeCountryCode : country.getString("twocountrycode");
                    if (StringUtils.isBlank((CharSequence)countryCode)) {
                        countryCode = country.getString("simplespell");
                    }
                    detail.setIncomeCountry(countryCode);
                }
                detail.setIncomeSwiftCode(bankPayBill.getString("incomeswiftcode"));
                detail.setIncomeAreaCode("");
                detail.setForce(false);
                detail.setUseCN(bankPayBill.getString("usecn"));
                detail.setVerifyField("");
                detail.setMergeFlag(false);
                detail.setFeeNo("");
                detail.setPayerFeeType(bankPayBill.getString("payerfeetype"));
                detail.setPayerFeeAccNo(bankPayBill.getString("payerfeeaccno"));
                DynamicObject feeCurrency = bankPayBill.getDynamicObject("payerfeecurrency");
                if (feeCurrency != null) {
                    detail.setPayerFeeCurrency(feeCurrency.getString("number"));
                }
                detail.setPaymentMethod(bankPayBill.getString("paymentmethod"));
                detail.setServiceLevel(bankPayBill.getString("servicelevel"));
                detail.setExchangeRate(bankPayBill.getBigDecimal("tolexchangerate").setScale(6, 4).toString());
                detail.setActualAmount(bankPayBill.getBigDecimal("amount").setScale(2, 4).toString());
                detail.setIncomeBankCode(bankPayBill.getString("incomebankcode"));
                detail.setTransactionRemarks(bankPayBill.getString("transremarks"));
                detail.setPayCurrency(bankPayBill.getDynamicObject("currency").getString("number"));
                detail.setExContract(bankPayBill.getString("excontract"));
                detail.setProxyAccNo(bankPayBill.getString("proxyaccno"));
                detail.setProxyAccName(bankPayBill.getString("proxyaccname"));
                detail.setProxyBankCountry(bankPayBill.getString("proxybankcountry"));
                detail.setProxyBankArea(bankPayBill.getString("proxybankarea"));
                detail.setProxyBankSwiftCode(bankPayBill.getString("proxyswiftcode"));
                detail.setProxyBankName(bankPayBill.getString("proxybankname"));
                detail.setProxyBankAddress(bankPayBill.getString("proxybankadds"));
                detail.setProxyFeeType(detail.getPayerFeeType());
                detail.setProxyFeeCurrency(detail.getPayerFeeCurrency());
                detail.setIncomeAddress(bankPayBill.getString("incomeradds"));
                detail.setIncomeBankLocalClearingCode("");
                detail.setIncomeBankLocalClearingBranchCode("");
                detail.setIncomeBankLocalClearingBranchsubCode("");
                detail.setReceiverName(detail.getIncomeAccName());
                detail.setReceiverAddress(bankPayBill.getString("incomeradds"));
                detail.setIncomeBankCountry(detail.getIncomeCountry());
                detail.setDeliveryMethod(bankPayBill.getString("deliverymethod"));
                detail.setChequeType(bankPayBill.getString("chequetype"));
                detail.setChequeUsage(bankPayBill.getString("chequeusage"));
                detail.setSettlementMethod(bankPayBill.getString("settlementmethod"));
                detail.setMobile(bankPayBill.getString("mobile"));
                detail.setBeneFPSId(bankPayBill.getString("paymentfps"));
                detail.setBeneCountryCode(bankPayBill.getString("paymentareacode"));
                detail.setNotify(Boolean.valueOf(bankPayBill.getBoolean("inforpayment")));
                detail.setBeneEmail(bankPayBill.getString("informrecemail"));
                extDatas.put("applyname", bankPayBill.getString("applyname"));
                extDatas.put("applyphone", bankPayBill.getString("applyphone"));
                detail.setPayProperty(bankPayBill.getString("paymentanture"));
                detail.setSocialCode(bankPayBill.getString("uniformsocialcreditcode"));
                detail.setTxCode(bankPayBill.getString("transactioncode"));
                detail.setTxAmount(bankPayBill.getBigDecimal("transactionamount") == null ? "" : bankPayBill.getBigDecimal("transactionamount").toPlainString());
                detail.setTxPostscript(bankPayBill.getString("transactionpostscrip"));
                detail.setPayAttribute(bankPayBill.getString("reportbiztype"));
                detail.setInvoiceNo(bankPayBill.getString("invoicenumber"));
                detail.setContractNo(bankPayBill.getString("contract"));
                detail.setContractAmount(bankPayBill.getBigDecimal("contractamount") == null ? "" : bankPayBill.getBigDecimal("contractamount").toPlainString());
                detail.setIsBondGoodsFlag(Boolean.valueOf(bankPayBill.getBoolean("isbonded")));
                detail.setBusinessTypeCode(bankPayBill.getString("transremarks"));
                detail.setDeclareFlag(bankPayBill.getString("declaretype"));
            }
            if (isDiffCurrency) {
                DynamicObject exchangeCurrency = bankPayBill.getDynamicObject("exchangecurrency");
                if (EmptyUtil.isNoEmpty((DynamicObject)exchangeCurrency)) {
                    detail.setExchangeCurrency(exchangeCurrency.getString("number"));
                }
                detail.setApplyName(bankPayBill.getString("applyname"));
                detail.setApplyPhone(bankPayBill.getString("applyphone"));
            }
            detail.setExtData(JSON.toJSONString(extDatas));
            details.add(detail);
        }
        return details;
    }

    @Override
    public PayStatusBody getUpdateBody(Map<Long, String> updateStatusMap) {
        if (this.bankPayBillList.size() != 1) {
            throw new IllegalArgumentException("Bank bill size can not > 1");
        }
        DynamicObject bankPayBill = this.bankPayBillList.get(0);
        Long id = bankPayBill.getLong("id");
        String modifyStatus = updateStatusMap.get(id);
        PayStatusBody body = new PayStatusBody();
        body.setTotalCount(1);
        ArrayList<PayStatusDetail> details = new ArrayList<PayStatusDetail>(10);
        String updateReason = new BankPayingErrorCode().EDITBESTATUS_BYHAND().getMessage();
        PayStatusDetail detail = new PayStatusDetail();
        detail.setDetailSeqID(bankPayBill.getPkValue().toString());
        detail.setBatchSeqID(this.batchSeqId);
        detail.setModifyStatus(BeBillStatusEnum.TS.getValue().equals(modifyStatus) ? 12 : 13);
        detail.setUpdateStatus(BankReturnStatusEnum.BANK_SUCCESS.getValue());
        detail.setUpdateReason(updateReason);
        detail.setOperator(RequestContext.get().getUserName());
        details.add(detail);
        body.setDetails(details);
        return body;
    }

    @Override
    public String getAcctNo() {
        return this.bankPayBillList.get(0).getDynamicObject("accountbank").getString("bankaccountnumber");
    }

    @Override
    public String getCurrency() {
        return this.bankPayBillList.get(0).getDynamicObject("currency").getString("number");
    }

    @Override
    public String getBatchSeqId() {
        return this.batchSeqId;
    }

    @Override
    public String getBatchBizNo() {
        return this.batchSeqId;
    }

    public String getParentAcct() {
        return this.bankPayBillList.get(0).getDynamicObject("parentacctbank").getString("bankaccountnumber");
    }

    public String getChildAcct() {
        return this.bankPayBillList.get(0).getDynamicObject("childacctbank").getString("bankaccountnumber");
    }
}

