/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.request.datasource.banktrans;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.bei.business.ebservice.request.datasource.IEBRequestDataSource;
import kd.tmc.bei.common.constants.BizConstant;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.enums.BankReturnStatusEnum;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayDetail;
import kd.tmc.fbp.webapi.ebentity.biz.paystatus.PayStatusBody;
import kd.tmc.fbp.webapi.ebentity.biz.paystatus.PayStatusDetail;

public class BankTransUpRequestDataSource
implements IEBRequestDataSource {
    private DynamicObject bankTransUpBill;
    private DynamicObject entry;

    public BankTransUpRequestDataSource(DynamicObject bankTransBill, DynamicObject entry) {
        this.bankTransUpBill = bankTransBill;
        this.entry = entry;
    }

    @Override
    public List<PayDetail> getPayDetail() {
        DynamicObject bank;
        DynamicObject payBillAuditor;
        HashMap<String, String> extDatas = new HashMap<String, String>(16);
        DynamicObject payBillCreator = this.bankTransUpBill.getDynamicObject("paybillcreator");
        if (EmptyUtil.isNoEmpty((DynamicObject)payBillCreator)) {
            extDatas.put("paybillcreator", payBillCreator.getString("username"));
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(payBillAuditor = this.bankTransUpBill.getDynamicObject("paybillauditor")))) {
            extDatas.put("paybillauditor", payBillAuditor.getString("username"));
        }
        PayDetail detail = new PayDetail();
        boolean isIndividual = this.bankTransUpBill.getBoolean("ispersonpay");
        detail.setBatchSeqID(this.entry.getString("serialnumber"));
        detail.setDetailSeqID(this.entry.getPkValue().toString());
        detail.setDetailBizNo(this.entry.getString("sourceentryid"));
        extDatas.put("idempotency", "true");
        String recName = this.bankTransUpBill.getString("monacctname");
        if (EmptyUtil.isEmpty((String)recName)) {
            recName = this.bankTransUpBill.getString("monacctorg");
        }
        detail.setIncomeAccName(recName);
        detail.setIncomeAccNo(this.bankTransUpBill.getString("monacctnumber"));
        detail.setIncomeBankName(this.bankTransUpBill.getString("monacctbankname"));
        DynamicObject accountBank = this.bankTransUpBill.getDynamicObject("accountbank");
        if (Objects.nonNull(accountBank) && Objects.nonNull(bank = accountBank.getDynamicObject("bank"))) {
            detail.setIncomeCnapsCode((bank = BusinessDataServiceHelper.loadSingle((Object)bank.getPkValue(), (String)bank.getDynamicObjectType().getName(), (String)"union_number")) == null ? null : bank.getString("union_number"));
        }
        detail.setIncomeBankAddress(this.bankTransUpBill.getString("monacctcity"));
        detail.setIncomeCountry("CHN");
        detail.setIncomeProvince(this.bankTransUpBill.getString("monacctprovince"));
        detail.setIncomeCity(this.bankTransUpBill.getString("monacctcity"));
        BigDecimal amount = this.entry.getBigDecimal("transamt").setScale(2, 4);
        detail.setAmount(String.valueOf(amount));
        Date expectDealTime = this.bankTransUpBill.getDate("expectdealtime") == null ? new Date() : this.bankTransUpBill.getDate("expectdealtime");
        detail.setBookingTime(String.valueOf(expectDealTime.getTime()));
        String entryRemark = this.entry.getString("remark");
        if (EmptyUtil.isEmpty((String)entryRemark)) {
            entryRemark = new BizConstant().getTrans();
        }
        detail.setExplanation(entryRemark);
        detail.setUrgent(false);
        detail.setForce(false);
        detail.setUseCode("-1");
        detail.setUseCN(new BizConstant().getTransup());
        detail.setVerifyField("");
        if (isIndividual) {
            detail.setIncomeType("individual");
        } else {
            detail.setIncomeType("company");
        }
        detail.setExtData(JSON.toJSONString(extDatas));
        return Collections.singletonList(detail);
    }

    @Override
    public PayStatusBody getUpdateBody(Map<Long, String> updateStatusMap) {
        ArrayList<PayStatusDetail> details = new ArrayList<PayStatusDetail>(updateStatusMap.size());
        Long key = this.entry.getLong("id");
        if (updateStatusMap.containsKey(key)) {
            String entry_Status = updateStatusMap.get(key);
            PayStatusDetail detail = new PayStatusDetail();
            detail.setDetailSeqID(key.toString());
            detail.setBatchSeqID(this.entry.getString("serialnumber"));
            detail.setModifyStatus(entry_Status.equals(BeBillStatusEnum.TS.getValue()) ? 12 : 13);
            detail.setUpdateStatus(BankReturnStatusEnum.BANK_SUCCESS.getValue());
            detail.setUpdateReason(ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u7ecf\u6838\u5b9e\uff0c\u624b\u5de5\u4fee\u6539\u72b6\u6001\u3002", (String)"BankRequestBodyHelper_2", (String)"tmc-bei-business", (Object[])new Object[0]));
            DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getUserId(), (String)"bos_user");
            detail.setOperator(user.getLocaleString("name").getLocaleValue());
            details.add(detail);
        }
        PayStatusBody body = new PayStatusBody();
        if (details.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u6570\u636e\u672a\u53d8\u5316\uff0c\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BankRequestBodyHelper_3", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
        body.setTotalCount(details.size());
        body.setDetails(details);
        return body;
    }

    @Override
    public String getAcctNo() {
        return this.entry.getDynamicObject("subacct").getString("bankaccountnumber");
    }

    @Override
    public String getCurrency() {
        return this.bankTransUpBill.getDynamicObject("currency").getString("number");
    }

    @Override
    public String getBatchSeqId() {
        return this.entry.getString("serialnumber");
    }

    @Override
    public String getBatchBizNo() {
        return this.bankTransUpBill.getString("billno");
    }
}

