/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.service.acct;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bei.business.ebservice.log.BankLogInfoFactory;
import kd.tmc.bei.business.ebservice.request.BankAcctSyncRequestBuilder;
import kd.tmc.bei.business.helper.AccountBankHelper;
import kd.tmc.bei.common.helper.BankCateHelper;
import kd.tmc.fbp.service.ebservice.data.EBResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;

public class BankAcctSyncService
implements IEBService<EBResult> {
    private DynamicObject bankAcct;
    private List<DynamicObject> bankAccts = new ArrayList<DynamicObject>();
    private boolean isDelete;
    private EBResult result;

    public BankAcctSyncService(DynamicObject bankAcct, boolean isDelete) {
        this.bankAcct = bankAcct;
        this.isDelete = isDelete;
        this.bankAccts.add(bankAcct);
        this.result = new EBResult();
    }

    public BankAcctSyncService(List<DynamicObject> bankAccts, boolean isDelete) {
        this.bankAcct = bankAccts.get(0);
        this.bankAccts = bankAccts;
        this.isDelete = isDelete;
        this.result = new EBResult();
    }

    public boolean validate() {
        if (this.bankAccts.size() > 0) {
            for (DynamicObject data : this.bankAccts) {
                QFilter qFilter = new QFilter("id", "=", (Object)data.getDynamicObject("bank").getLong("id"));
                DynamicObject finOrg = QueryServiceHelper.queryOne((String)"bd_finorginfo", (String)"id,name,number,country.threecountrycode,country.name,country.number,city", (QFilter[])qFilter.toArray());
                String finOrgName = finOrg.getString("name");
                String countryName = finOrg.getString("country.name");
                String countryNum = finOrg.getString("country.number");
                String countryThreeCode = finOrg.getString("country.threecountrycode");
                if (finOrg.get("city") != null || !AccountBankHelper.isChina(countryName, countryNum, countryThreeCode)) continue;
                this.result.setStatusCode(EBResultStatusCode.ERROR);
                this.result.setErrMsg(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u5f00\u6237\u884c\u3010%s\u3011\u7f3a\u5c11\u57ce\u5e02\u4fe1\u606f\u65e0\u6cd5\u540c\u6b65\u94f6\u884c\u8d26\u6237\u7ed9\u94f6\u4f01\uff0c\u8bf7\u5148\u5b8c\u5584\u201c\u5408\u4f5c\u91d1\u878d\u673a\u6784\u201d\u3002", (String)"AcctSyncServiceStragety_6", (String)"tmc-bei-business", (Object[])new Object[]{finOrgName}));
                return false;
            }
        }
        return true;
    }

    public void beforeRequest() {
    }

    public void rollback(String errMsg, Exception e) {
        this.result.setStatusCode(EBResultStatusCode.ROLLBACK);
        this.result.setErrMsg(errMsg);
    }

    public void handleEBException(String resultBody, String errMsg, Exception e) {
        this.result.setStatusCode(EBResultStatusCode.ERROR);
        this.result.setErrMsg(errMsg);
    }

    public void handleResultBody(String resultBody) {
        this.result.setStatusCode(EBResultStatusCode.SUCCESS);
    }

    public IEBRequestBuilder getRequestBuilder() {
        return new BankAcctSyncRequestBuilder(this.bankAccts, this.isDelete);
    }

    public String getEntityName() {
        return "bd_accountbanks";
    }

    public BankLogInfo getBankLogInfo() {
        return BankLogInfoFactory.generateBankAcctLog(this.bankAcct);
    }

    public EBResult getEBResult() {
        return this.result;
    }

    public Long getBankCateId() {
        return BankCateHelper.getBankCateId((DynamicObject)this.bankAcct);
    }
}

