/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.service.acct;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.bei.business.ebservice.log.BankLogInfoFactory;
import kd.tmc.bei.business.ebservice.request.GetLoginListRequestBuilder;
import kd.tmc.bei.common.helper.BankCateHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.data.EBGetLoginListResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.errorcode.BeBizErrorCode;
import kd.tmc.fbp.service.ebservice.errorcode.EBBizErrorCode;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.webapi.ebentity.biz.listbanklogin.BankAccTypes;
import kd.tmc.fbp.webapi.ebentity.biz.listbanklogin.LoginDetail;

public class GetLoginListService
implements IEBService<EBGetLoginListResult> {
    private DynamicObject bankAcct;
    private EBGetLoginListResult result;

    public GetLoginListService(DynamicObject bankAcct) {
        this.bankAcct = bankAcct;
        this.result = new EBGetLoginListResult();
    }

    public boolean validate() {
        DynamicObject finOrg = this.bankAcct.getDynamicObject("bank");
        if (finOrg != null) {
            DynamicObject bankCate;
            String finorgType = this.bankAcct.getString("finorgtype");
            if (finorgType.equals("0") && (bankCate = finOrg.getDynamicObject("bank_cate")) == null) {
                this.result.setErrMsg(new BeBizErrorCode().BANKCATE_ISNULL().getMessage());
                this.result.setStatusCode(EBResultStatusCode.ERROR);
                return false;
            }
        } else {
            this.result.setErrMsg(new BeBizErrorCode().BANK_ISNULL().getMessage());
            this.result.setStatusCode(EBResultStatusCode.ERROR);
            return false;
        }
        return true;
    }

    public void beforeRequest() {
    }

    public void rollback(String errMsg, Exception e) {
        this.result.setStatusCode(EBResultStatusCode.ROLLBACK);
        this.result.setErrMsg(errMsg);
    }

    public void handleEBException(String resultBody, String errMsg, Exception e) {
        this.result.setStatusCode(EBResultStatusCode.ERROR);
        this.result.setErrMsg(errMsg);
    }

    public void handleResultBody(String resultBody) {
        JSONObject bodyObj = JSON.parseObject((String)resultBody);
        String detailsStr = JSONObject.toJSONString((Object)bodyObj.get((Object)"details"));
        List details = (List)JSON.parseObject((String)detailsStr, (TypeReference)new TypeReference<List<LoginDetail>>(){}, (Feature[])new Feature[0]);
        if (details == null || CollectionUtils.isEmpty((Collection)details)) {
            this.result.setStatusCode(EBResultStatusCode.ERROR);
            this.result.setErrMsg(new EBBizErrorCode().ERROR_BEBANKINTER().getMessage());
            return;
        }
        HashMap<String, String> loginMap = new HashMap<String, String>(details.size());
        HashMap loginIdBankTypeMap = new HashMap(10);
        for (LoginDetail detail : details) {
            String loginAlias = detail.getLoginAlias();
            if (EmptyUtil.isEmpty((String)loginAlias)) {
                loginMap.put(detail.getLoginID(), detail.getBankVersionName());
            } else {
                loginMap.put(detail.getLoginID(), loginAlias);
            }
            HashMap<String, String> bankTypeMap = new HashMap<String, String>(10);
            List bankAccTypes = detail.getBankAccTypes();
            if (bankAccTypes != null && bankAccTypes.size() > 0) {
                for (BankAccTypes item : bankAccTypes) {
                    bankTypeMap.put(item.getType(), item.getTypeName());
                }
            }
            loginIdBankTypeMap.put(detail.getLoginID(), bankTypeMap);
        }
        this.result.setStatusCode(EBResultStatusCode.SUCCESS);
        this.result.setLoginMap(loginMap);
        this.result.setBankAccTypeMap(loginIdBankTypeMap);
    }

    private String getKeyword() {
        String keyword = null;
        DynamicObject finorg = this.bankAcct.getDynamicObject("bank");
        if (finorg != null) {
            String finorgType = this.bankAcct.getString("finorgtype");
            if (finorgType.equals("0")) {
                DynamicObject bankCate = finorg.getDynamicObject("bank_cate");
                if (bankCate != null) {
                    keyword = bankCate.getString("name");
                }
            } else {
                keyword = finorg.getString("name");
            }
        }
        return keyword;
    }

    public IEBRequestBuilder getRequestBuilder() {
        return new GetLoginListRequestBuilder();
    }

    public String getEntityName() {
        return "bd_accountbanks";
    }

    public BankLogInfo getBankLogInfo() {
        return BankLogInfoFactory.generateBankAcctLog(this.bankAcct);
    }

    public EBGetLoginListResult getEBResult() {
        return this.result;
    }

    public Long getBankCateId() {
        return BankCateHelper.getBankCateId((DynamicObject)this.bankAcct);
    }
}

