/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.service.detail;

import com.alibaba.dubbo.remoting.TimeoutException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.sdk.tmc.bei.extpoint.transdetail.IFillTransDetail;
import kd.tmc.bei.business.ebservice.request.DownTransDetailBuilder;
import kd.tmc.bei.business.helper.TransDetailHelper;
import kd.tmc.bei.business.opservice.result.TransDetailResult;
import kd.tmc.bei.common.enums.DataSourceEnum;
import kd.tmc.bei.common.helper.BankCateHelper;
import kd.tmc.bei.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.ReceredtypeEnum;
import kd.tmc.fbp.common.helper.GenBankcheckCode;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.bean.DetailQueryInfo;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.webapi.ebentity.biz.detail.Detail;
import kd.tmc.fbp.webapi.ebentity.biz.detail.DetailResponseBody;

public class DetailQueryService
implements IEBService<TransDetailResult> {
    private static final Log logger = LogFactory.getLog(DetailQueryService.class);
    private TransDetailResult transDetailResult = new TransDetailResult();
    private DetailQueryInfo detailQueryInfo;

    public DetailQueryService(DetailQueryInfo detailQueryInfo) {
        this.detailQueryInfo = detailQueryInfo;
    }

    public boolean validate() {
        return true;
    }

    public void beforeRequest() {
    }

    public void rollback(String errMsg, Exception e) {
        this.detailQueryInfo.setSuccess(false);
        this.transDetailResult.setErrMsg(errMsg);
    }

    public void handleEBException(String resultBody, String errMsg, Exception e) {
        this.detailQueryInfo.setSuccess(false);
        this.transDetailResult.setErrMsg(errMsg);
        if (e instanceof SocketTimeoutException || e instanceof TimeoutException) {
            this.transDetailResult.setTimeOut(true);
        }
    }

    public void handleResultBody(String resultBody) {
        logger.info("handleResultBody is start that");
        DetailResponseBody body = (DetailResponseBody)JSON.parseObject((String)resultBody, (TypeReference)new TypeReference<DetailResponseBody>(){}, (Feature[])new Feature[0]);
        this.detailQueryInfo.setLastPage(body.isLastPage());
        this.transDetailResult.setTotalCount(body.getTotalCount());
        List details = body.getDetails();
        if (details == null || details.size() <= 0) {
            logger.info("DetailQueryServiceStragety Details from bank  is null or 0");
            int progress = body.getProgress();
            if (progress == 0) {
                this.transDetailResult.setProgress(0);
            }
            return;
        }
        logger.info("DetailQueryServiceStragety Details from bank size is:" + details.size() + ",will deal these data");
        HashSet<DynamicObject> newDetailSet = new HashSet<DynamicObject>(8);
        HashSet<DynamicObject> updatedetailSet = new HashSet<DynamicObject>(8);
        DynamicObject bankAcct = BusinessDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,bankaccountnumber,company,bank,bank.logo,createorg,openorg,acctname", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)((Detail)details.get(0)).getAccNo())});
        DynamicObject currency = BusinessDataServiceHelper.loadSingle((String)"bd_currency", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)((Detail)details.get(0)).getCurrency())});
        int size = details.size();
        ArrayList<String> detailIds = new ArrayList<String>(size);
        ArrayList<String> uniqueSeqIds = new ArrayList<String>(size);
        for (Detail value : details) {
            String detailId = value.getId();
            String uniqueSeq = value.getUniqueSeq();
            detailIds.add(detailId);
            if (!EmptyUtil.isNoEmpty((String)uniqueSeq)) continue;
            uniqueSeqIds.add(uniqueSeq);
        }
        HashMap<String, String> detailBankCheckFlagMap = new HashMap<String, String>(8);
        DynamicObject[] locDetails = this.getLocTransDetail(detailIds, uniqueSeqIds);
        HashSet<String> matchBizDetailIds = new HashSet<String>(locDetails.length);
        HashSet<String> matchRuleDetailIds = new HashSet<String>(locDetails.length);
        DynamicObject company = TmcAccountHelper.getCreateOrgDOByBankAcct((DynamicObject)bankAcct);
        long companyId = !EmptyUtil.isEmpty((DynamicObject)company) ? company.getLong("id") : 0L;
        long count = 0L;
        for (int index = 0; index < details.size(); ++index) {
            String explanation;
            boolean isNeedMatchBiz = false;
            boolean isNeedMatchRule = false;
            boolean isUpdate = false;
            Detail detail = (Detail)details.get(index);
            if (index == 0) {
                logger.info("detail from bank is:" + detail.toString());
            }
            DynamicObject info = this.checkAndInitDetail(locDetails, detail.getId(), detail.getUniqueSeq());
            boolean isNoneBusiness = true;
            String billno = info.getString("billno");
            if (StringUtils.isEmpty((String)billno)) {
                billno = CodeRuleHelper.generateNumber((String)"bei_transdetail_cas", (DynamicObject)TmcDataServiceHelper.newDynamicObject((String)"bei_transdetail_cas"), (String)String.valueOf(companyId), null);
                if (StringUtils.isEmpty((String)billno)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u7f16\u53f7\u4e0d\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u66f4\u65b0\u6570\u636e\uff0c\u8bf7\u542f\u7528\u5408\u9002\u7684\u4ea4\u6613\u660e\u7ec6\u7f16\u7801\u89c4\u5219\u3002", (String)"TransDetailImportNewOp_14", (String)"tmc-bei-business", (Object[])new Object[0]));
                }
                info.set("billno", (Object)billno);
                info.set("creator", (Object)RequestContext.get().getCurrUserId());
            }
            if (ObjectUtils.isEmpty((Object)info.get("accountbank"))) {
                info.set("accountbank", (Object)(bankAcct == null ? 0L : bankAcct.getLong("id")));
                info.set("bank", (Object)(bankAcct == null || bankAcct.getDynamicObject("bank") == null ? 0L : bankAcct.getDynamicObject("bank").getLong("id")));
                info.set("company", (Object)companyId);
                info.set("currency", (Object)(currency == null ? 0L : currency.getLong("id")));
                info.set("isdataimport", (Object)"0");
                info.set("isdowntobankstate", (Object)"0");
                info.set("isreced", (Object)"0");
                info.set("receredtype", (Object)ReceredtypeEnum.Pending.getValue());
                info.set("datasource", (Object)DataSourceEnum.FROMBANK.getValue());
                info.set("confirmamount", (Object)Constants.ZERO);
                newDetailSet.add(info);
            } else {
                isUpdate = true;
                isNoneBusiness = TransDetailHelper.noneBusiness(info);
            }
            boolean newOrNoneBusiness = !isUpdate || isNoneBusiness;
            info.set("bankDetailNo", (Object)detail.getBankDetailNo());
            if (StringUtils.isNotEmpty((String)detail.getCreditAmount())) {
                BigDecimal creditAmount = new BigDecimal(detail.getCreditAmount());
                if (isUpdate && info.getBigDecimal("creditamount").compareTo(creditAmount) != 0) {
                    isNeedMatchBiz = true;
                    isNeedMatchRule = true;
                }
                if (newOrNoneBusiness) {
                    info.set("creditamount", (Object)creditAmount);
                    info.set("unconfirmamount", (Object)creditAmount);
                }
            }
            if (StringUtils.isNotEmpty((String)detail.getDebitAmount())) {
                BigDecimal debitAmount = new BigDecimal(detail.getDebitAmount());
                if (isUpdate && info.getBigDecimal("debitamount").compareTo(debitAmount) != 0) {
                    isNeedMatchBiz = true;
                    isNeedMatchRule = true;
                }
                if (newOrNoneBusiness) {
                    info.set("debitamount", (Object)debitAmount);
                    info.set("unconfirmamount", (Object)debitAmount);
                }
            }
            if (StringUtils.isNotEmpty((String)detail.getBalance())) {
                info.set("transbalance", (Object)new BigDecimal(detail.getBalance()));
            }
            if ((explanation = detail.getExplanation()) != null) {
                explanation = explanation.trim();
                explanation = explanation.substring(0, Math.min(explanation.length(), 255));
            }
            SimpleDateFormat timeformat = new SimpleDateFormat("yyyyMMddHHmmss");
            SimpleDateFormat timeformat1 = new SimpleDateFormat("yyyyMMdd");
            Timestamp biztime = DateUtils.getCurrentTime();
            Date bizdate = DateUtils.getCurrentDate();
            String transDate = detail.getTransDate();
            String detailDateTime = detail.getDetailDateTime();
            try {
                Date time;
                if (StringUtils.isNotEmpty((String)transDate)) {
                    time = transDate.length() == 8 ? timeformat1.parse(transDate) : timeformat.parse(transDate);
                    bizdate = DateUtils.truncateDate((Date)time);
                    biztime = new Timestamp(bizdate.getTime());
                }
                if (StringUtils.isNotEmpty((String)detailDateTime)) {
                    if (detailDateTime.length() == 8) {
                        time = timeformat1.parse(detailDateTime);
                        biztime = new Timestamp(time.getTime());
                        if (EmptyUtil.isEmpty((String)transDate)) {
                            bizdate = DateUtils.truncateDate((Date)time);
                        }
                    } else {
                        time = timeformat.parse(detailDateTime);
                        biztime = new Timestamp(time.getTime());
                        if (EmptyUtil.isEmpty((String)transDate)) {
                            bizdate = DateUtils.truncateDate((Date)time);
                        }
                    }
                }
                info.set("transDate", (Object)bizdate);
                info.set("biztime", (Object)biztime);
                if (newOrNoneBusiness) {
                    info.set("bizdate", (Object)bizdate);
                }
            }
            catch (ParseException e) {
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
            if (!StringUtils.isEmpty((String)detail.getTransferCharge())) {
                info.set("transferCharge", (Object)new BigDecimal(detail.getTransferCharge()));
            }
            if (!(!isUpdate || DateUtils.isSameDay((Date)info.getDate("bizdate"), (Date)bizdate) && info.getString("description").equals(explanation) && info.getString("oppbanknumber").equals(detail.getOppAccNo()) && info.getString("oppunit").equals(detail.getOppAccName()) && info.getString("oppbank").equals(detail.getOppBankName()))) {
                isNeedMatchRule = true;
            }
            if (newOrNoneBusiness) {
                info.set("description", (Object)explanation);
                info.set("oppbanknumber", (Object)detail.getOppAccNo());
                info.set("oppunit", (Object)detail.getOppAccName());
                info.set("oppbank", (Object)detail.getOppBankName());
            }
            info.set("frmcod", (Object)detail.getFrmCod());
            info.set("modifytime", (Object)DateUtils.getCurrentTime());
            info.set("lastmodifytime", (Object)DateUtils.getCurrentTime());
            info.set("flowserialno", (Object)detail.getFlowSerialNo());
            info.set("sortid", (Object)detail.getSortID());
            info.set("requestserialno", (Object)detail.getRequestSerialNo());
            info.set("responseserailno", (Object)detail.getResponseSerailNo());
            info.set("kdretflag", (Object)detail.getKDRetFlag());
            info.set("agentaccno", (Object)detail.getAgentAccNo());
            info.set("agentaccname", (Object)detail.getAgentAccName());
            info.set("agentaccbankname", (Object)detail.getAgentAccBankName());
            info.set("bustype", (Object)detail.getBusType());
            info.set("batchno", (Object)detail.getBatchNo());
            info.set("vouhno", (Object)detail.getVouhNo());
            info.set("extdata", (Object)detail.getExtData());
            info.set("extraaccno", (Object)detail.getExtraAccNo());
            if ("autotransup".equalsIgnoreCase(detail.getTransType())) {
                info.set("istransup", (Object)"1");
            } else if ("autotransdown".equalsIgnoreCase(detail.getTransType())) {
                info.set("istransdown", (Object)"1");
            } else if ("bankcharge".equalsIgnoreCase(detail.getTransType())) {
                info.set("isbankwithholding", (Object)"1");
            } else if ("refund".equalsIgnoreCase(detail.getTransType())) {
                info.set("refundsource", (Object)"0");
            }
            if (!isUpdate) {
                info.set("detailid", (Object)detail.getId());
                info.set("uniqueSeq", (Object)(EmptyUtil.isEmpty((String)detail.getUniqueSeq()) ? detail.getId() : detail.getUniqueSeq()));
            }
            String bankCheckFlagStr = detail.getPayBankDetailSeqID();
            detailBankCheckFlagMap.put(detail.getId(), bankCheckFlagStr);
            if (StringUtils.isNotEmpty((String)bankCheckFlagStr)) {
                info.set("bankcheckflag", (Object)bankCheckFlagStr);
            }
            info.set("biztype", (Object)"1");
            if (!info.getBoolean("ismatchereceipt") && detail.getReceiptNo() != null) {
                info.set("receiptno", (Object)detail.getReceiptNo());
            }
            info.set("bizrefno", (Object)detail.getBizRefNo());
            info.set("sortno", (Object)(DateUtils.getCurrentTime().getTime() * 100000L + count++ % 100000L));
            if (isNeedMatchBiz) {
                matchBizDetailIds.add(detail.getId());
            }
            if (isNeedMatchRule) {
                matchRuleDetailIds.add(detail.getId());
            }
            info.set("opprelacct", (Object)TransDetailHelper.getOppRelAcct(info.getString("oppbanknumber")));
            if (isUpdate) {
                boolean updateErrorFlag;
                boolean bl = updateErrorFlag = !isNoneBusiness && (isNeedMatchBiz || isNeedMatchRule);
                if (info.getBoolean("synonym") && updateErrorFlag) {
                    info.set("errortype", (Object)"U");
                    info.set("errormsg", (Object)ResManager.loadKDString((String)"\u6700\u8fd1\u4e00\u6b21\u4e0b\u8f7d\u4ea4\u6613\u660e\u7ec6\uff0c\u94f6\u884c\u8fd4\u56de\u7ed3\u679c\u5bf9\u8be5\u7b14\u660e\u7ec6\u6709\u66f4\u65b0\uff0c\u8be5\u7b14\u4ea4\u6613\u660e\u7ec6\u5df2\u5173\u8054\u4e1a\u52a1\uff0c\u5173\u952e\u5b57\u6bb5\u4fe1\u606f\u4e0d\u66f4\u65b0\u3002", (String)"EBDetailQueryService_1", (String)"tmc-bei-business", (Object[])new Object[0]));
                } else {
                    info.set("synonym", (Object)TransDetailHelper.updateSynonym(info, bankAcct, company));
                }
                if (updateErrorFlag) {
                    info.set("errortype", (Object)"U");
                    info.set("errormsg", (Object)ResManager.loadKDString((String)"\u6700\u8fd1\u4e00\u6b21\u4e0b\u8f7d\u4ea4\u6613\u660e\u7ec6\uff0c\u94f6\u884c\u8fd4\u56de\u7ed3\u679c\u5bf9\u8be5\u7b14\u660e\u7ec6\u6709\u66f4\u65b0\uff0c\u8be5\u7b14\u4ea4\u6613\u660e\u7ec6\u5df2\u5173\u8054\u4e1a\u52a1\uff0c\u5173\u952e\u5b57\u6bb5\u4fe1\u606f\u4e0d\u66f4\u65b0\u3002", (String)"EBDetailQueryService_1", (String)"tmc-bei-business", (Object[])new Object[0]));
                } else {
                    info.set("errortype", (Object)"");
                    info.set("errormsg", (Object)" ");
                }
                updatedetailSet.add(info);
            } else {
                info.set("synonym", (Object)TransDetailHelper.updateSynonym(info, bankAcct, company));
            }
            this.dealExtData(info, detail.getExtData());
        }
        OperateOption operateOption = OperateOption.create();
        HashMap<String, Object> matchMap = new HashMap<String, Object>(4);
        if (!CollectionUtils.isEmpty(detailBankCheckFlagMap)) {
            String detailBankCheckFlagMapJsonStr = SerializationUtils.toJsonString(detailBankCheckFlagMap);
            operateOption.setVariableValue("detailBankCheckFlagMap", detailBankCheckFlagMapJsonStr);
            logger.info("detailBankCheckFlagMapJsonStr\uff1a{}", (Object)detailBankCheckFlagMapJsonStr);
        }
        logger.info("\u62bd\u79bb\u5339\u914d\u64cd\u4f5c\u540e\uff0cupdatedetailSet \u7684\u5927\u5c0f\u662f\uff1a{}", (Object)updatedetailSet.size());
        if (!updatedetailSet.isEmpty()) {
            Set detailBillNoSet = updatedetailSet.stream().map(d -> d.getString("billno")).collect(Collectors.toSet());
            logger.info("add updateSet data\uff1a{}", detailBillNoSet);
            operateOption.setVariableValue("operationType", "update");
            operateOption.setVariableValue("fromDownload", "true");
            operateOption.setVariableValue("matchBizDetailIds", SerializationUtils.toJsonString(matchBizDetailIds));
            operateOption.setVariableValue("matchRuleDetailIds", SerializationUtils.toJsonString(matchRuleDetailIds));
            List idList = updatedetailSet.stream().map(DataEntityBase::getPkValue).map(String::valueOf).collect(Collectors.toList());
            logger.info("\u4e0b\u8f7d\u4ea4\u6613\u660e\u7ec6\u7684updatedetailSet\u7684idList\u4e3a\uff1a{}", idList);
            if (idList.size() > 0) {
                TmcOperateServiceHelper.execOperate((String)"banksave", (String)"bei_transdetail_cas", (DynamicObject[])updatedetailSet.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                logger.info("\u4e0b\u8f7d\u4ea4\u6613\u660e\u7ec6\u7684updatedetailSet\u7684\u6210\u529f\u63d2\u5165\u6570\u636e\u5e93\u7684\u96c6\u5408\u4e3a\uff1a{}", updatedetailSet);
            }
            matchMap.put("updatedetailSet", updatedetailSet);
            matchMap.put("updateOperateOption", operateOption);
            logger.info("\u62bd\u79bb\u5339\u914d\u64cd\u4f5c\u540e\uff0c\u4f20\u5165\u7684updateOperateOption\uff1a{}", (Object)operateOption);
        }
        logger.info("\u62bd\u79bb\u5339\u914d\u64cd\u4f5c\u540e\uff0cnewDetailSet \u7684\u5927\u5c0f\u662f\uff1a{}", (Object)newDetailSet.size());
        if (!newDetailSet.isEmpty()) {
            Set detailBillNoSet = newDetailSet.stream().map(d -> d.getString("billno")).collect(Collectors.toSet());
            logger.info("add new create set\uff1a{}", detailBillNoSet);
            operateOption.setVariableValue("operationType", "insert");
            operateOption.setVariableValue("fromDownload", "true");
            this.setBankCheckFlag(newDetailSet, detailBankCheckFlagMap);
            OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"banksave", (String)"bei_transdetail_cas", (DynamicObject[])newDetailSet.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            List newSuccessPkIds = operationResult.getSuccessPkIds();
            matchMap.put("newSuccessPkIds", newSuccessPkIds);
            matchMap.put("newDetailSet", newDetailSet);
            matchMap.put("newOperateOption", operateOption);
            logger.info("\u62bd\u79bb\u5339\u914d\u64cd\u4f5c\u540e\uff0c\u4f20\u5165\u7684newDetailSet\uff1a{}", newDetailSet);
            logger.info("\u62bd\u79bb\u5339\u914d\u64cd\u4f5c\u540e\uff0c\u4f20\u5165\u7684newOperateOption\uff1a{}", (Object)operateOption);
        }
        logger.info("\u62bd\u79bb\u5339\u914d\u64cd\u4f5c\u540e\uff0ctransDetailResult \u4e2d\u63d2\u5165\u7684\u5339\u914d\u96c6\u5408\uff1a{}", matchMap);
        this.transDetailResult.setMatchMap(matchMap);
        this.transDetailResult.setDetailIds(detailIds);
        this.transDetailResult.setDetails(details);
        this.transDetailResult.setProgress(body.getProgress());
    }

    private void setBankCheckFlag(Set<DynamicObject> newDetailSet, Map<String, String> detailBankCheckFlagMap) {
        for (DynamicObject newTransDetail : newDetailSet) {
            String detailId = newTransDetail.getString("detailid");
            String bankCheckFlagStr = detailBankCheckFlagMap.get(detailId);
            if (StringUtils.isNotEmpty((String)bankCheckFlagStr)) {
                newTransDetail.set("iskdretflag", (Object)"1");
                newTransDetail.set("bankcheckflag", (Object)bankCheckFlagStr);
                continue;
            }
            String bankCheckFlag = newTransDetail.getString("bankcheckflag");
            if (!StringUtils.isEmpty((String)bankCheckFlag)) continue;
            String genCode = GenBankcheckCode.genCode();
            newTransDetail.set("bankcheckflag", (Object)genCode);
        }
    }

    private void dealExtData(DynamicObject transDetailInfo, String extData) {
        PluginProxy pluginProxy = PluginProxy.create(IFillTransDetail.class, (String)"kd.sdk.tmc.bei.extpoint.transdetail.IFillTransDetail");
        pluginProxy.callReplace(p -> {
            p.fillExtData(transDetailInfo, extData);
            return new Object();
        });
    }

    private DynamicObject[] getLocTransDetail(List<String> detailIds, List<String> uniqueSeqIds) {
        logger.info("getLocTransDetail is start!");
        ArrayList transDetailIds = new ArrayList(detailIds.size() + uniqueSeqIds.size());
        QFilter detailIdQfilter = new QFilter("detailid", "in", detailIds);
        DynamicObjectCollection transDetails_detailId = QueryServiceHelper.query((String)"bei_transdetail_cas", (String)"id", (QFilter[])new QFilter[]{detailIdQfilter});
        transDetails_detailId.stream().forEach(o -> transDetailIds.add(o.getLong("id")));
        if (uniqueSeqIds.size() > 0) {
            logger.info("uniqueSeqIds is not null!");
            QFilter uniqueSeqQfilter = new QFilter("uniqueseq", "in", uniqueSeqIds);
            DynamicObjectCollection transDetails_uniqueSeq = QueryServiceHelper.query((String)"bei_transdetail_cas", (String)"id", (QFilter[])new QFilter[]{uniqueSeqQfilter});
            transDetails_uniqueSeq.stream().forEach(o -> transDetailIds.add(o.getLong("id")));
        }
        return TmcDataServiceHelper.load((Object[])transDetailIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bei_transdetail_cas"));
    }

    private DynamicObject checkAndInitDetail(DynamicObject[] details, String detailId, String uniqueSeq) {
        for (DynamicObject detail : details) {
            boolean sameuniqueseq;
            boolean sameId = detailId.equals(detail.getString("detailid"));
            boolean bl = sameuniqueseq = EmptyUtil.isNoEmpty((String)uniqueSeq) && uniqueSeq.equals(detail.getString("uniqueseq"));
            if (!sameId && !sameuniqueseq) continue;
            return detail;
        }
        return TmcDataServiceHelper.newDynamicObject((String)"bei_transdetail_cas");
    }

    public IEBRequestBuilder getRequestBuilder() {
        return new DownTransDetailBuilder(this.detailQueryInfo);
    }

    public String getEntityName() {
        return "bei_transdetail_cas";
    }

    public BankLogInfo getBankLogInfo() {
        BankLogInfo bankLogInfo = new BankLogInfo();
        bankLogInfo.setEntityName("bei_transdetail");
        String billNo = StringUtils.isNotEmpty((String)this.detailQueryInfo.getBillNo()) ? this.detailQueryInfo.getBillNo() : (this.detailQueryInfo.getBankAcct() != null ? this.detailQueryInfo.getBankAcct().getString("bankaccountnumber") : JSON.toJSONString((Object)this.detailQueryInfo.getBankAccts()));
        Long orgId = this.detailQueryInfo.getOrgId() != null && this.detailQueryInfo.getOrgId().compareTo(0L) != 0 ? this.detailQueryInfo.getOrgId().longValue() : RequestContext.get().getOrgId();
        bankLogInfo.setOrgid(orgId);
        bankLogInfo.setBillNo(billNo);
        bankLogInfo.setRequestId(Long.valueOf(EmptyUtil.isNoEmpty((Long)this.detailQueryInfo.getRequestId()) ? this.detailQueryInfo.getRequestId() : 0L));
        return bankLogInfo;
    }

    public TransDetailResult getEBResult() {
        return this.transDetailResult;
    }

    public Long getBankCateId() {
        return BankCateHelper.getBankCateId((DynamicObject)this.detailQueryInfo.getBankAcct());
    }
}

