/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.service.detail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.tmc.bei.business.ebservice.request.DownElecStatementBuilder;
import kd.tmc.bei.business.opservice.param.ElecStatementPram;
import kd.tmc.bei.business.opservice.result.ELecStatementResult;
import kd.tmc.bei.common.enums.DataSourceEnum;
import kd.tmc.bei.common.helper.BankCateHelper;
import kd.tmc.fbp.common.bean.Reconciliation;
import kd.tmc.fbp.common.helper.TmcAttachmentHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.OFDReconciliationUtils;
import kd.tmc.fbp.service.ebservice.errorcode.EBBizErrorCode;
import kd.tmc.fbp.service.ebservice.exception.EBBizNCException;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.webapi.ebentity.biz.statement.ElecStatementResposeBody;
import kd.tmc.fbp.webapi.ebentity.biz.statement.StatementDetail;

public class ELecStatementService
implements IEBService<ELecStatementResult> {
    private static final Log logger = LogFactory.getLog(ELecStatementService.class);
    private final ELecStatementResult downResult = new ELecStatementResult();
    private ElecStatementPram queryInfo;

    public ELecStatementService(ElecStatementPram queryInfo) {
        this.queryInfo = queryInfo;
    }

    public boolean validate() {
        return true;
    }

    public void beforeRequest() {
    }

    public void rollback(String errMsg, Exception e) {
        this.downResult.setErrMsg(errMsg);
    }

    public void handleEBException(String resultBody, String errMsg, Exception e) {
        this.downResult.setErrMsg(errMsg);
    }

    public void handleResultBody(String resultBody) {
        if (StringUtils.isEmpty((String)resultBody)) {
            throw new EBBizNCException(new EBBizErrorCode().RESPONSE_ISNULL());
        }
        ElecStatementResposeBody body = (ElecStatementResposeBody)JSON.parseObject((String)resultBody, ElecStatementResposeBody.class);
        List details = body.getDetails();
        if (details.size() > 0) {
            ArrayList<String> reconciliationKeys = new ArrayList<String>(10);
            for (StatementDetail detail : details) {
                String uploadFileName;
                String realPath = uploadFileName = detail.getUploadFileName();
                logger.info("\u94f6\u4f01\u4e91\u8fd4\u56de\u6587\u4ef6\u5730\u5740\uff1a" + uploadFileName);
                if (!uploadFileName.contains(".") && !uploadFileName.contains("/")) {
                    try {
                        FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
                        realPath = attachmentFileService.getFileServiceExt().getRealPath(uploadFileName);
                    }
                    catch (Exception e) {
                        logger.error("\u83b7\u53d6\u6587\u4ef6\u771f\u5b9e\u8def\u5f84\u5931\u8d25" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    }
                }
                try {
                    String[] split = realPath.split("/");
                    String fileName = split[split.length - 1];
                    if (fileName.endsWith(".ofd")) {
                        OperationResult result;
                        String errorMessage;
                        String desPlace = "./".concat(fileName);
                        OutputStream out = TmcAttachmentHelper.downloadFile((String)desPlace, (String)realPath);
                        File ofdFile = TmcAttachmentHelper.getFile((OutputStream)out, (String)uploadFileName, (String)desPlace);
                        if (ofdFile == null) continue;
                        OFDReconciliationUtils ofdReconciliationUtils = new OFDReconciliationUtils();
                        String canonicalPath = ofdFile.getCanonicalPath();
                        Reconciliation reconciliation = ofdReconciliationUtils.parseOFDStructuredData(canonicalPath);
                        if (reconciliation.getDetails().isEmpty()) {
                            logger.info("\u672a\u6210\u529f\u89e3\u6790\uff1a\u65e0\u5bf9\u8d26\u5355\u8bb0\u5f55");
                        }
                        if (!ofdFile.delete()) {
                            logger.info("\u6587\u4ef6\u5220\u9664\u5931\u8d25");
                        }
                        if (EmptyUtil.isNoEmpty((String)(errorMessage = this.checkReconciliation(reconciliation)))) {
                            throw new Exception(errorMessage);
                        }
                        String currency = reconciliation.getCurrency();
                        String reconciliationKey = reconciliation.getAccNo() + currency + reconciliation.getYear() + reconciliation.getMonth();
                        OperateOption operateOption = OperateOption.create();
                        operateOption.setVariableValue("filename", fileName);
                        operateOption.setVariableValue("fileurl", uploadFileName);
                        operateOption.setVariableValue("json", JSONObject.toJSONString((Object)reconciliation));
                        operateOption.setVariableValue("datasource", DataSourceEnum.FROMBANK.getValue());
                        if (!reconciliationKeys.contains(reconciliationKey)) {
                            reconciliationKeys.add(reconciliationKey);
                            operateOption.setVariableValue("iscover", "true");
                        } else {
                            operateOption.setVariableValue("iscover", "false");
                        }
                        if ((result = TmcOperateServiceHelper.execOperate((String)"fileimport", (String)"bei_elecstatement", (DynamicObject[])new DynamicObject[]{TmcDataServiceHelper.newDynamicObject((String)"bei_elecstatement")}, (OperateOption)operateOption)).isSuccess()) continue;
                        logger.info("file [{}] import fail {}", (Object)fileName, (Object)result.getMessage());
                        continue;
                    }
                    logger.info("\u6587\u4ef6\u975eofd\u683c\u5f0f\uff1a" + fileName);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        } else {
            logger.info("\u94f6\u4f01\u8fd4\u56de\u4fe1\u606fdetails.size\u4e3a0");
        }
    }

    public IEBRequestBuilder getRequestBuilder() {
        return new DownElecStatementBuilder(this.queryInfo);
    }

    public String getEntityName() {
        return "bei_elecstatement";
    }

    public BankLogInfo getBankLogInfo() {
        BankLogInfo bankLogInfo = new BankLogInfo();
        bankLogInfo.setEntityName("bei_elecstatement");
        String accNo = this.queryInfo.getBankAcct().getString("bankaccountnumber");
        bankLogInfo.setBillNo(accNo);
        bankLogInfo.setOrgid(Long.valueOf(this.queryInfo.getBankAcct().getLong("createorg.id")));
        return bankLogInfo;
    }

    public ELecStatementResult getEBResult() {
        return this.downResult;
    }

    public String getServiceUrl() {
        return "/kapi/app/receipt/receiptQuery";
    }

    public Long getBankCateId() {
        return BankCateHelper.getBankCateId((DynamicObject)this.queryInfo.getBankAcct());
    }

    private String checkReconciliation(Reconciliation reconciliation) {
        String currency;
        StringBuilder errorMessage = new StringBuilder();
        String accNo = reconciliation.getAccNo();
        if (EmptyUtil.isEmpty((String)accNo)) {
            errorMessage.append(ResManager.loadKDString((String)"\u8d26\u6237\u4e3a\u7a7a\u3002", (String)"StatementImportTask_1", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((String)(currency = reconciliation.getCurrency()))) {
            errorMessage.append(ResManager.loadKDString((String)"\u5e01\u79cd\u4e3a\u7a7a\u3002", (String)"StatementImportTask_2", (String)"tmc-bei-business", (Object[])new Object[0]));
        } else {
            QFilter curFilter = new QFilter("number", "=", (Object)currency);
            DynamicObject queryCur = TmcDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)"id", (QFilter[])curFilter.toArray());
            if (EmptyUtil.isEmpty((DynamicObject)queryCur)) {
                errorMessage.append(ResManager.loadKDString((String)"\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u7cfb\u7edf\u4e2d\u8be5\u5e01\u79cd\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u5bfc\u5165\u65b0\u589e\u3002", (String)"StatementImportTask_5", (String)"tmc-bei-business", (Object[])new Object[0]));
            }
        }
        String year = reconciliation.getYear();
        String month = reconciliation.getMonth();
        if (EmptyUtil.isEmpty((String)year) || EmptyUtil.isEmpty((String)month)) {
            errorMessage.append(ResManager.loadKDString((String)"\u6240\u5c5e\u671f\u95f4\u4e3a\u7a7a\u3002", (String)"StatementImportTask_3", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
        return errorMessage.toString();
    }
}

