/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.service.detail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.bei.business.ebservice.request.MatchElecBalanceRequestBuilder;
import kd.tmc.bei.business.opservice.result.ElecBalanceResult;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.errorcode.EBBizErrorCode;
import kd.tmc.fbp.service.ebservice.exception.EBBizNCException;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.webapi.ebentity.biz.elecbalance.BalanceReconciliationResponseBody;

public class ElecBalanceMatchService
implements IEBService<ElecBalanceResult> {
    private static final Log logger = LogFactory.getLog(ElecBalanceMatchService.class);
    private final ElecBalanceResult result = new ElecBalanceResult();
    private DynamicObject elecBalanceStateBill;
    private Boolean isMatch;

    public ElecBalanceMatchService(DynamicObject elecBalanceStateBill, Boolean isMatch) {
        this.elecBalanceStateBill = elecBalanceStateBill;
        this.isMatch = isMatch;
    }

    public boolean validate() {
        return true;
    }

    public void beforeRequest() {
    }

    public void rollback(String errMsg, Exception e) {
        this.result.setErrMsg(errMsg);
    }

    public void handleEBException(String resultBody, String errMsg, Exception e) {
        this.result.setErrMsg(errMsg);
    }

    public void handleResultBody(String resultBody) {
        if (StringUtils.isEmpty((String)resultBody)) {
            throw new EBBizNCException(new EBBizErrorCode().RESPONSE_ISNULL());
        }
        BalanceReconciliationResponseBody body = (BalanceReconciliationResponseBody)JSON.parseObject((String)resultBody, (TypeReference)new TypeReference<BalanceReconciliationResponseBody>(){}, (Feature[])new Feature[0]);
        if (EmptyUtil.isNoEmpty((Object)body)) {
            logger.info("elecBalanceMatch:success");
            if (this.isMatch.booleanValue()) {
                this.elecBalanceStateBill.set("feedbackstate", (Object)body.getEbStatus());
                this.elecBalanceStateBill.set("bankreturnmsg", (Object)body.getBankStatusMsg());
                this.elecBalanceStateBill.set("feedbackperson", (Object)RequestContext.get().getCurrUserId());
                this.elecBalanceStateBill.set("feedbacktime", (Object)DateUtils.getCurrentTime());
                this.elecBalanceStateBill.set("matchresult", (Object)"Y");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.elecBalanceStateBill});
            }
        } else {
            logger.info("elecBalanceMatch:empty");
        }
    }

    public IEBRequestBuilder getRequestBuilder() {
        return new MatchElecBalanceRequestBuilder(this.elecBalanceStateBill, this.isMatch);
    }

    public String getEntityName() {
        return "bei_elecbalancestate";
    }

    public BankLogInfo getBankLogInfo() {
        BankLogInfo bankLogInfo = new BankLogInfo();
        bankLogInfo.setEntityName("bei_elecbalancestate");
        bankLogInfo.setBillNo(this.elecBalanceStateBill.getString("billno"));
        DynamicObject company = this.elecBalanceStateBill.getDynamicObject("company");
        Long orgId = company != null && company.getLong("id") != 0L ? company.getLong("id") : RequestContext.get().getOrgId();
        bankLogInfo.setOrgid(orgId);
        return bankLogInfo;
    }

    public ElecBalanceResult getEBResult() {
        return this.result;
    }

    public String getServiceUrl() {
        return "/kapi/app/receipt/receiptQuery";
    }

    public Long getBankCateId() {
        return null;
    }
}

