/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.service.elecacc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.tmc.bei.business.ebservice.request.BalanceStatementAccRequestBuilder;
import kd.tmc.bei.business.opservice.param.ElecBalanceAccQueryParam;
import kd.tmc.bei.business.opservice.result.ElecBalanceResult;
import kd.tmc.bei.common.enums.BillStatusEnum;
import kd.tmc.bei.common.enums.DataSourceEnum;
import kd.tmc.bei.common.enums.ElecStatementStatusEnum;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.errorcode.EBBizErrorCode;
import kd.tmc.fbp.service.ebservice.exception.EBBizNCException;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.webapi.ebentity.biz.elecbalanceacc.BalanceStatementDetail;
import kd.tmc.fbp.webapi.ebentity.biz.elecbalanceacc.BalanceStatementResponseBody;

public class ElecBalanceAccQueryService
implements IEBService<ElecBalanceResult> {
    private static final Log logger = LogFactory.getLog(ElecBalanceAccQueryService.class);
    private final ElecBalanceResult result = new ElecBalanceResult();
    private final ElecBalanceAccQueryParam queryParam;

    public ElecBalanceAccQueryService(ElecBalanceAccQueryParam queryParam) {
        this.queryParam = queryParam;
    }

    public boolean validate() {
        return true;
    }

    public void beforeRequest() {
    }

    public void rollback(String errMsg, Exception e) {
        this.result.setErrMsg(errMsg);
    }

    public void handleEBException(String resultBody, String errMsg, Exception e) {
        this.result.setErrMsg(errMsg);
    }

    public void handleResultBody(String resultBody) {
        if (StringUtils.isEmpty((String)resultBody)) {
            throw new EBBizNCException(new EBBizErrorCode().RESPONSE_ISNULL());
        }
        BalanceStatementResponseBody body = (BalanceStatementResponseBody)JSON.parseObject((String)resultBody, (TypeReference)new TypeReference<BalanceStatementResponseBody>(){}, (Feature[])new Feature[0]);
        List details = body.getBalanceStatements();
        if (EmptyUtil.isNoEmpty((Object)details) && details.size() > 0) {
            ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(details.size());
            ArrayList<Object> updateList = new ArrayList<Object>(details.size());
            for (BalanceStatementDetail detail : details) {
                String balance;
                String finishKey;
                String accNo = detail.getAccNo();
                String month = detail.getMonth();
                Set<String> finishKeySet = this.queryParam.getFinishKey();
                if (CollectionUtils.isNotEmpty(finishKeySet) && finishKeySet.contains(finishKey = accNo + detail.getCurrency() + month)) continue;
                DynamicObject bankAcct = this.getBankAcctByNo(accNo);
                Date period = DateUtils.stringToDate((String)month, (String)"yyyyMM");
                QFilter qFilter = new QFilter("accountbank", "=", bankAcct.getPkValue());
                qFilter.and("currency", "=", this.queryParam.getCurrency().getPkValue());
                qFilter.and("period", "=", (Object)period);
                Object[] states = TmcDataServiceHelper.load((String)"bei_elecbalancestate_acc", (String)"id,amount,modifytime,modifier", (QFilter[])qFilter.toArray());
                logger.info("\u8d26\u53f7{},\u5e01\u79cd{},\u6240\u5c5e\u671f\u95f4{},\u662f\u5426\u5b58\u5728{}", new Object[]{accNo, detail.getCurrency(), month, EmptyUtil.isNoEmpty((Object[])states)});
                if (EmptyUtil.isEmpty((Object[])states)) {
                    DynamicObject bill = BusinessDataServiceHelper.newDynamicObject((String)"bei_elecbalancestate_acc");
                    bill.set("billtype", (Object)"bei_elecbalancestate_acc");
                    bill.set("accountbank", bankAcct.getPkValue());
                    bill.set("banktype", bankAcct.getDynamicObject("bank.bank_cate").getPkValue());
                    bill.set("currency", this.queryParam.getCurrency().getPkValue());
                    bill.set("period", (Object)period);
                    bill.set("company", bankAcct.getDynamicObject("company").getPkValue());
                    bill.set("bank", (Object)bankAcct.getDynamicObject("bank"));
                    balance = detail.getBalance();
                    if (EmptyUtil.isNoEmpty((String)balance)) {
                        bill.set("amount", (Object)new BigDecimal(balance));
                    }
                    bill.set("stateno", (Object)detail.getStatementNo());
                    bill.set("bankstatus", (Object)ElecStatementStatusEnum.OP.getValue());
                    bill.set("isfile", (Object)detail.getFlag());
                    if (detail.getFlag() == 1) {
                        DynamicObjectCollection urlEntry = bill.getDynamicObjectCollection("urlentry");
                        DynamicObject urlAddNew = urlEntry.addNew();
                        String filePath = detail.getFilePath();
                        urlAddNew.set("e_fileservicepath", (Object)filePath);
                        if (filePath.contains(".")) {
                            urlAddNew.set("e_filesuffix", (Object)filePath.substring(filePath.lastIndexOf(".")));
                        }
                    }
                    bill.set("datasource", (Object)DataSourceEnum.FROMBANK.getValue());
                    Timestamp curTime = DateUtils.getCurrentTime();
                    bill.set("jointime", (Object)curTime);
                    bill.set("joindate", (Object)curTime);
                    bill.set("createtime", (Object)curTime);
                    bill.set("creator", (Object)RequestContext.get().getCurrUserId());
                    bill.set("modifytime", (Object)curTime);
                    bill.set("modifier", (Object)RequestContext.get().getCurrUserId());
                    bill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
                    String billNo = CodeRuleHelper.generateNumber((String)"bei_elecstatement", (DynamicObject)bill, null, null);
                    bill.set("billno", (Object)billNo);
                    saveList.add(bill);
                    continue;
                }
                if (!EmptyUtil.isNoEmpty((Object[])states) || !this.queryParam.isQueryFromBank()) continue;
                Object state = states[0];
                state.set("modifytime", (Object)DateUtils.getCurrentTime());
                state.set("modifier", (Object)RequestContext.get().getCurrUserId());
                balance = detail.getBalance();
                if (EmptyUtil.isNoEmpty((String)balance)) {
                    state.set("amount", (Object)new BigDecimal(balance));
                }
                updateList.add(state);
            }
            if (saveList.size() > 0) {
                logger.info(" elecBalanceAccQuery[addNewData]:" + saveList.size());
                SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
            }
            if (updateList.size() > 0) {
                logger.info(" elecBalanceAccQuery[updateData]:" + updateList.size());
                SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
            }
            this.result.setCount(saveList.size());
        } else {
            logger.info(" detail is null [elecBalanceAccQuery] ");
        }
    }

    public IEBRequestBuilder getRequestBuilder() {
        return new BalanceStatementAccRequestBuilder(this.queryParam);
    }

    public String getEntityName() {
        return "bei_elecbalancestate_acc";
    }

    public BankLogInfo getBankLogInfo() {
        BankLogInfo bankLogInfo = new BankLogInfo();
        bankLogInfo.setEntityName(this.getEntityName());
        bankLogInfo.setOrgid(Long.valueOf(RequestContext.get().getOrgId()));
        return bankLogInfo;
    }

    public ElecBalanceResult getEBResult() {
        return this.result;
    }

    public Long getBankCateId() {
        return null;
    }

    private DynamicObject getBankAcctByNo(String acctNo) {
        QFilter filter = new QFilter("bankaccountnumber", "=", (Object)acctNo);
        return TmcDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (String)"id,company,bank,bank.bank_cate", (QFilter[])filter.toArray());
    }
}

