/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.service.elecacc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.bei.business.ebservice.request.QueryBalanceReconciliationRequestBuilder;
import kd.tmc.bei.business.opservice.param.QueryBalanceReconciliationParam;
import kd.tmc.bei.business.opservice.result.ElecBalanceResult;
import kd.tmc.bei.common.enums.ElecStatementStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.errorcode.EBBizErrorCode;
import kd.tmc.fbp.service.ebservice.exception.EBBizNCException;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.webapi.ebentity.biz.elecbalanceacc.BalanceReconciliationDetail;
import kd.tmc.fbp.webapi.ebentity.biz.elecbalanceacc.QueryBalanceReconciliationResponseBody;

public class ElecBalanceAccSyncService
implements IEBService<ElecBalanceResult> {
    private static final Log logger = LogFactory.getLog(ElecBalanceAccSyncService.class);
    private final ElecBalanceResult result = new ElecBalanceResult();
    private final QueryBalanceReconciliationParam queryParam;

    public ElecBalanceAccSyncService(QueryBalanceReconciliationParam queryParam) {
        this.queryParam = queryParam;
    }

    public boolean validate() {
        return true;
    }

    public void beforeRequest() {
    }

    public void rollback(String errMsg, Exception e) {
        this.result.setErrMsg(errMsg);
    }

    public void handleEBException(String resultBody, String errMsg, Exception e) {
        this.result.setErrMsg(errMsg);
    }

    public void handleResultBody(String resultBody) {
        if (StringUtils.isEmpty((String)resultBody)) {
            throw new EBBizNCException(new EBBizErrorCode().RESPONSE_ISNULL());
        }
        QueryBalanceReconciliationResponseBody responseBody = (QueryBalanceReconciliationResponseBody)JSON.parseObject((String)resultBody, (TypeReference)new TypeReference<QueryBalanceReconciliationResponseBody>(){}, (Feature[])new Feature[0]);
        List details = responseBody.getBalanceReconciliations();
        if (EmptyUtil.isNoEmpty((Object)details) && details.size() > 0) {
            ArrayList<Object> updateList = new ArrayList<Object>(details.size());
            for (BalanceReconciliationDetail detail : details) {
                String accNo = detail.getAccNo();
                DynamicObject bankAcct = this.getBankAcctByNo(accNo);
                String month = detail.getMonth();
                Date period = DateUtils.stringToDate((String)month, (String)"yyyyMM");
                QFilter qFilter = new QFilter("accountbank", "=", bankAcct.getPkValue());
                qFilter.and("currency", "=", this.queryParam.getCurrency().getPkValue());
                qFilter.and("period", "=", (Object)period);
                Object[] states = TmcDataServiceHelper.load((String)"bei_elecbalancestate_acc", (String)"id,bankstatus,modifytime,modifier", (QFilter[])qFilter.toArray());
                if (!EmptyUtil.isNoEmpty((Object[])states)) continue;
                Object state = states[0];
                state.set("bankstatus", (Object)ElecStatementStatusEnum.getValueByBankStatus((String)detail.getStatus()));
                state.set("modifytime", (Object)DateUtils.getCurrentTime());
                state.set("modifier", (Object)RequestContext.get().getCurrUserId());
                updateList.add(state);
            }
            if (updateList.size() > 0) {
                logger.info(" elecBalanceAccQuery[updateData]:" + updateList.size());
                SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
            }
            this.result.setCount(updateList.size());
        } else {
            logger.info(" detail is null [elecBalanceAccQuery] ");
        }
    }

    public IEBRequestBuilder getRequestBuilder() {
        return new QueryBalanceReconciliationRequestBuilder(this.queryParam);
    }

    public String getEntityName() {
        return "bei_elecbalancestate_acc";
    }

    public BankLogInfo getBankLogInfo() {
        BankLogInfo bankLogInfo = new BankLogInfo();
        bankLogInfo.setEntityName(this.getEntityName());
        bankLogInfo.setOrgid(Long.valueOf(RequestContext.get().getOrgId()));
        return bankLogInfo;
    }

    public ElecBalanceResult getEBResult() {
        return this.result;
    }

    public Long getBankCateId() {
        return null;
    }

    private DynamicObject getBankAcctByNo(String acctNo) {
        QFilter filter = new QFilter("bankaccountnumber", "=", (Object)acctNo);
        return TmcDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (String)"id,company,bank,bank.bank_cate", (QFilter[])filter.toArray());
    }
}

