/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.service.others;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.BeiParameterHelper;
import kd.tmc.fbp.service.ebservice.bean.RollbackResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import org.apache.commons.lang3.tuple.Pair;

public class BankAgentBillRollbackService {
    private static Log logger = LogFactory.getLog(BankAgentBillRollbackService.class);
    private static BankAgentBillRollbackService instance;

    private BankAgentBillRollbackService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BankAgentBillRollbackService getInstance() {
        Class<BankAgentBillRollbackService> clazz = BankAgentBillRollbackService.class;
        synchronized (BankAgentBillRollbackService.class) {
            if (instance == null) {
                instance = new BankAgentBillRollbackService();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public List<RollbackResult> bankBillRollback(String entityName, List<Long> payBillIdList, boolean isRepay) {
        String payStatusProp = "bei_bankpaybill".equals(entityName) ? "bankpaystate" : "paystate";
        String sourceBillIdProp = isRepay ? "lastsourcebillid" : "sourcebillid";
        DynamicObject[] targetBillArr = BusinessDataServiceHelper.load((String)entityName, (String)String.join((CharSequence)",", "sourcebillid", "company", "billstatus", "lastsourcebillid", payStatusProp), (QFilter[])new QFilter[]{new QFilter(sourceBillIdProp, "in", (Object)payBillIdList.toArray()), new QFilter("isbitback", "=", (Object)"0"), new QFilter("billstatus", "!=", (Object)"F")});
        List<RollbackResult> resultList = payBillIdList.stream().map(o -> {
            boolean existsBankBill = Arrays.stream(targetBillArr).anyMatch(t -> t.get(sourceBillIdProp).equals(o));
            RollbackResult result = new RollbackResult();
            result.setPayBillId(o);
            result.setStatusCode(existsBankBill ? EBResultStatusCode.SUCCESS : EBResultStatusCode.ROLLBACK);
            return result;
        }).collect(Collectors.toList());
        if (targetBillArr.length != 0) {
            Map<Object, List<DynamicObject>> bankBillOrgMap = Arrays.stream(targetBillArr).collect(Collectors.groupingBy(o -> o.getDynamicObject("company").getPkValue()));
            ArrayList tempStatusIdList = new ArrayList();
            for (Map.Entry<Object, List<DynamicObject>> entry : bankBillOrgMap.entrySet()) {
                Iterator orgId = entry.getKey();
                ArrayList<String> tempStatusList = new ArrayList<String>();
                boolean isBankBillAudit = BeiParameterHelper.getAppBoolParameter((long)((Long)((Object)orgId)), (String)"bei002");
                boolean isNeedCommitBe = BeiParameterHelper.isBizBillCommitBe((long)((Long)((Object)orgId)));
                if (!isNeedCommitBe) {
                    if (isBankBillAudit) {
                        tempStatusList.add(BillStatusEnum.SAVE.getValue());
                    } else {
                        tempStatusList.add(BillStatusEnum.SUBMIT.getValue());
                    }
                } else {
                    tempStatusList.addAll(Arrays.asList(BillStatusEnum.SUBMIT.getValue(), BillStatusEnum.AUDIT.getValue()));
                }
                tempStatusIdList.addAll(entry.getValue().stream().filter(o -> tempStatusList.contains(o.getString("billstatus")) && o.getString(payStatusProp).equals("OP")).map(o -> Pair.of((Object)o.getPkValue(), (Object)o.get(sourceBillIdProp))).collect(Collectors.toList()));
            }
            if (tempStatusIdList.size() > 0) {
                try (TXHandle txHandle = TX.requiresNew();){
                    try {
                        for (Pair pair : tempStatusIdList) {
                            Object id = pair.getLeft();
                            Object sourceId = pair.getRight();
                            QFilter idFilter = new QFilter("id", "=", id);
                            QFilter payStateFilter = new QFilter(payStatusProp, "=", (Object)BeBillStatusEnum.OP.getValue());
                            boolean deleteSuccess = DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{idFilter, payStateFilter}) > 0;
                            for (RollbackResult result : resultList) {
                                if (!result.getPayBillId().equals(sourceId)) continue;
                                if (deleteSuccess) {
                                    result.setStatusCode(EBResultStatusCode.ROLLBACK);
                                    continue;
                                }
                                result.setStatusCode(EBResultStatusCode.ERROR);
                                result.setErrMsg(ResManager.loadKDString((String)"\u94f6\u884c\u5355\u636e\u5220\u9664\u5931\u8d25\u3002", (String)"BankAgentBillRollbackService_0", (String)"tmc-bei-business", (Object[])new Object[0]));
                            }
                        }
                    }
                    catch (Exception e) {
                        txHandle.markRollback();
                        logger.error((Throwable)e);
                        for (Pair tempStatusIdPair : tempStatusIdList) {
                            Object payBillId = tempStatusIdPair.getRight();
                            for (RollbackResult result : resultList) {
                                if (!result.getPayBillId().equals(payBillId)) continue;
                                result.setStatusCode(EBResultStatusCode.ERROR);
                                result.setErrMsg(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                            }
                        }
                    }
                }
            }
        }
        return resultList;
    }
}

