/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.service.others;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.bei.business.ebservice.SyncStatusInfoFactory;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;

public class BankPayBillSyncService {
    private static BankPayBillSyncService instance;

    private BankPayBillSyncService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BankPayBillSyncService getInstance() {
        Class<BankPayBillSyncService> clazz = BankPayBillSyncService.class;
        synchronized (BankPayBillSyncService.class) {
            if (instance == null) {
                instance = new BankPayBillSyncService();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public List<SyncStatusInfo> sync(String entityName, List<Long> payBillIdList) {
        String sourceBillIdProp = "sourcebillid";
        DynamicObject[] bankBillArr = BusinessDataServiceHelper.load((String)entityName, (String)"id", (QFilter[])new QFilter[]{new QFilter(sourceBillIdProp, "in", (Object)payBillIdList.toArray()), new QFilter("isbitback", "=", (Object)"0"), new QFilter("billstatus", "!=", (Object)"F")});
        if (bankBillArr.length > 0) {
            bankBillArr = BusinessDataServiceHelper.load((Object[])Arrays.stream(bankBillArr).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        }
        ArrayList<DynamicObject> bankBillList = new ArrayList<DynamicObject>(bankBillArr.length);
        bankBillList.addAll(Arrays.asList(bankBillArr));
        List<SyncStatusInfo> resultList = payBillIdList.stream().filter(o -> bankBillList.stream().noneMatch(t -> t.get(sourceBillIdProp).equals(o))).map(o -> {
            SyncStatusInfo result = new SyncStatusInfo();
            result.setPayBillId(o);
            result.setStatusCode(EBResultStatusCode.ROLLBACK);
            return result;
        }).collect(Collectors.toList());
        if (bankBillList.size() > 0) {
            List<SyncStatusInfo> syncStatusInfoList = SyncStatusInfoFactory.createSyncStatusInfo(entityName, bankBillList);
            resultList.addAll(syncStatusInfoList);
        }
        return resultList;
    }
}

