/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.service.pay;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bei.business.ebservice.log.BankLogInfoFactory;
import kd.tmc.bei.business.ebservice.request.PayRequestBuilder;
import kd.tmc.bei.business.ebservice.request.datasource.banktrans.BankTransDownRequestDataSource;
import kd.tmc.bei.business.ebservice.service.pay.AbstractPayService;
import kd.tmc.bei.common.helper.BankCateHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusDetail;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.errorcode.EBBizErrorCode;
import kd.tmc.fbp.service.ebservice.exception.EBSQLException;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayDetail;

public class BankTransDownPayService
extends AbstractPayService {
    private List<DynamicObject> bankBillList;
    private String batchSeqId;

    public BankTransDownPayService(List<DynamicObject> bankBillList, boolean isBankPay) {
        super(isBankPay);
        this.bankBillList = bankBillList;
        this.batchSeqId = bankBillList.get(0).getString("id");
    }

    @Override
    protected void beforeDoRequest() {
        List idList = this.bankBillList.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        int[] result = DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)("update t_bei_banktransdownbill set fpaystate = ? where fid in (" + TmcBusinessBaseHelper.idListToString(idList) + ") and fpaystate = ? and fbillstatus = ?"), Collections.singletonList(new Object[]{BeBillStatusEnum.OS.getValue(), BeBillStatusEnum.OP.getValue(), BillStatusEnum.AUDIT.getValue()}));
        if (result.length < 1 || result[0] != this.bankBillList.size()) {
            throw new EBSQLException(new EBBizErrorCode().UPDATE_SQL_EXCEPTION());
        }
        for (DynamicObject bankTransDownBill : this.bankBillList) {
            DynamicObjectCollection entries = bankTransDownBill.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entries) {
                entry.set("status", (Object)BeBillStatusEnum.OS.getValue());
            }
            bankTransDownBill.set("serialnumber", (Object)this.batchSeqId);
            bankTransDownBill.set("submittime", (Object)new Date());
            bankTransDownBill.set("paystate", (Object)BeBillStatusEnum.OS.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])this.bankBillList.toArray(new DynamicObject[0]));
    }

    @Override
    protected List<SyncStatusInfo> handleSuccessResult(List<PayDetail> details) {
        ArrayList<SyncStatusInfo> resultList = new ArrayList<SyncStatusInfo>(this.bankBillList.size());
        Map detailSeqIdToDetailMap = details.stream().collect(Collectors.toMap(PayDetail::getDetailSeqID, Function.identity(), (a, b) -> a));
        for (DynamicObject bankAgentBill : this.bankBillList) {
            DynamicObjectCollection entryList = bankAgentBill.getDynamicObjectCollection("entrys");
            SyncStatusInfo syncInfo = new SyncStatusInfo();
            ArrayList<SyncStatusDetail> syncStatusList = new ArrayList<SyncStatusDetail>(details.size());
            syncInfo.setDetailList(syncStatusList);
            String batchSeqId = null;
            for (DynamicObject entry : entryList) {
                String entryIdStr = entry.getPkValue().toString();
                PayDetail detail = (PayDetail)detailSeqIdToDetailMap.get(entryIdStr);
                if (detail == null) continue;
                if (batchSeqId == null) {
                    batchSeqId = detail.getBatchSeqID();
                }
                SyncStatusDetail syncDetail = new SyncStatusDetail();
                syncDetail.setEbSeqId(detail.getEbSeqId());
                syncDetail.setEbStatusMsg(detail.getEbStatusMsg());
                syncDetail.setBankMsg(detail.getBankMsg());
                syncDetail.setBankBatchSeqId(detail.getBankBatchSeqId());
                syncDetail.setBankDetailSeqId(detail.getBankDetailSeqId());
                syncDetail.setResponseSerialNo(detail.getResponseSerialNo());
                syncDetail.setBankEntryPayStatus(entry.getString("status"));
                syncDetail.setPayBillEntryId(Long.valueOf(entry.getLong("sourceentryid")));
                syncStatusList.add(syncDetail);
            }
            if (batchSeqId == null) continue;
            ArrayList detailList = new ArrayList(details.size());
            syncInfo.setDetailList(detailList);
            syncInfo.setBatchSeqId(batchSeqId);
            syncInfo.setStatusCode(EBResultStatusCode.SUCCESS);
            syncInfo.setErrMsg(null);
            syncInfo.setBankBillId((Long)bankAgentBill.getPkValue());
            syncInfo.setPayBillId(Long.valueOf(bankAgentBill.getLong("sourcebillid")));
            syncInfo.setEntityType("fca_transdownbill");
            syncInfo.setBankPayStatus(bankAgentBill.getString("paystate"));
            resultList.add(syncInfo);
        }
        return resultList;
    }

    @Override
    protected void handleEBException(String errMsg) {
        for (DynamicObject bankTransDownBill : this.bankBillList) {
            for (DynamicObject entry : bankTransDownBill.getDynamicObjectCollection("entrys")) {
                entry.set("status", (Object)BeBillStatusEnum.OS.getValue());
                entry.set("bankreturnmsg", (Object)errMsg);
            }
        }
        TmcDataServiceHelper.save((DynamicObject[])this.bankBillList.toArray(new DynamicObject[0]));
    }

    @Override
    protected void handleBankPayRollback(String errMsg) {
        for (DynamicObject bankTransDownBill : this.bankBillList) {
            DynamicObjectCollection entries = bankTransDownBill.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entries) {
                entry.set("status", (Object)BeBillStatusEnum.OP.getValue());
                entry.set("serialnumber", null);
                String preError = String.format(ResManager.loadKDString((String)"\u5904\u7406\u524d\u5931\u8d25%s", (String)"EBBizErrorCode_5", (String)"tmc-fbp-mservice", (Object[])new Object[0]), ":");
                if (!errMsg.contains(preError)) continue;
                try {
                    String jsonStr = errMsg.split(preError)[1];
                    Map map = (Map)JSON.parseObject((String)jsonStr, Map.class);
                    for (Map.Entry message : map.entrySet()) {
                        if (!String.valueOf(entry.getPkValue()).equals(message.getKey())) continue;
                        entry.set("bankreturnmsg", (Object)errMsg);
                    }
                }
                catch (Exception e) {
                    entry.set("bankreturnmsg", (Object)errMsg);
                }
            }
            bankTransDownBill.set("submittime", null);
            bankTransDownBill.set("paystate", (Object)BeBillStatusEnum.OP.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])this.bankBillList.toArray(new DynamicObject[0]));
    }

    @Override
    protected void handleBizPayRollback(String errMsg) {
        Object[] sourceBillIdArr = this.bankBillList.stream().map(o -> o.getLong("lastsourcebillid")).filter(o -> o != 0L).toArray();
        if (sourceBillIdArr.length > 0) {
            DynamicObject[] sourceBillArr;
            for (DynamicObject sourceBill : sourceBillArr = TmcDataServiceHelper.load((Object[])sourceBillIdArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getEntityName()))) {
                sourceBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
                sourceBill.set("payunique", (Object)-1L);
            }
            SaveServiceHelper.save((DynamicObject[])sourceBillArr);
        }
        Object[] idArr = this.bankBillList.stream().map(DataEntityBase::getPkValue).toArray();
        QFilter idFilter = new QFilter("id", "in", (Object)idArr);
        QFilter payStateFilter = new QFilter("paystate", "=", (Object)BeBillStatusEnum.OS.getValue());
        int lines = DeleteServiceHelper.delete((String)this.getEntityName(), (QFilter[])new QFilter[]{idFilter, payStateFilter});
        if (lines != this.bankBillList.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u94f6\u884c\u4ed8\u6b3e\u72b6\u6001\u5df2\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u518d\u64cd\u4f5c\u3002", (String)"GenerateBankPayBillService_0", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
    }

    public IEBRequestBuilder getRequestBuilder() {
        BankTransDownRequestDataSource bankTransDownRequestDataSource = new BankTransDownRequestDataSource(this.batchSeqId, this.bankBillList);
        return new PayRequestBuilder("pay_for_capital_allocation", bankTransDownRequestDataSource, true);
    }

    public String getEntityName() {
        return "bei_banktransdownbill";
    }

    public BankLogInfo getBankLogInfo() {
        return BankLogInfoFactory.generateBankTransLog(this.bankBillList);
    }

    @Override
    protected List<DynamicObject> getBankBillList() {
        return this.bankBillList;
    }

    public Long getBankCateId() {
        return BankCateHelper.getBankCateId((DynamicObject)this.bankBillList.get(0).getDynamicObject("accountbank"));
    }
}

