/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.service.query;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.bei.business.ebservice.log.BankLogInfoFactory;
import kd.tmc.bei.business.ebservice.request.QueryOverseaPayRequestBuilder;
import kd.tmc.bei.business.ebservice.request.QueryPayRequestBuilder;
import kd.tmc.bei.business.ebservice.request.datasource.bankpay.BankPayRequestDataSource;
import kd.tmc.bei.business.ebservice.service.query.AbstractQueryService;
import kd.tmc.bei.business.helper.BankPayQueryExtHelper;
import kd.tmc.bei.common.enums.BeiMsgTemplateEnum;
import kd.tmc.bei.common.helper.BankCateHelper;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.helper.NoticeMsgHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusDetail;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.exception.EBBizNCException;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.utils.BeServiceHelper;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayBody;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayDetail;

public class BankPayQueryService
extends AbstractQueryService {
    private static Log logger = LogFactory.getLog(BankPayQueryService.class);
    private String batchSeqId;

    public BankPayQueryService(List<DynamicObject> bankPayBillList, boolean isForceQuery) {
        super(bankPayBillList, isForceQuery);
        this.batchSeqId = bankPayBillList.get(0).getString("serialnumber");
    }

    @Override
    protected List<SyncStatusInfo> handlePayDetails(List<PayDetail> details) {
        ArrayList<SyncStatusInfo> resultList = new ArrayList<SyncStatusInfo>(this.bankPayBillList.size());
        Map idToBankBillMap = this.bankPayBillList.stream().collect(Collectors.toMap(o -> o.getString("id"), Function.identity()));
        ArrayList<DynamicObject> noticeBankPayBills = new ArrayList<DynamicObject>(10);
        for (int i = 0; i < details.size(); ++i) {
            String ebStatusMsg;
            DynamicObject bankPayBill;
            PayDetail detail = details.get(i);
            if (!Objects.equals(this.batchSeqId, detail.getBatchSeqID()) || (bankPayBill = (DynamicObject)idToBankBillMap.get(detail.getDetailSeqID())) == null) continue;
            SyncStatusInfo syncInfo = new SyncStatusInfo();
            resultList.add(syncInfo);
            ArrayList<SyncStatusDetail> detailList = new ArrayList<SyncStatusDetail>(details.size());
            syncInfo.setDetailList(detailList);
            SyncStatusDetail syncDetail = new SyncStatusDetail();
            detailList.add(syncDetail);
            String srcBillType = bankPayBill.getString("srcbilltype");
            if (StringUtils.isEmpty((String)srcBillType)) {
                srcBillType = "cas_paybill";
            }
            syncInfo.setEntityType(srcBillType);
            BeBillStatusEnum entryStatus = BeServiceHelper.transferState((String)detail.getEbStatus());
            String oldState = bankPayBill.getString("bankpaystate");
            boolean needUpdateBankLogState = !oldState.equals(entryStatus.getValue());
            bankPayBill.set("bankpaystate", (Object)entryStatus.getValue());
            if (BeBillStatusEnum.TS.getValue().equals(entryStatus.getValue())) {
                bankPayBill.set("paytime", (Object)new Date());
                syncDetail.setPayDate(bankPayBill.getDate("paytime"));
                bankPayBill.set("returntime", (Object)new Date());
                if (EmptyUtil.isNoEmpty((String)detail.getActualAmount())) {
                    bankPayBill.set("exchangeamount", (Object)new BigDecimal(detail.getActualAmount()));
                }
                if (EmptyUtil.isNoEmpty((String)detail.getExchangeRate())) {
                    bankPayBill.set("agreedrate", (Object)new BigDecimal(detail.getExchangeRate()));
                }
                if (EmptyUtil.isNoEmpty((String)detail.getPayerFeeAmount())) {
                    bankPayBill.set("payerfee", (Object)new BigDecimal(detail.getPayerFeeAmount()));
                }
            }
            StringBuilder msgSb = new StringBuilder();
            if (StringUtils.isNotEmpty((String)detail.getBankMsg())) {
                msgSb.append(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4fe1\u606f\uff1a%s\u3002", (String)"BankAgentQueryService_0", (String)"tmc-bei-business", (Object[])new Object[0]), detail.getBankMsg()));
            }
            if (StringUtils.isNotEmpty((String)detail.getEbStatusMsg())) {
                msgSb.append(detail.getEbStatusMsg());
            }
            if (StringUtils.isNotEmpty((String)(ebStatusMsg = msgSb.toString()))) {
                ebStatusMsg = ebStatusMsg.substring(0, Math.min(255, ebStatusMsg.length()));
            }
            bankPayBill.set("bankreturnmsg", (Object)ebStatusMsg);
            String kdFlagId = detail.getKdFlagID();
            if (kdFlagId == null) {
                logger.info("kdFlagId is null");
                kdFlagId = detail.getBankDetailSeqId();
            }
            bankPayBill.set("statementrefno", (Object)kdFlagId);
            Map<String, String> extFieldMap = BankPayQueryExtHelper.getPayQueryResultExtFields();
            for (Map.Entry<String, String> entry : extFieldMap.entrySet()) {
                String extField = entry.getValue();
                if (!EmptyUtil.isNoEmpty((String)extField) || !bankPayBill.containsProperty(extField)) continue;
                String key = entry.getKey();
                String value = null;
                switch (key) {
                    case "reversed1": {
                        value = detail.getReversed1();
                        break;
                    }
                    case "reversed2": {
                        value = detail.getReversed2();
                        break;
                    }
                    case "reversed3": {
                        value = detail.getReversed3();
                        break;
                    }
                    case "reversed4": {
                        value = detail.getReversed4();
                        break;
                    }
                }
                bankPayBill.set(extField, (Object)value);
            }
            boolean isRefund = this.detailIsRefund(detail);
            bankPayBill.set("isrefund", (Object)isRefund);
            syncDetail.setRenote(isRefund);
            if (isRefund) {
                noticeBankPayBills.add(bankPayBill);
            }
            syncInfo.setBatchSeqId(details.get(0).getBatchSeqID());
            syncInfo.setStatusCode(EBResultStatusCode.SUCCESS);
            syncInfo.setErrMsg(null);
            syncInfo.setBankBillId((Long)bankPayBill.getPkValue());
            syncInfo.setPayBillId(Long.valueOf(bankPayBill.getLong("sourcebillid")));
            syncInfo.setBankPayStatus(bankPayBill.getString("bankpaystate"));
            syncDetail.setEbSeqId(detail.getEbSeqId());
            syncDetail.setEbStatusMsg(ebStatusMsg);
            syncDetail.setBankMsg(detail.getBankMsg());
            syncDetail.setBankBatchSeqId(detail.getBankBatchSeqId());
            syncDetail.setBankDetailSeqId(kdFlagId);
            syncDetail.setResponseSerialNo(detail.getResponseSerialNo());
            syncDetail.setActualAmount(detail.getActualAmount());
            syncDetail.setExchangeRate(detail.getExchangeRate());
            syncDetail.setPayerFeeAmount(detail.getPayerFeeAmount());
            if (!needUpdateBankLogState) continue;
            this.updateBankLogWhenSync(bankPayBill, "bankpaystate");
        }
        BeiMsgTemplateEnum msgTemplateEnum = BeiMsgTemplateEnum.BANK_PAYBILL_REFUND;
        NoticeMsgHelper.batchAsyncSendNoticeMsg(noticeBankPayBills, (String)msgTemplateEnum.getTemplateNumber(), (String)msgTemplateEnum.getMsgTag());
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void syncRemoteStatus(List<SyncStatusInfo> syncInfoList) {
        MessagePublisher pub = MQFactory.get().createSimplePublisher("tmc", "kd.tmc.bei.payquery");
        for (SyncStatusInfo syncInfo : syncInfoList) {
            if (syncInfo.getEntityType().equalsIgnoreCase("ifm_transhandlebill")) {
                DispatchServiceHelper.invokeBizService((String)"tmc", (String)"ifm", (String)"ifmEbService", (String)"syncBankBillStatus", (Object[])new Object[]{"ifm_transhandlebill", SerializationUtils.toJsonString((Object)syncInfo)});
                continue;
            }
            if (this.isForceQuery) {
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"casEbService", (String)"syncBankBillStatus", (Object[])new Object[]{"cas_paybill", SerializationUtils.toJsonString((Object)syncInfo)});
                continue;
            }
            try {
                HashMap<String, String> msgParamMap = new HashMap<String, String>();
                msgParamMap.put("entityName", this.getEntityName());
                msgParamMap.put("syncInfo", (String)syncInfo);
                pub.publish(msgParamMap);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            finally {
                pub.close();
            }
        }
    }

    public IEBRequestBuilder getRequestBuilder() {
        boolean isOverseaPay = ((DynamicObject)this.bankPayBillList.get(0)).getBoolean("istranspay");
        if (isOverseaPay) {
            return new QueryOverseaPayRequestBuilder(new BankPayRequestDataSource(this.batchSeqId, this.bankPayBillList));
        }
        return new QueryPayRequestBuilder(new BankPayRequestDataSource(this.batchSeqId, this.bankPayBillList), this.isForceQuery);
    }

    public String getEntityName() {
        return "bei_bankpaybill";
    }

    public BankLogInfo getBankLogInfo() {
        return BankLogInfoFactory.generateBankLogInfo(this.bankPayBillList);
    }

    public Long getBankCateId() {
        return BankCateHelper.getBankCateId((DynamicObject)((DynamicObject)this.bankPayBillList.get(0)).getDynamicObject("accountbank"));
    }

    @Override
    protected void handleRollback(String errMsg, Exception e) {
        for (DynamicObject bankPayBill : this.bankPayBillList) {
            bankPayBill.set("bankreturnmsg", (Object)e.getMessage());
        }
        TmcDataServiceHelper.save((DynamicObject[])this.bankPayBillList.toArray(new DynamicObject[0]));
    }

    @Override
    protected void handleException(PayBody result, Exception e) {
        for (DynamicObject bankPayBill : this.bankPayBillList) {
            String code;
            if (e instanceof EBBizNCException && "tmc.bei.UNKNOWN_BATCH".equals(code = ((EBBizNCException)e).getErrorCode().getCode())) {
                bankPayBill.set("bankpaystate", (Object)BeBillStatusEnum.NC.getValue());
            }
            bankPayBill.set("bankreturnmsg", (Object)e.getMessage());
        }
        TmcDataServiceHelper.save((DynamicObject[])this.bankPayBillList.toArray(new DynamicObject[0]));
    }
}

