/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.service.update;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.bei.business.ebservice.log.BankLogInfoFactory;
import kd.tmc.bei.business.ebservice.request.UpdateRequestBuilder;
import kd.tmc.bei.business.ebservice.request.datasource.bankpay.BankPayRequestDataSource;
import kd.tmc.bei.business.ebservice.service.update.AbstractUpdateService;
import kd.tmc.bei.common.helper.BankCateHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusDetail;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.enums.BankReturnStatusEnum;
import kd.tmc.fbp.service.ebservice.exception.EBBizNCException;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.utils.BeServiceHelper;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayBody;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayDetail;

public class BankPayUpdateService
extends AbstractUpdateService {
    private final DynamicObject bankPayBill;
    private final Map<Long, String> updateStatusMap;
    private final String batchSeqId;

    public BankPayUpdateService(DynamicObject bankPayBill, Map<Long, String> updateStatusMap) {
        super(Collections.singletonList(bankPayBill), false);
        this.bankPayBill = bankPayBill;
        this.updateStatusMap = updateStatusMap;
        this.batchSeqId = ((DynamicObject)this.bankPayBillList.get(0)).getString("serialnumber");
    }

    public IEBRequestBuilder getRequestBuilder() {
        return new UpdateRequestBuilder(new BankPayRequestDataSource(this.bankPayBill), this.updateStatusMap);
    }

    public String getEntityName() {
        return "bei_bankpaybill";
    }

    public BankLogInfo getBankLogInfo() {
        return BankLogInfoFactory.generateBankLogInfo(this.bankPayBillList);
    }

    public Long getBankCateId() {
        return BankCateHelper.getBankCateId((DynamicObject)((DynamicObject)this.bankPayBillList.get(0)).getDynamicObject("accountbank"));
    }

    @Override
    protected List<SyncStatusInfo> handlePayDetails(List<PayDetail> details) {
        ArrayList<SyncStatusInfo> resultList = new ArrayList<SyncStatusInfo>(this.bankPayBillList.size());
        Map idToBankBillMap = this.bankPayBillList.stream().collect(Collectors.toMap(o -> o.getString("id"), Function.identity()));
        for (int i = 0; i < details.size(); ++i) {
            String ebStatusMsg;
            DynamicObject bankPayBill;
            PayDetail detail = details.get(i);
            if (!Objects.equals(this.batchSeqId, detail.getBatchSeqID()) || (bankPayBill = (DynamicObject)idToBankBillMap.get(detail.getDetailSeqID())) == null) continue;
            SyncStatusInfo syncInfo = new SyncStatusInfo();
            resultList.add(syncInfo);
            ArrayList<SyncStatusDetail> detailList = new ArrayList<SyncStatusDetail>(details.size());
            syncInfo.setDetailList(detailList);
            SyncStatusDetail syncDetail = new SyncStatusDetail();
            detailList.add(syncDetail);
            String srcBillType = bankPayBill.getString("srcbilltype");
            if (StringUtils.isEmpty((String)srcBillType)) {
                srcBillType = "cas_paybill";
            }
            syncInfo.setEntityType(srcBillType);
            StringBuilder msgSb = new StringBuilder();
            if (StringUtils.isNotEmpty((String)detail.getBankMsg())) {
                msgSb.append(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4fe1\u606f\uff1a%s\u3002", (String)"BankAgentQueryService_0", (String)"tmc-bei-business", (Object[])new Object[0]), detail.getBankMsg()));
            }
            if (StringUtils.isNotEmpty((String)detail.getEbStatusMsg())) {
                msgSb.append(detail.getEbStatusMsg());
            }
            if (StringUtils.isNotEmpty((String)(ebStatusMsg = msgSb.toString()))) {
                ebStatusMsg = ebStatusMsg.substring(0, Math.min(255, ebStatusMsg.length()));
            }
            BeBillStatusEnum entryStatus = BeServiceHelper.transferState((String)detail.getEbStatus());
            bankPayBill.set("bankpaystate", (Object)entryStatus.getValue());
            bankPayBill.set("bankreturnmsg", (Object)ebStatusMsg);
            if (BeBillStatusEnum.TS.getValue().equals(entryStatus.getValue())) {
                bankPayBill.set("paytime", (Object)new Date());
                syncDetail.setPayDate(bankPayBill.getDate("paytime"));
                bankPayBill.set("returntime", (Object)new Date());
            }
            boolean isSuccess = BankReturnStatusEnum.BANK_SUCCESS.getValue().equals(detail.getUpdateStatus());
            bankPayBill.set("isupdatestate", (Object)isSuccess);
            syncInfo.setBatchSeqId(details.get(0).getBatchSeqID());
            syncInfo.setStatusCode(EBResultStatusCode.SUCCESS);
            syncInfo.setErrMsg(null);
            syncInfo.setBankBillId((Long)bankPayBill.getPkValue());
            syncInfo.setPayBillId(Long.valueOf(bankPayBill.getLong("sourcebillid")));
            syncInfo.setBankPayStatus(bankPayBill.getString("bankpaystate"));
            syncDetail.setEbStatusMsg(ebStatusMsg);
            syncDetail.setBankDetailSeqId(bankPayBill.getString("statementrefno"));
            syncDetail.setActualAmount(detail.getActualAmount());
            syncDetail.setExchangeRate(detail.getExchangeRate());
            syncDetail.setPayerFeeAmount(detail.getPayerFeeAmount());
            this.updateBankLogWhenSync(bankPayBill, "bankpaystate");
            this.setUpdateStatusBillStatus((Long)bankPayBill.getPkValue(), isSuccess, ebStatusMsg);
        }
        this.bankPayBill.set("isupdatingstatus", (Object)0);
        return resultList;
    }

    @Override
    protected void syncRemoteStatus(List<SyncStatusInfo> syncInfoList) {
        for (SyncStatusInfo syncInfo : syncInfoList) {
            if (syncInfo.getEntityType().equalsIgnoreCase("ifm_transhandlebill")) {
                DispatchServiceHelper.invokeBizService((String)"tmc", (String)"ifm", (String)"ifmEbService", (String)"syncBankBillStatus", (Object[])new Object[]{"ifm_transhandlebill", SerializationUtils.toJsonString((Object)syncInfo)});
                continue;
            }
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"casEbService", (String)"syncBankBillStatus", (Object[])new Object[]{"cas_paybill", SerializationUtils.toJsonString((Object)syncInfo)});
        }
    }

    @Override
    protected void handleRollback(String errMsg, Exception e) {
        for (DynamicObject bankPayBill : this.bankPayBillList) {
            bankPayBill.set("bankreturnmsg", (Object)e.getMessage());
        }
        TmcDataServiceHelper.save((DynamicObject[])this.bankPayBillList.toArray(new DynamicObject[0]));
    }

    @Override
    protected void handleException(PayBody result, Exception e) {
        for (DynamicObject bankPayBill : this.bankPayBillList) {
            String code;
            if (e instanceof EBBizNCException && "tmc.bei.UNKNOWN_BATCH".equals(code = ((EBBizNCException)e).getErrorCode().getCode())) {
                bankPayBill.set("bankpaystate", (Object)BeBillStatusEnum.NC.getValue());
            }
            bankPayBill.set("bankreturnmsg", (Object)e.getMessage());
        }
        TmcDataServiceHelper.save((DynamicObject[])this.bankPayBillList.toArray(new DynamicObject[0]));
    }

    @Override
    protected void setUpdateStatusBillStatus(Long sourceId, boolean isSuccess, String ebStatusMsg) {
        if (isSuccess) {
            String SQL = "update t_bei_updatepaystat_entry set fopstatus = 'success' where fsourcebillid = ?";
            DB.execute((DBRoute)DBRouteConst.TMC, (String)SQL, (Object[])new Object[]{sourceId});
        } else {
            String SQL = "update t_bei_updatepaystat_entry set fopstatus = 'failed' ,ferrmsg = ? where fsourcebillid = ?";
            DB.execute((DBRoute)DBRouteConst.TMC, (String)SQL, (Object[])new Object[]{ebStatusMsg, sourceId});
        }
    }
}

