/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.service.update;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.bei.business.ebservice.log.BankLogInfoFactory;
import kd.tmc.bei.business.ebservice.request.UpdateRequestBuilder;
import kd.tmc.bei.business.ebservice.request.datasource.banktrans.BankTransDownRequestDataSource;
import kd.tmc.bei.business.ebservice.service.update.AbstractUpdateService;
import kd.tmc.bei.common.helper.BankCateHelper;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusDetail;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.enums.BankReturnStatusEnum;
import kd.tmc.fbp.service.ebservice.exception.EBBizNCException;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.utils.BeServiceHelper;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayBody;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayDetail;

public class BankTransDownUpdateService
extends AbstractUpdateService {
    private final DynamicObject bankTransDownBill;
    private final Map<Long, String> updateStatusMap;

    public BankTransDownUpdateService(DynamicObject bankTransDownBill, Map<Long, String> updateStatusMap) {
        super(Collections.singletonList(bankTransDownBill), false);
        this.bankTransDownBill = bankTransDownBill;
        this.updateStatusMap = updateStatusMap;
    }

    public IEBRequestBuilder getRequestBuilder() {
        return new UpdateRequestBuilder(new BankTransDownRequestDataSource(this.bankTransDownBill), this.updateStatusMap);
    }

    @Override
    protected List<SyncStatusInfo> handlePayDetails(List<PayDetail> details) {
        ArrayList<SyncStatusInfo> resultList = new ArrayList<SyncStatusInfo>(this.bankPayBillList.size());
        Map detailSeqIdToDetailMap = details.stream().collect(Collectors.toMap(PayDetail::getDetailSeqID, Function.identity(), (a, b) -> a));
        block0: for (DynamicObject bankPayBill : this.bankPayBillList) {
            DynamicObjectCollection entryList = bankPayBill.getDynamicObjectCollection("entrys");
            SyncStatusInfo syncInfo = new SyncStatusInfo();
            ArrayList<SyncStatusDetail> syncStatusList = new ArrayList<SyncStatusDetail>(details.size());
            syncInfo.setDetailList(syncStatusList);
            String batchSeqId = null;
            for (DynamicObject entry : entryList) {
                String ebStatusMsg;
                String entryIdStr = entry.getPkValue().toString();
                BeBillStatusEnum[] detail = (BeBillStatusEnum[])detailSeqIdToDetailMap.get(entryIdStr);
                if (detail == null) continue;
                if (batchSeqId == null) {
                    batchSeqId = detail.getBatchSeqID();
                }
                if (!Objects.equals(batchSeqId, detail.getBatchSeqID())) continue block0;
                SyncStatusDetail syncDetail = new SyncStatusDetail();
                syncDetail.setPayBillEntryId(Long.valueOf(entry.getLong("sourceentryid")));
                String entryStatus = BeServiceHelper.transferState((String)detail.getEbStatus()).getValue();
                entry.set("status", (Object)entryStatus);
                StringBuilder msgSb = new StringBuilder();
                if (StringUtils.isNotEmpty((String)detail.getBankMsg())) {
                    msgSb.append(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4fe1\u606f\uff1a%s\u3002", (String)"BankAgentQueryService_0", (String)"tmc-bei-business", (Object[])new Object[0]), detail.getBankMsg()));
                }
                if (StringUtils.isNotEmpty((String)detail.getEbStatusMsg())) {
                    msgSb.append(detail.getEbStatusMsg());
                }
                if (StringUtils.isNotEmpty((String)(ebStatusMsg = msgSb.toString()))) {
                    ebStatusMsg = ebStatusMsg.substring(0, Math.min(255, ebStatusMsg.length()));
                }
                entry.set("bankreturnmsg", (Object)ebStatusMsg);
                syncDetail.setEbStatusMsg(ebStatusMsg);
                syncDetail.setBankDetailSeqId(entry.getString("bankcheckflag"));
                syncDetail.setBankEntryPayStatus(entryStatus);
                syncStatusList.add(syncDetail);
                boolean isSuccess = BankReturnStatusEnum.BANK_SUCCESS.getValue().equals(detail.getUpdateStatus());
                entry.set("isupdatestate", (Object)isSuccess);
                this.setUpdateStatusBillStatus((Long)entry.getPkValue(), isSuccess, ebStatusMsg);
            }
            if (batchSeqId == null) continue;
            syncInfo.setEntityType("fca_transdownbill");
            String payStatus = this.getPayStatus(entryList);
            bankPayBill.set("paystate", (Object)payStatus);
            syncInfo.setBankPayStatus(payStatus);
            BeBillStatusEnum[] billStatusEnums = BeBillStatusEnum.values();
            HashMap<BeBillStatusEnum, Integer> entryStatusMap = new HashMap<BeBillStatusEnum, Integer>(billStatusEnums.length);
            for (BeBillStatusEnum eachStatus : billStatusEnums) {
                entryStatusMap.put(eachStatus, 0);
            }
            BigDecimal actPayAmount = BigDecimal.ZERO;
            int actPayCount = 0;
            DynamicObjectCollection entry = bankPayBill.getDynamicObjectCollection("entrys");
            for (DynamicObject row : entry) {
                if (BeBillStatusEnum.TS.getValue().equals(row.get("status"))) {
                    BigDecimal amount = row.getBigDecimal("transamt");
                    actPayAmount = actPayAmount.add(amount);
                    ++actPayCount;
                }
                BeBillStatusEnum rowStatus = BeBillStatusEnum.valueOf((String)row.getString("status"));
                entryStatusMap.put(rowStatus, (Integer)entryStatusMap.get(rowStatus) + 1);
            }
            bankPayBill.set("actamount", (Object)actPayAmount);
            bankPayBill.set("actcount", (Object)actPayCount);
            syncInfo.setBatchSeqId(details.get(0).getBatchSeqID());
            syncInfo.setStatusCode(EBResultStatusCode.SUCCESS);
            syncInfo.setErrMsg(null);
            syncInfo.setBankBillId(Long.valueOf(bankPayBill.getLong("id")));
            syncInfo.setPayBillId(Long.valueOf(bankPayBill.getLong("sourcebillid")));
            syncInfo.setBankPayStatus(payStatus);
            resultList.add(syncInfo);
        }
        this.bankTransDownBill.set("isupdatingstatus", (Object)0);
        return resultList;
    }

    public String getEntityName() {
        return "bei_banktransdownbill";
    }

    public BankLogInfo getBankLogInfo() {
        return BankLogInfoFactory.generateBankLogInfo(this.bankPayBillList);
    }

    @Override
    protected void syncRemoteStatus(List<SyncStatusInfo> syncInfoList) {
        for (SyncStatusInfo syncInfo : syncInfoList) {
            DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fca", (String)"PayRpcApiService", (String)"syncBankBillStatus", (Object[])new Object[]{"fca_transdownbill", SerializationUtils.toJsonString((Object)syncInfo)});
        }
    }

    public Long getBankCateId() {
        return BankCateHelper.getBankCateId((DynamicObject)((DynamicObject)this.bankPayBillList.get(0)).getDynamicObject("accountbank"));
    }

    @Override
    protected void handleRollback(String errMsg, Exception e) {
        for (DynamicObject bankPayBill : this.bankPayBillList) {
            for (DynamicObject entry : bankPayBill.getDynamicObjectCollection("entrys")) {
                entry.set("bankreturnmsg", (Object)e.getMessage());
            }
        }
        TmcDataServiceHelper.save((DynamicObject[])this.bankPayBillList.toArray(new DynamicObject[0]));
    }

    @Override
    protected void handleException(PayBody result, Exception e) {
        for (DynamicObject bankPayBill : this.bankPayBillList) {
            String code;
            boolean isUnknownBatch = false;
            if (e instanceof EBBizNCException && "tmc.bei.UNKNOWN_BATCH".equals(code = ((EBBizNCException)e).getErrorCode().getCode())) {
                bankPayBill.set("paystate", (Object)BeBillStatusEnum.NC.getValue());
                isUnknownBatch = true;
            }
            for (DynamicObject entry : bankPayBill.getDynamicObjectCollection("entrys")) {
                entry.set("bankreturnmsg", (Object)e.getMessage());
                if (!isUnknownBatch) continue;
                entry.set("status", (Object)BeBillStatusEnum.NC.getValue());
            }
        }
        TmcDataServiceHelper.save((DynamicObject[])this.bankPayBillList.toArray(new DynamicObject[0]));
    }
}

