/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IPageCache;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.bei.business.bean.AccountPredictDateResult;
import kd.tmc.bei.business.ebservice.EBDetailQueryService;
import kd.tmc.bei.business.ebservice.EBReceiptQueryService;
import kd.tmc.bei.business.opservice.helper.ErrorInfoHelper;
import kd.tmc.bei.business.opservice.param.DetailQueryParam;
import kd.tmc.bei.business.opservice.param.ReceiptQueryParam;
import kd.tmc.bei.business.opservice.result.ElecReceiptResult;
import kd.tmc.bei.business.opservice.result.TransDetailResult;
import kd.tmc.fbp.common.enums.BankFuncEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AccountBankHelper {
    public static AccountPredictDateResult computer(String bankFunction, long compId, long accountId, Date startDate, Date endDate) {
        AccountPredictDateResult result = new AccountPredictDateResult(bankFunction, compId, accountId, startDate, endDate);
        if (!AccountBankHelper.isOpenBeiPredictDate(compId)) {
            return result;
        }
        String props = "id,name,bankaccountnumber,issetbankinterface,entry,entry.e_predictopendate";
        QFilter filter = new QFilter("id", "=", (Object)accountId).and("issetbankinterface", "=", (Object)"1").and("entry.e_enable", "=", (Object)"1").and("entry.e_bankfunction", "=", (Object)bankFunction);
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"am_accountbank", (String)props, (QFilter[])filter.toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)objects)) {
            return result;
        }
        Date predictDate = ((DynamicObject)objects.get(0)).getDate("entry.e_predictopendate");
        if (null != predictDate) {
            predictDate = DateUtils.getDataFormat((Date)predictDate, (boolean)true);
            result.setPredictDate(predictDate);
            if (predictDate.after(endDate)) {
                result.setPermit(true);
            } else if (predictDate.after(startDate)) {
                result.setChange(true);
            }
        }
        result.setAccountBank((DynamicObject)objects.get(0));
        return result;
    }

    public static AccountPredictDateResult computer(String bankFunction, DynamicObject accountBank, Date startDate, Date endDate) {
        AccountPredictDateResult result = AccountBankHelper.computer(bankFunction, accountBank.getDynamicObject("company").getLong("id"), accountBank.getLong("id"), startDate, endDate);
        result.setAccountBank(accountBank);
        return result;
    }

    public static List<AccountPredictDateResult> computerByIds(String bankFunction, Date startDate, Date endDate, Map<Long, Date> acctBank_predictDate, Collection<DynamicObject> accountBanks) {
        List<AccountPredictDateResult> results = accountBanks.stream().filter(t -> EmptyUtil.isNoEmpty((DynamicObject)t.getDynamicObject("company"))).map(t -> new AccountPredictDateResult(bankFunction, startDate, endDate, (DynamicObject)t)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(acctBank_predictDate)) {
            return results;
        }
        Map resultMap = results.stream().filter(t -> acctBank_predictDate.containsKey(t.getAccountId())).collect(Collectors.toMap(AccountPredictDateResult::getAccountId, Function.identity()));
        for (Map.Entry<Long, Date> obj : acctBank_predictDate.entrySet()) {
            Date predictDate = obj.getValue();
            AccountPredictDateResult result = (AccountPredictDateResult)resultMap.get(obj.getKey());
            result.setPredictDate(predictDate);
            if (predictDate.after(endDate)) {
                result.setPermit(true);
                continue;
            }
            if (!predictDate.after(startDate)) continue;
            result.setChange(true);
        }
        return results;
    }

    public static List<AccountPredictDateResult> computerByAcctBanks(String bankFunction, Collection<DynamicObject> accountBanks, Date startDate, Date endDate) {
        Map<Long, Date> acctBank_predictDate = AccountBankHelper.getAcctBankWithPredictDate(accountBanks, bankFunction);
        return AccountBankHelper.computerByIds(bankFunction, startDate, endDate, acctBank_predictDate, accountBanks);
    }

    public static List<AccountPredictDateResult> computerByIds(String bankFunction, List<Long> accountBankIds, Date startDate, Date endDate) {
        String props = "id,name,company,bankaccountnumber";
        Map acctMap = TmcDataServiceHelper.loadFromCache((String)"am_accountbank", (String)props, (QFilter[])new QFilter("id", "in", accountBankIds).toArray());
        Map<Long, Date> acctBank_predictDate = AccountBankHelper.getAcctBankWithPredictDate(acctMap.values(), bankFunction);
        return AccountBankHelper.computerByIds(bankFunction, startDate, endDate, acctBank_predictDate, acctMap.values());
    }

    public static AccountPredictDateResult computerById(String bankFunction, Long accountBankId, Date startDate, Date endDate) {
        return AccountBankHelper.computerByIds(bankFunction, Collections.singletonList(accountBankId), startDate, endDate).get(0);
    }

    public static boolean isOpenBeiPredictDate(long compId) {
        return TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.BEI.getId(), (long)compId, (String)"bei008");
    }

    public static List<OperateErrorInfo> downTransDetailsSync(List<DynamicObject> accountBanks, Date startDate, Date endDate, boolean isSchedule, boolean downloadFromBank) {
        List permitList;
        List<OperateErrorInfo> errorInfos;
        List<AccountPredictDateResult> results = AccountBankHelper.computerByAcctBanks(BankFuncEnum.QUERY.getValue(), accountBanks, startDate, endDate);
        List<OperateErrorInfo> errorInfoList = results.stream().filter(AccountPredictDateResult::isChange).map(t -> AccountBankHelper.doDownTransDetails(Collections.singletonList(t.getAccountBank()), t.getPredictDate(), endDate, isSchedule, downloadFromBank)).flatMap(Collection::stream).collect(Collectors.toList());
        List<DynamicObject> normalList = results.stream().filter(t -> !t.isPermit() && !t.isChange()).map(AccountPredictDateResult::getAccountBank).collect(Collectors.toList());
        if (!normalList.isEmpty() && !CollectionUtils.isEmpty(errorInfos = AccountBankHelper.doDownTransDetails(normalList, startDate, endDate, isSchedule, downloadFromBank))) {
            errorInfoList.addAll(errorInfos);
        }
        if (!(permitList = results.stream().filter(AccountPredictDateResult::isPermit).collect(Collectors.toList())).isEmpty()) {
            List errors = permitList.stream().map(t -> {
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setLevel(ErrorLevel.Error);
                operateErrorInfo.setMessage(String.format(ResManager.loadKDString((String)"\u5f53\u524d%1$s\u94f6\u884c\u8d26\u6237\u8bbe\u7f6e\u7684\u67e5\u8be2\u9884\u8ba1\u5f00\u901a\u65e5\u671f(%2$s)\u5927\u4e8e\u7ed3\u675f\u65e5\u671f\uff0c\u4e0d\u5141\u8bb8\u8054\u673a\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u3002", (String)"AccountBankHelper_0", (String)"tmc-bei-business", (Object[])new Object[0]), t.getAccountBank().getString("bankaccountnumber"), DateUtils.formatString((Date)t.getPredictDate(), (String)"yyyy-MM-dd")));
                operateErrorInfo.setPkValue(t.getAccountBank().getPkValue());
                return operateErrorInfo;
            }).collect(Collectors.toList());
            errorInfoList.addAll(errors);
        }
        return errorInfoList;
    }

    private static List<OperateErrorInfo> doDownTransDetails(List<DynamicObject> accountBanks, Date startDate, Date endDate, boolean isSchedule, boolean downloadFromBank) {
        List<Long> idList = accountBanks.stream().map(d -> (Long)d.getPkValue()).collect(Collectors.toList());
        DetailQueryParam detailQueryParam = new DetailQueryParam(null, startDate, endDate, idList, false);
        detailQueryParam.setSchedule(isSchedule);
        detailQueryParam.setDownloadFromBank(downloadFromBank);
        List<TransDetailResult> results = new EBDetailQueryService(detailQueryParam).downTransDetails();
        return ErrorInfoHelper.convertErrorInfos(results);
    }

    public static OperateErrorInfo downReceipt(DynamicObject accountBank, DynamicObject currency, Date startDate, Date endDate) {
        AccountPredictDateResult result = AccountBankHelper.computer(BankFuncEnum.RECEIPT.getValue(), accountBank, startDate, endDate);
        if (result.isPermit()) {
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setLevel(ErrorLevel.Error);
            operateErrorInfo.setMessage(String.format(ResManager.loadKDString((String)"\u5f53\u524d%1$s\u94f6\u884c\u8d26\u6237\u8bbe\u7f6e\u7684\u67e5\u8be2\u9884\u8ba1\u5f00\u901a\u65e5\u671f(%2$s)\u5927\u4e8e\u7ed3\u675f\u65e5\u671f\uff0c\u4e0d\u5141\u8bb8\u8054\u673a\u67e5\u8be2\u7535\u5b50\u56de\u5355\u3002", (String)"AccountBankHelper_1", (String)"tmc-bei-business", (Object[])new Object[0]), accountBank.getString("bankaccountnumber"), DateUtils.formatString((Date)result.getPredictDate(), (String)"yyyy-MM-dd")));
            operateErrorInfo.setPkValue(accountBank.getPkValue());
            return operateErrorInfo;
        }
        if (result.isChange()) {
            return AccountBankHelper.doDownReceipt(accountBank, currency, result.getPredictDate(), endDate);
        }
        return AccountBankHelper.doDownReceipt(accountBank, currency, startDate, endDate);
    }

    private static OperateErrorInfo doDownReceipt(DynamicObject accountBank, DynamicObject currency, Date startDate, Date endDate) {
        ReceiptQueryParam receiptQueryParam = new ReceiptQueryParam(accountBank, currency, startDate, endDate);
        ElecReceiptResult elecReceiptResult = new EBReceiptQueryService(receiptQueryParam).downReceipt();
        if (elecReceiptResult != null && EmptyUtil.isNotBlank((CharSequence)elecReceiptResult.getErrMsg())) {
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setLevel(ErrorLevel.Error);
            operateErrorInfo.setMessage(elecReceiptResult.getErrMsg());
            operateErrorInfo.setPkValue((Object)accountBank.getLong("id"));
            return operateErrorInfo;
        }
        return null;
    }

    public static QFilter getAccountBankFilterByOrg(List<Long> orgIDs) {
        return BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", orgIDs, (boolean)true);
    }

    public static QFilter getAccountBankFilterByOrg(Long orgID) {
        return BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", (Long)orgID);
    }

    public static Map<Long, Map<Long, Boolean>> batchCanUseAccountMap(Map<Long, Set<Long>> checkMap) {
        HashMap<Long, Map<Long, Boolean>> resultMap = new HashMap<Long, Map<Long, Boolean>>(16);
        for (Map.Entry<Long, Set<Long>> entry : checkMap.entrySet()) {
            Long orgId = entry.getKey();
            Set<Long> acctBankIdSet = entry.getValue();
            QFilter qFilter = new QFilter("id", "in", acctBankIdSet);
            qFilter.and(AccountBankHelper.getAccountBankFilterByOrg(orgId));
            Map accountBanks = BusinessDataServiceHelper.loadFromCache((String)"bd_accountbanks", (String)"id,acctstatus", (QFilter[])new QFilter[]{qFilter});
            Map<Long, Boolean> checkResultMap = acctBankIdSet.stream().collect(Collectors.toMap(id -> id, id -> Boolean.FALSE, (a, b) -> a));
            if (EmptyUtil.isNoEmpty((Object)accountBanks)) {
                for (DynamicObject account : accountBanks.values()) {
                    String status = account.getString("acctstatus");
                    if (!checkResultMap.containsKey(account.getLong("id")) || !Arrays.asList("normal", "closing", "freeze", "changing").contains(status)) continue;
                    checkResultMap.put(account.getLong("id"), true);
                }
            }
            resultMap.put(orgId, checkResultMap);
        }
        return resultMap;
    }

    public static boolean isChina(String countryName, String countryNumber, String countryCode) {
        return "001".equals(countryNumber) || "CHN".equals(countryNumber) || ResManager.loadKDString((String)"\u4e2d\u56fd", (String)"AccountBankHelper_2", (String)"tmc-bei-business", (Object[])new Object[0]).equals(countryName) || "003".equals(countryNumber) || "HKG".equals(countryCode) || "004".equals(countryNumber) || "MAC".equals(countryCode) || "005".equals(countryNumber) || "TWN".equals(countryCode);
    }

    public static void filterContainerInitForAccountManagerTransfer(ListShowParameter listShowParameter, List<FilterColumn> commonFilterColumns, IPageCache pageCache) {
        Map customParams = listShowParameter.getCustomParams();
        String billFormId = listShowParameter.getBillFormId();
        if (pageCache.get("fromAccountTrade") == null && customParams != null && customParams.containsKey("fromAccountTrade")) {
            pageCache.put("fromAccountTrade", "1");
            String orgId = customParams.getOrDefault("company", "0");
            for (CommonFilterColumn commonFilterColumn : commonFilterColumns) {
                String fieldName;
                switch (fieldName = commonFilterColumn.getFieldName()) {
                    case "company.name": {
                        if (!customParams.containsKey("company")) break;
                        if (StringUtils.equals((CharSequence)billFormId, (CharSequence)"bei_bankbalance") || customParams.containsKey("fromAccountAssignCancel")) {
                            commonFilterColumn.setDefaultValues(new Object[]{""});
                            break;
                        }
                        commonFilterColumn.setDefaultValues(new Object[]{customParams.get("company").toString()});
                        break;
                    }
                    case "accountbank.bankaccountnumber": {
                        List<ComboItem> accountBank;
                        if (!customParams.containsKey("accountbank")) break;
                        if (StringUtils.equals((CharSequence)billFormId, (CharSequence)"bei_bankbalance")) {
                            accountBank = AccountBankHelper.initAcctItemsList(0L);
                            commonFilterColumn.setComboItems(accountBank);
                            commonFilterColumn.setDefaultValue(customParams.get("accountbank").toString());
                            break;
                        }
                        accountBank = AccountBankHelper.initAcctItemsList(Long.parseLong(orgId.toString()));
                        commonFilterColumn.setComboItems(accountBank);
                        commonFilterColumn.setDefaultValue(customParams.get("accountbank").toString());
                        break;
                    }
                    case "bizdate": {
                        if (!customParams.containsKey("bizDateRange")) break;
                        if (StringUtils.equals((CharSequence)billFormId, (CharSequence)"bei_bankbalance")) {
                            commonFilterColumn.setDefaultValue("");
                            break;
                        }
                        commonFilterColumn.setDefaultValues((List)customParams.get("bizDateRange"));
                    }
                }
            }
            customParams.remove("fromAccountTrade");
        }
    }

    public static List<ComboItem> initAcctItemsList(long orgId) {
        String selectProperties = "id,name,bankaccountnumber";
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        if (orgId != 0L) {
            qFilters.add(new QFilter("company.id", "=", (Object)orgId));
        }
        DynamicObjectCollection accountList = QueryServiceHelper.query((String)"bd_accountbanks", (String)selectProperties, (QFilter[])qFilters.toArray(new QFilter[0]));
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>(10);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)accountList)) {
            for (DynamicObject cashAcct : accountList) {
                if (cashAcct == null) continue;
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(cashAcct.getString("bankaccountnumber")));
                item.setValue(cashAcct.getString("id"));
                if (acctItems.contains(item)) continue;
                acctItems.add(item);
            }
        }
        return acctItems;
    }

    public static Map<Long, Date> getAcctBankWithPredictDate(Collection<DynamicObject> accountBanks, String bankFunction) {
        List companyIds = accountBanks.stream().map(o -> o.getDynamicObject("company").getLong("id")).distinct().collect(Collectors.toList());
        Map org_params = TmcParameterHelper.getBatchParam((String)"bei", companyIds);
        HashSet<Long> companyWithBei008 = new HashSet<Long>(companyIds.size());
        for (Map.Entry params : org_params.entrySet()) {
            Object value = ((Map)params.getValue()).get("bei008");
            if (value == null || !((Boolean)value).booleanValue()) continue;
            companyWithBei008.add(Long.parseLong((String)params.getKey()));
        }
        List filterBanks = accountBanks.stream().filter(t -> EmptyUtil.isNoEmpty((DynamicObject)t.getDynamicObject("company"))).filter(t -> companyWithBei008.contains(t.getDynamicObject("company").getLong("id"))).collect(Collectors.toList());
        Set accountIds = filterBanks.stream().map(t -> t.getLong("id")).collect(Collectors.toSet());
        String props = "id,issetbankinterface,entry,entry.e_predictopendate";
        QFilter filter_p = new QFilter("id", "in", accountIds).and("issetbankinterface", "=", (Object)"1").and("entry.e_enable", "=", (Object)"1").and("entry.e_bankfunction", "=", (Object)bankFunction);
        HashMap<Long, Date> acctBank_predictDate = new HashMap<Long, Date>(accountIds.size());
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"am_accountbank", (String)props, (QFilter[])filter_p.toArray());
        for (DynamicObject accountObj : objects) {
            Date predictDate = accountObj.getDate("entry.e_predictopendate");
            if (null == predictDate) continue;
            predictDate = DateUtils.getDataFormat((Date)predictDate, (boolean)true);
            acctBank_predictDate.put(accountObj.getLong("id"), predictDate);
        }
        return acctBank_predictDate;
    }
}

