/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.helper;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.bei.business.bean.AccountPredictDateResult;
import kd.tmc.bei.business.ebservice.EBBalanceQueryService;
import kd.tmc.bei.business.ebservice.EBDetailQueryService;
import kd.tmc.bei.business.ebservice.EBReceiptQueryService;
import kd.tmc.bei.business.helper.AccountBankHelper;
import kd.tmc.bei.business.helper.ElecMatchCheckHelper;
import kd.tmc.bei.business.opservice.helper.ErrorInfoHelper;
import kd.tmc.bei.business.opservice.param.BalanceQueryParam;
import kd.tmc.bei.business.opservice.param.DetailQueryParam;
import kd.tmc.bei.business.opservice.param.ReceiptQueryParam;
import kd.tmc.bei.business.opservice.result.BalanceResult;
import kd.tmc.bei.business.opservice.result.ElecReceiptResult;
import kd.tmc.bei.business.opservice.result.TransDetailResult;
import kd.tmc.bei.common.enums.DetailCorrectTypeEnum;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BankFuncEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;

public class BalanceCheckErrorHelper {
    private static final Log logger = LogFactory.getLog(BalanceCheckErrorHelper.class);
    private static final int ACCOUNT_BATCH = 200;

    public static Map<Long, String> processBankCheck(List<Long> idList, Date bizDate, String bankNumber) {
        return BalanceCheckErrorHelper.processBankCheck(idList, bizDate, bankNumber, null);
    }

    public static Map<Long, String> processBankCheck(List<Long> idList, Date bizDate, String bankNumber, Long filterCurrency) {
        logger.info("processBankCheck id size {}, bizdate {}, bankNumber {}, filterCurrency {}", new Object[]{idList.size(), DateUtils.formatString((Date)bizDate, (String)"yyyy-MM-dd"), bankNumber, filterCurrency});
        HashMap<Long, String> errorMsgMap = new HashMap<Long, String>(16);
        List accountPart = Lists.partition(idList, (int)200);
        for (List part : accountPart) {
            Map<Long, String> tempMap = BalanceCheckErrorHelper.doBankCheck(part, bizDate, bankNumber, filterCurrency);
            if (!EmptyUtil.isNoEmpty(tempMap)) continue;
            errorMsgMap.putAll(tempMap);
        }
        return errorMsgMap;
    }

    private static Map<Long, String> doBankCheck(List<Long> idList, Date bizDate, String bankNumber, Long filterCurrency) {
        QFilter accountFilter = new QFilter("id", "in", idList);
        Date enddate = DateUtils.getDataFormat((Date)bizDate, (boolean)false);
        QFilter filter = new QFilter("bizdate", ">=", (Object)bizDate).and("bizdate", "<=", (Object)enddate);
        if (StringUtils.isNotEmpty((CharSequence)bankNumber)) {
            String[] number = bankNumber.split(",");
            filter = filter.and("accountbank.bankaccountnumber", "in", (Object)number);
        }
        Map acctMap = TmcDataServiceHelper.loadFromCache((String)"am_accountbank", (String)"id,name,company,bankaccountnumber,currency", (QFilter[])new QFilter("id", "in", idList).toArray());
        Map<Long, Date> acctBank_predictDate = AccountBankHelper.getAcctBankWithPredictDate(acctMap.values(), BankFuncEnum.QUERY.getValue());
        HashMap<Long, String> errorMsgMap = new HashMap<Long, String>(16);
        List<Map<String, Object>> allRecords = BalanceCheckErrorHelper.getAllBalanceRecord(bizDate, accountFilter, filter, acctMap, acctBank_predictDate);
        if (EmptyUtil.isNoEmpty((Long)filterCurrency)) {
            allRecords = allRecords.stream().filter(t -> Objects.equals(filterCurrency, t.get("currency"))).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(allRecords)) {
            return errorMsgMap;
        }
        Map<Object, List<Map>> recordMaps = allRecords.stream().filter(t -> Objects.nonNull(t.get("accountbank"))).collect(Collectors.groupingBy(t -> t.get("accountbank")));
        Map<Object, List<DynamicObject>> missDbMap = BalanceCheckErrorHelper.getAllMissingRecord(idList, bizDate);
        for (Long acctId : idList) {
            String errorMsg = BalanceCheckErrorHelper.mergeMissingRecord(acctId, bizDate, recordMaps.get(acctId), missDbMap.get(acctId));
            if (!StringUtils.isNotBlank((CharSequence)errorMsg)) continue;
            errorMsgMap.put(acctId, errorMsg);
        }
        return errorMsgMap;
    }

    public static void processDataEntityByType(DynamicObject[] dataEntities) {
        List<DynamicObject> elecList;
        Map<String, List<DynamicObject>> checkTypeMap = Arrays.stream(dataEntities).filter(t -> Objects.nonNull(t.getDynamicObject("currency"))).collect(Collectors.groupingBy(t -> t.getString("checktype")));
        List<DynamicObject> balanceList = checkTypeMap.get("B");
        if (!CollectionUtils.isEmpty(balanceList)) {
            logger.info("process balance check size {}", (Object)balanceList.size());
            BalanceCheckErrorHelper.processDataEntity(balanceList.toArray(new DynamicObject[0]));
        }
        if (!CollectionUtils.isEmpty(elecList = checkTypeMap.get("E"))) {
            logger.info("process electric receipt check size {}", (Object)elecList.size());
            ElecMatchCheckHelper.processDataEntity(elecList.toArray(new DynamicObject[0]));
        }
    }

    private static void processDataEntity(DynamicObject[] dataEntities) {
        Map dateEntityMap = Arrays.stream(dataEntities).collect(Collectors.groupingBy(d -> d.getDate("bizdate"), Collectors.toList()));
        HashMap<Long, String> resMap = new HashMap<Long, String>(16);
        for (Map.Entry one : dateEntityMap.entrySet()) {
            Date bizDate = one.getKey();
            Map<Long, List<DynamicObject>> currMap = one.getValue().stream().collect(Collectors.groupingBy(t -> t.getDynamicObject("currency").getLong("id")));
            for (List<DynamicObject> dataList : currMap.values()) {
                Long currency = dataList.get(0).getDynamicObject("currency").getLong("id");
                List<Long> idList = dataList.stream().map(d -> d.getDynamicObject("accountbank").getLong("id")).distinct().collect(Collectors.toList());
                logger.info("processDataEntity id size {}", (Object)idList.size());
                Map<Long, String> map = BalanceCheckErrorHelper.processBankCheck(idList, bizDate, null, currency);
                for (Map.Entry<Long, String> cur : map.entrySet()) {
                    Long acct = cur.getKey();
                    String res = (String)resMap.get(acct);
                    res = StringUtils.isBlank((CharSequence)res) ? cur.getValue() : res + ";" + cur.getValue();
                    resMap.put(acct, res);
                }
            }
        }
    }

    private static Map<Object, List<DynamicObject>> getAllMissingRecord(List<Long> idList, Date bizDate) {
        QFilter filter = new QFilter("accountbank", "in", idList).and("bizdate", "=", (Object)bizDate).and("checktype", "=", (Object)"B");
        String selectProp = "billno,company,accountbank,currency,bizdate,checktype,checkresult,checkresultdesc,trynum,count,lstbalance,debittotal,credittotal,amount,balance,detailtime,lstbalancetime,balancetime,lstdatasource,datasource,correcttype,modifytime,entryentity,lcount,llstbalance,ldebittotal,lcredittotal,lamount,lbalance,lcheckresult,lcheckresultdesc,exectime";
        DynamicObject[] objects = TmcDataServiceHelper.load((String)"bei_missingreord", (String)selectProp, (QFilter[])filter.toArray());
        return Arrays.stream(objects).collect(Collectors.groupingBy(t -> t.getLong("accountbank.id")));
    }

    private static String mergeMissingRecord(Long acctId, Date bizDate, List<Map<String, Object>> recordList, List<DynamicObject> objectList) {
        if (CollectionUtils.isEmpty(recordList)) {
            logger.info("acctId [{}] bizDate [{}] not exist record", (Object)acctId, (Object)DateUtils.formatString((Date)bizDate, (String)"yyyy-MM-dd"));
            return "";
        }
        Map objectMap = Optional.ofNullable(objectList).orElseGet(ArrayList::new).stream().collect(Collectors.toMap(t -> Objects.nonNull(t.getDynamicObject("currency")) ? t.getDynamicObject("currency").getPkValue() : Long.valueOf(0L), Function.identity(), (p, q) -> p));
        ArrayList<DynamicObject> addObjects = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> updateObjects = new ArrayList<DynamicObject>(10);
        HashSet<Long> curSet = new HashSet<Long>(16);
        for (Map<String, Object> rcMap : recordList) {
            Long curId;
            if (Objects.isNull(rcMap.get("bizdate"))) {
                rcMap.put("bizdate", bizDate);
            }
            if (Objects.isNull(curId = (Long)rcMap.get("currency"))) {
                logger.info("acctId [{}] bizDate [{}] not exist currency", (Object)acctId, (Object)DateUtils.formatString((Date)bizDate, (String)"yyyy-MM-dd"));
                curId = 0L;
            }
            if (curSet.contains(curId)) continue;
            curSet.add(curId);
            String result = rcMap.get("checkresult").toString();
            DynamicObject object = (DynamicObject)objectMap.get(curId);
            if (Objects.nonNull(object)) {
                BalanceCheckErrorHelper.mapToObject(rcMap, object);
                object.set("modifytime", rcMap.get("modifytime"));
                BalanceCheckErrorHelper.addNewLog(object, rcMap);
                updateObjects.add(object);
                continue;
            }
            if (!DetailCorrectTypeEnum.LOST_LST_BALANCE.getResult().equals(result)) continue;
            DynamicObject obj = TmcDataServiceHelper.newDynamicObject((String)"bei_missingreord");
            BalanceCheckErrorHelper.mapToObject(rcMap, obj);
            obj.set("checktype", (Object)"B");
            obj.set("trynum", (Object)0);
            BalanceCheckErrorHelper.addNewLog(obj, rcMap);
            addObjects.add(obj);
        }
        if (CollectionUtils.isNotEmpty(addObjects)) {
            SaveServiceHelper.saveOperate((String)"bei_missingreord", (DynamicObject[])addObjects.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        }
        if (CollectionUtils.isNotEmpty(updateObjects)) {
            logger.info("update object {}", (Object)updateObjects.size());
            SaveServiceHelper.save((DynamicObject[])updateObjects.toArray(new DynamicObject[0]));
        }
        return "";
    }

    private static void addNewLog(DynamicObject obj, Map<String, Object> map) {
        DynamicObjectCollection logList = obj.getDynamicObjectCollection("entryentity");
        DynamicObject row = logList.addNew();
        row.set("lcount", map.get("count"));
        row.set("llstbalance", map.get("lstbalance"));
        row.set("ldebittotal", map.get("debittotal"));
        row.set("lcredittotal", map.get("credittotal"));
        row.set("lamount", map.get("amount"));
        row.set("lbalance", map.get("balance"));
        row.set("lcheckresult", map.get("checkresult"));
        row.set("lcheckresultdesc", map.get("checkresultdesc"));
        row.set("exectime", map.get("modifytime"));
    }

    private static void mapToObject(Map<String, Object> map, DynamicObject obj) {
        BalanceCheckErrorHelper.setProperties(obj, map, "company", "accountbank", "currency", "bizdate", "checkresult", "checkresultdesc", "count", "lstbalance", "amount", "credittotal", "debittotal", "balance", "detailtime", "balancetime", "lstbalancetime", "lstdatasource", "datasource", "correcttype");
    }

    private static void setProperties(DynamicObject obj, Map<String, Object> map, String ... keys) {
        for (String key : keys) {
            obj.set(key, map.get(key));
        }
    }

    /*
     * Exception decompiling
     */
    public static List<Map<String, Object>> getAllBalanceRecord(Date bizDate, QFilter accountFilter, QFilter filter, Map<Object, DynamicObject> acctMap, Map<Long, Date> acctBank_predictDate) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 14 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Row chooseRow(Row left, Row right) {
        if (null != right.getBigDecimal("debitamount") || null != right.getBigDecimal("creditamount")) {
            return right;
        }
        if (null != left.getBigDecimal("lstbalance") || null != left.getBigDecimal("amount")) {
            return left;
        }
        return right;
    }

    private static List<Map<String, Object>> extendCurrency(List<Map<String, Object>> missRecords, Map<Object, DynamicObject> acctMap) {
        if (CollectionUtils.isEmpty(missRecords)) {
            return missRecords;
        }
        Map<Long, List<Map>> acctDataMap = missRecords.stream().collect(Collectors.groupingBy(t -> Long.valueOf(t.get("accountbank").toString())));
        ArrayList<Map<String, Object>> resRecords = new ArrayList<Map<String, Object>>(missRecords.size());
        for (Map.Entry<Object, DynamicObject> one : acctMap.entrySet()) {
            Object acctId = one.getKey();
            DynamicObject acct = one.getValue();
            Set currencyList = acct.getDynamicObjectCollection("currency").stream().map(t -> t.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(t -> t.getLong("id")).collect(Collectors.toSet());
            List<Map<String, Object>> records = acctDataMap.get(acctId);
            if (CollectionUtils.isEmpty(records)) continue;
            Map curMap = records.stream().collect(Collectors.toMap(t -> Objects.nonNull(t.get("currency")) ? Long.parseLong(t.get("currency").toString()) : 0L, Function.identity(), (p, q) -> p));
            for (Long curId : currencyList) {
                Map<String, Object> dataMap = (Map<String, Object>)curMap.get(curId);
                if (Objects.isNull(dataMap)) {
                    dataMap = BalanceCheckErrorHelper.createMissingRecord(records);
                    dataMap.put("currency", curId);
                }
                resRecords.add(dataMap);
            }
        }
        return resRecords;
    }

    private static Map<String, Object> createMissingRecord(List<Map<String, Object>> records) {
        Optional<Map> find = records.stream().filter(t -> EmptyUtil.isEmpty(t.get("currency"))).findFirst();
        if (find.isPresent()) {
            return new HashMap<String, Object>(find.get());
        }
        Map<String, Object> tempMap = records.get(0);
        List<String> tipList = Arrays.asList(DetailCorrectTypeEnum.LOST_LST_BALANCE.getValue(), DetailCorrectTypeEnum.LOST_CUR_BALANCE.getValue(), DetailCorrectTypeEnum.LOST_TRADE_DETAIL.getValue());
        String resultInf = tipList.stream().map(t -> DetailCorrectTypeEnum.getName((String)t)).collect(Collectors.joining(";"));
        String correctTypes = tipList.stream().collect(Collectors.joining(","));
        HashMap<String, Object> checkMap = new HashMap<String, Object>(16);
        checkMap.put("company", tempMap.get("company"));
        checkMap.put("bank", tempMap.get("bank"));
        checkMap.put("accountbank", tempMap.get("accountbank"));
        checkMap.put("currency", null);
        checkMap.put("bizdate", tempMap.get("bizdate"));
        checkMap.put("count", 0);
        checkMap.put("lstbalance", null);
        checkMap.put("amount", null);
        checkMap.put("debittotal", null);
        checkMap.put("credittotal", null);
        checkMap.put("balance", null);
        checkMap.put("detailtime", null);
        checkMap.put("lstbalancetime", null);
        checkMap.put("balancetime", null);
        checkMap.put("lstdatasource", null);
        checkMap.put("datasource", null);
        checkMap.put("checkresult", DetailCorrectTypeEnum.LOST_LST_BALANCE.getResult());
        checkMap.put("checkresultdesc", resultInf);
        checkMap.put("correcttype", correctTypes);
        checkMap.put("modifytime", new Date());
        return checkMap;
    }

    private static String getRowBalanceKey(Row row) {
        String dateStr = Objects.nonNull(row.getDate("balancebizdate")) ? DateUtils.formatString((Date)row.getDate("balancebizdate"), (String)"yyyy-MM-dd") : "";
        return row.get("balanceaccountbank") + ":" + row.get("balancecurrency") + ":" + dateStr;
    }

    private static String getRowDetailKey(Row row) {
        String dateStr = Objects.nonNull(row.getDate("detailbizdate")) ? DateUtils.formatString((Date)row.getDate("detailbizdate"), (String)"yyyy-MM-dd") : "";
        return row.get("detailaccountbank") + ":" + row.get("detailcurrency") + ":" + dateStr;
    }

    private static Map<String, Object> dataToMap(Row row) {
        Date balanceupdatetime = row.getDate("balanceupdatetime");
        Date detailupdatetime = row.getDate("detailupdatetime");
        Date balancebizdate = row.getDate("balancebizdate");
        Date detailbizdate = row.getDate("detailbizdate");
        BigDecimal lstbalance = row.getBigDecimal("lstbalance");
        BigDecimal amount = row.getBigDecimal("amount");
        BigDecimal debittotal = row.getBigDecimal("debitamount");
        BigDecimal credittotal = row.getBigDecimal("creditamount");
        AtomicInteger lstBalanceSource = EmptyUtil.isNoEmpty((BigDecimal)lstbalance) ? new AtomicInteger(1) : new AtomicInteger(5);
        Date lstbalanceupdatetime = balanceupdatetime;
        Date bizDate = (Date)BalanceCheckErrorHelper.getRowValue(row, "balancebizdate", "detailbizdate");
        Long bankAcct = (Long)BalanceCheckErrorHelper.getRowValue(row, "balanceaccountbank", "detailaccountbank");
        Long currency = (Long)BalanceCheckErrorHelper.getRowValue(row, "balancecurrency", "detailcurrency");
        if (EmptyUtil.isEmpty((BigDecimal)lstbalance) && EmptyUtil.isNoEmpty((Object)bizDate)) {
            Object[] params = new Object[]{lstBalanceSource, lstbalanceupdatetime};
            lstbalance = BalanceCheckErrorHelper.getLastBankDetail(bankAcct, currency, bizDate, params);
            lstbalanceupdatetime = (Date)params[1];
        }
        BigDecimal balance = BalanceCheckErrorHelper.getBalance(lstbalance, amount, debittotal, credittotal);
        Integer count = row.getInteger("count") == null ? Integer.valueOf(0) : row.getInteger("count");
        boolean condA = BalanceCheckErrorHelper.conditionA(lstbalance, amount, debittotal, credittotal);
        int lstBalanceType = BalanceCheckErrorHelper.conditionB(lstBalanceSource.get());
        boolean condC = condA ? BalanceCheckErrorHelper.conditionC(balancebizdate, balanceupdatetime) : BalanceCheckErrorHelper.isAmountExist(amount, balancebizdate);
        boolean condD = condA ? BalanceCheckErrorHelper.conditionD(detailbizdate, detailupdatetime) : BalanceCheckErrorHelper.isTransDetailExist(count);
        ArrayList<String> tipList = new ArrayList<String>(16);
        DetailCorrectTypeEnum resultType = BalanceCheckErrorHelper.getDetailCorrectTypeEnum(tipList, condA, lstBalanceType, condC, condD);
        String result = resultType.getResult();
        String resultInf = tipList.stream().map(t -> DetailCorrectTypeEnum.getName((String)t)).collect(Collectors.joining(";"));
        String correctTypes = tipList.stream().collect(Collectors.joining(","));
        Long company = (Long)BalanceCheckErrorHelper.getRowValue(row, "balancecompany", "detailcompany");
        Long bank = (Long)BalanceCheckErrorHelper.getRowValue(row, "balancebank", "detailbank");
        HashMap<String, Object> checkMap = new HashMap<String, Object>(16);
        checkMap.put("company", company);
        checkMap.put("bank", bank);
        checkMap.put("accountbank", bankAcct);
        checkMap.put("currency", currency);
        checkMap.put("bizdate", bizDate);
        checkMap.put("count", count);
        checkMap.put("lstbalance", lstbalance);
        checkMap.put("amount", amount);
        checkMap.put("debittotal", debittotal);
        checkMap.put("credittotal", credittotal);
        checkMap.put("balance", balance);
        checkMap.put("detailtime", detailupdatetime);
        checkMap.put("lstbalancetime", lstbalanceupdatetime);
        checkMap.put("balancetime", balanceupdatetime);
        checkMap.put("lstdatasource", BalanceCheckErrorHelper.getLstBalanceSource(lstBalanceSource.get()));
        checkMap.put("datasource", row.getString("datasource"));
        checkMap.put("checkresult", result);
        checkMap.put("checkresultdesc", resultInf);
        checkMap.put("correcttype", correctTypes);
        checkMap.put("modifytime", new Date());
        return checkMap;
    }

    private static DetailCorrectTypeEnum getDetailCorrectTypeEnum(List<String> tipList, boolean condA, int lstBalanceType, boolean condC, boolean condD) {
        DetailCorrectTypeEnum resultType;
        if (condA) {
            if (2 == lstBalanceType) {
                resultType = DetailCorrectTypeEnum.INTACT_NOT_TRADE;
                tipList.add(DetailCorrectTypeEnum.INTACT_NOT_TRADE.getValue());
                BalanceCheckErrorHelper.checkAddTip(tipList, condC, DetailCorrectTypeEnum.INTACT_NOT_ENDTIME.getValue());
                BalanceCheckErrorHelper.checkAddTip(tipList, condD, DetailCorrectTypeEnum.INTACT_NOT_HISTORICALDATA.getValue());
            } else if (!condC) {
                resultType = DetailCorrectTypeEnum.INTACT_NOT_ENDTIME;
                tipList.add(DetailCorrectTypeEnum.INTACT_NOT_ENDTIME.getValue());
                BalanceCheckErrorHelper.checkAddTip(tipList, condD, DetailCorrectTypeEnum.INTACT_NOT_HISTORICALDATA.getValue());
            } else if (!condD) {
                resultType = DetailCorrectTypeEnum.INTACT_NOT_HISTORICALDATA;
                tipList.add(DetailCorrectTypeEnum.INTACT_NOT_HISTORICALDATA.getValue());
            } else {
                resultType = DetailCorrectTypeEnum.INTACT;
                tipList.add(DetailCorrectTypeEnum.INTACT.getValue());
            }
        } else if (3 == lstBalanceType) {
            resultType = DetailCorrectTypeEnum.LOST_LST_BALANCE;
            tipList.add(DetailCorrectTypeEnum.LOST_LST_BALANCE.getValue());
            BalanceCheckErrorHelper.checkAddTip(tipList, condC, DetailCorrectTypeEnum.LOST_CUR_BALANCE.getValue());
            BalanceCheckErrorHelper.checkAddTip(tipList, condD, DetailCorrectTypeEnum.LOST_TRADE_DETAIL.getValue());
        } else if (!condC) {
            resultType = DetailCorrectTypeEnum.LOST_CUR_BALANCE;
            tipList.add(DetailCorrectTypeEnum.LOST_CUR_BALANCE.getValue());
            BalanceCheckErrorHelper.checkAddTip(tipList, condD, DetailCorrectTypeEnum.LOST_TRADE_DETAIL.getValue());
        } else if (!condD) {
            resultType = DetailCorrectTypeEnum.LOST_TRADE_DETAIL;
            tipList.add(DetailCorrectTypeEnum.LOST_TRADE_DETAIL.getValue());
        } else {
            resultType = DetailCorrectTypeEnum.LOST_NOT_ENDTIME;
            tipList.add(DetailCorrectTypeEnum.LOST_NOT_ENDTIME.getValue());
        }
        return resultType;
    }

    public static BigDecimal getLastBankDetail(Long bankAcct, Long currency, Date bizdate, Object[] params) {
        AtomicInteger lstBalanceSource = (AtomicInteger)params[0];
        Date lstbalanceupdatetime = (Date)params[1];
        List<QFilter> lastfilters = BalanceCheckErrorHelper.getLstQfilter(bankAcct, currency, bizdate, true);
        BigDecimal balance = null;
        try (DataSet balanceds = QueryServiceHelper.queryDataSet((String)"getLastBankDetail", (String)"bei_bankbalance", (String)"amount,modifytime", (QFilter[])lastfilters.toArray(new QFilter[0]), null);){
            if (balanceds.hasNext()) {
                Row next = balanceds.next();
                balance = next.getBigDecimal("amount");
                lstBalanceSource.set(2);
                lstbalanceupdatetime = next.getDate("modifytime");
            }
        }
        QFilter detailErrorFilter = new QFilter("errortype", "not in", Arrays.asList("U", "D"));
        if (EmptyUtil.isEmpty((BigDecimal)balance)) {
            ArrayList<QFilter> detailFilter = new ArrayList<QFilter>(lastfilters);
            detailFilter.add(detailErrorFilter);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getLastBankDetail", (String)"bei_transdetail", (String)"transbalance,modifytime", (QFilter[])detailFilter.toArray(new QFilter[0]), (String)"biztime desc,sortno desc", (int)1);){
                if (ds.hasNext()) {
                    Row next = ds.next();
                    balance = next.getBigDecimal("transbalance");
                    lstBalanceSource.set(3);
                    lstbalanceupdatetime = next.getDate("modifytime");
                }
            }
        }
        if (EmptyUtil.isEmpty((BigDecimal)balance)) {
            List<QFilter> todayfilters = BalanceCheckErrorHelper.getLstQfilter(bankAcct, currency, bizdate, false);
            todayfilters.add(detailErrorFilter);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getCBankDetail", (String)"bei_transdetail", (String)"transbalance,modifytime,debitamount,creditamount", (QFilter[])todayfilters.toArray(new QFilter[0]), (String)"biztime asc,sortno asc", (int)1);){
                if (ds.hasNext()) {
                    Row next = ds.next();
                    BigDecimal intbalance = next.getBigDecimal("transbalance");
                    BigDecimal debitamount = next.getBigDecimal("debitamount");
                    BigDecimal creditamount = next.getBigDecimal("creditamount");
                    if (Objects.nonNull(intbalance)) {
                        debitamount = Objects.nonNull(debitamount) ? debitamount : Constants.ZERO;
                        creditamount = Objects.nonNull(creditamount) ? creditamount : Constants.ZERO;
                        balance = intbalance.add(debitamount).subtract(creditamount);
                        lstBalanceSource.set(4);
                        lstbalanceupdatetime = next.getDate("modifytime");
                    }
                }
            }
        }
        if (EmptyUtil.isEmpty((BigDecimal)balance)) {
            lstBalanceSource.set(5);
            params[1] = null;
        } else {
            params[1] = lstbalanceupdatetime;
        }
        return balance;
    }

    private static List<QFilter> getLstQfilter(Long bankAcct, Long currency, Date bizdate, boolean isLastDay) {
        ArrayList<QFilter> newFilter = new ArrayList<QFilter>();
        if (isLastDay) {
            newFilter.add(new QFilter("bizdate", "=", (Object)DateUtils.getNextDay((Date)bizdate, (int)-1)));
        } else {
            newFilter.add(new QFilter("bizdate", "=", (Object)bizdate));
        }
        newFilter.add(new QFilter("accountbank.id", "=", (Object)bankAcct));
        newFilter.add(new QFilter("currency.id", "=", (Object)currency));
        return newFilter;
    }

    private static String getLstBalanceSource(int source) {
        switch (source) {
            case 1: 
            case 2: {
                return "B";
            }
            case 3: 
            case 4: {
                return "D";
            }
        }
        return "";
    }

    private static BigDecimal getBalance(BigDecimal lstbalance, BigDecimal amount, BigDecimal debittotal, BigDecimal credittotal) {
        lstbalance = lstbalance == null ? BigDecimal.ZERO : lstbalance;
        amount = amount == null ? BigDecimal.ZERO : amount;
        debittotal = debittotal == null ? BigDecimal.ZERO : debittotal;
        credittotal = credittotal == null ? BigDecimal.ZERO : credittotal;
        return lstbalance.add(credittotal).subtract(debittotal).subtract(amount);
    }

    private static boolean conditionA(BigDecimal lstbalance, BigDecimal amount, BigDecimal debittotal, BigDecimal credittotal) {
        if (Objects.isNull(lstbalance)) {
            return false;
        }
        amount = amount == null ? BigDecimal.ZERO : amount;
        debittotal = debittotal == null ? BigDecimal.ZERO : debittotal;
        credittotal = credittotal == null ? BigDecimal.ZERO : credittotal;
        BigDecimal balance = lstbalance.add(credittotal).subtract(debittotal).subtract(amount);
        return balance.compareTo(BigDecimal.ZERO) == 0;
    }

    private static int conditionB(int lstBalanceType) {
        if (1 == lstBalanceType || 2 == lstBalanceType) {
            return 1;
        }
        if (3 == lstBalanceType || 4 == lstBalanceType) {
            return 2;
        }
        return 3;
    }

    private static boolean conditionC(Date balanceDate, Date lastModifyDate) {
        return Objects.nonNull(balanceDate) && Objects.nonNull(lastModifyDate) && DateUtils.date2LocalDate((Date)lastModifyDate).isAfter(DateUtils.date2LocalDate((Date)balanceDate));
    }

    private static boolean conditionD(Date tradDate, Date lastModifyDate) {
        return Objects.nonNull(tradDate) && Objects.nonNull(lastModifyDate) && DateUtils.date2LocalDate((Date)lastModifyDate).isAfter(DateUtils.date2LocalDate((Date)tradDate));
    }

    private static boolean isAmountExist(BigDecimal amount, Date balanceDate) {
        return Objects.nonNull(amount) && Objects.nonNull(balanceDate);
    }

    private static boolean isTransDetailExist(int count) {
        return count > 0;
    }

    private static void checkAddTip(List<String> tipList, boolean check, String tip) {
        if (!check) {
            tipList.add(tip);
        }
    }

    private static Object getRowValue(Row row, String checkKey, String optionKey) {
        return row.get(checkKey) == null ? row.get(optionKey) : row.get(checkKey);
    }

    private static List<OperateErrorInfo> repairTodayBalance(DynamicObject currency, List<Long> acctIds, Date bizDate) {
        BalanceQueryParam balanceQueryParam = new BalanceQueryParam(currency, bizDate, bizDate, acctIds);
        List<BalanceResult> balanceResults = new EBBalanceQueryService(balanceQueryParam).queryBatchBalance();
        return ErrorInfoHelper.convertBalanceErrorInfos(balanceResults);
    }

    private static List<OperateErrorInfo> repairYesterdayBalance(DynamicObject currency, List<Long> acctIds, Date bizDate) {
        BalanceQueryParam balanceQueryParam = new BalanceQueryParam(currency, DateUtils.getLastDay((Date)bizDate, (int)1), bizDate, acctIds);
        List<BalanceResult> balanceResults = new EBBalanceQueryService(balanceQueryParam).queryBatchBalance();
        return ErrorInfoHelper.convertBalanceErrorInfos(balanceResults);
    }

    private static List<OperateErrorInfo> downloadDetail(DynamicObject currency, List<Long> acctIds, Date bizDate) {
        List<AccountPredictDateResult> predictResult = AccountBankHelper.computerByIds(BankFuncEnum.QUERY.getValue(), acctIds, bizDate, bizDate);
        List<Long> realAcctIds = predictResult.stream().filter(t -> !t.isPermit()).map(AccountPredictDateResult::getAccountId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(realAcctIds)) {
            return Collections.emptyList();
        }
        DetailQueryParam detailQueryParam = new DetailQueryParam(currency, bizDate, bizDate, realAcctIds, false);
        detailQueryParam.setDownloadFromBank(true);
        List<TransDetailResult> results = new EBDetailQueryService(detailQueryParam).downTransDetails();
        return ErrorInfoHelper.convertErrorInfos(results);
    }

    private static OperateErrorInfo downloadElecReceipt(DynamicObject accountBank, Date bizDate, DynamicObject currency) {
        AccountPredictDateResult predict = AccountBankHelper.computerById(BankFuncEnum.RECEIPT.getValue(), accountBank.getLong("id"), bizDate, bizDate);
        if (predict.isPermit()) {
            return null;
        }
        ReceiptQueryParam receiptQueryParam = new ReceiptQueryParam(accountBank, currency, bizDate, bizDate);
        ElecReceiptResult elecReceiptResult = new EBReceiptQueryService(receiptQueryParam).downReceipt();
        if (elecReceiptResult != null && EmptyUtil.isNotBlank((CharSequence)elecReceiptResult.getErrMsg())) {
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setLevel(ErrorLevel.Error);
            operateErrorInfo.setMessage(elecReceiptResult.getErrMsg());
            operateErrorInfo.setPkValue((Object)accountBank.getLong("id"));
            return operateErrorInfo;
        }
        return null;
    }

    public static List<OperateErrorInfo> repairMissingRecord(DynamicObject[] dataEntities) {
        String curWrap = StringUtils.wrap((String)DetailCorrectTypeEnum.LOST_CUR_BALANCE.getValue(), (String)",");
        String lstWrap = StringUtils.wrap((String)DetailCorrectTypeEnum.LOST_LST_BALANCE.getValue(), (String)",");
        String tradWrap = StringUtils.wrap((String)DetailCorrectTypeEnum.LOST_TRADE_DETAIL.getValue(), (String)",");
        String entWrap = StringUtils.wrap((String)DetailCorrectTypeEnum.LOST_NOT_ENDTIME.getValue(), (String)",");
        String detailWrap = StringUtils.wrap((String)DetailCorrectTypeEnum.DETAIL_LOST.getValue(), (String)",");
        String detailMatchWrap = StringUtils.wrap((String)DetailCorrectTypeEnum.DETAIL_NOT_MATCH.getValue(), (String)",");
        String elecWrap = StringUtils.wrap((String)DetailCorrectTypeEnum.ELEC_LOST.getValue(), (String)",");
        ArrayList<OperateErrorInfo> errorInfoList = new ArrayList<OperateErrorInfo>(dataEntities.length);
        Predicate<DynamicObject> ybPre = data -> StringUtils.contains((CharSequence)StringUtils.wrap((String)data.getString("correcttype"), (String)","), (CharSequence)lstWrap);
        Predicate<DynamicObject> tbPre = data -> StringUtils.contains((CharSequence)StringUtils.wrap((String)data.getString("correcttype"), (String)","), (CharSequence)curWrap);
        Predicate<DynamicObject> dePre = data -> StringUtils.containsAny((CharSequence)StringUtils.wrap((String)data.getString("correcttype"), (String)","), (CharSequence[])new CharSequence[]{tradWrap, entWrap, detailWrap});
        Predicate<DynamicObject> elPre = data -> "E".equals(data.getString("checktype")) && StringUtils.containsAny((CharSequence)StringUtils.wrap((String)data.getString("correcttype"), (String)","), (CharSequence[])new CharSequence[]{detailWrap, detailMatchWrap, elecWrap});
        Function<Triple, List> ybFun = p -> BalanceCheckErrorHelper.repairYesterdayBalance((DynamicObject)p.getLeft(), (List)p.getMiddle(), (Date)p.getRight());
        Function<Triple, List> tbFun = p -> BalanceCheckErrorHelper.repairTodayBalance((DynamicObject)p.getLeft(), (List)p.getMiddle(), (Date)p.getRight());
        Function<Triple, List> deFun = p -> BalanceCheckErrorHelper.downloadDetail((DynamicObject)p.getLeft(), (List)p.getMiddle(), (Date)p.getRight());
        BiConsumer<List, Function> collectFun = (t, fun) -> {
            DynamicObject one = (DynamicObject)t.get(0);
            List acctIds = t.stream().map(p -> p.getDynamicObject("accountbank").getLong("id")).collect(Collectors.toList());
            DynamicObject currency = one.getDynamicObject("currency");
            Date bizDate = one.getDate("bizdate");
            logger.info("repair currency {} bizDate {} acctIds {}", new Object[]{currency.getString("name"), DateUtils.formatString((Date)bizDate, (String)"yyyy-MM-dd"), acctIds.size()});
            Triple param = Triple.of((Object)currency, acctIds, (Object)one.getDate("bizdate"));
            errorInfoList.addAll((Collection)fun.apply(param));
        };
        Function<DynamicObject, String> groupClassFun = t -> DateUtils.formatString((Date)t.getDate("bizdate"), (String)"yyyy-MM-dd") + t.getDynamicObject("currency").getPkValue();
        List<DynamicObject> entityList = Arrays.stream(dataEntities).filter(t -> Objects.nonNull(t.getDate("bizdate")) && Objects.nonNull(t.getDynamicObject("currency"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entityList)) {
            logger.info("not fund entityList");
            return errorInfoList;
        }
        entityList.forEach(t -> t.set("trynum", (Object)(t.getInt("trynum") + 1)));
        dataEntities = entityList.toArray(new DynamicObject[0]);
        logger.info("save dataList size {}", (Object)dataEntities.length);
        TmcDataServiceHelper.save((DynamicObject[])dataEntities);
        entityList.stream().filter(ybPre).collect(Collectors.groupingBy(groupClassFun)).values().forEach(t -> collectFun.accept((List)t, ybFun));
        entityList.stream().filter(tbPre).collect(Collectors.groupingBy(groupClassFun)).values().forEach(t -> collectFun.accept((List)t, tbFun));
        entityList.stream().filter(dePre).collect(Collectors.groupingBy(groupClassFun)).values().forEach(t -> collectFun.accept((List)t, deFun));
        List<DynamicObject> elecList = entityList.stream().filter(elPre).collect(Collectors.toList());
        errorInfoList.addAll(BalanceCheckErrorHelper.processRepairReceipt(elecList));
        logger.info("process dataList size {}", (Object)dataEntities.length);
        BalanceCheckErrorHelper.processDataEntityByType(dataEntities);
        return errorInfoList;
    }

    private static List<OperateErrorInfo> processRepairReceipt(List<DynamicObject> receiptList) {
        if (CollectionUtils.isEmpty(receiptList)) {
            return Collections.emptyList();
        }
        ArrayList<OperateErrorInfo> resList = new ArrayList<OperateErrorInfo>(receiptList.size());
        for (DynamicObject data : receiptList) {
            OperateErrorInfo operateErrorInfo = BalanceCheckErrorHelper.downloadElecReceipt(data.getDynamicObject("accountbank"), data.getDate("bizdate"), data.getDynamicObject("currency"));
            if (!Objects.nonNull(operateErrorInfo)) continue;
            resList.add(operateErrorInfo);
        }
        return resList;
    }

    public static void setLangCheckDesc(DynamicObjectCollection list) {
        for (DynamicObject obj : list) {
            String correctType = obj.getString("correcttype");
            String descLang = Arrays.stream(StringUtils.split((String)correctType, (String)",")).map(DetailCorrectTypeEnum::getName).collect(Collectors.joining(","));
            obj.set("checkresultdesc", (Object)descLang);
        }
    }

    private static /* synthetic */ void lambda$getAllBalanceRecord$16(Date bizDate, Map t) {
        t.put("bizdate", bizDate);
    }

    private static /* synthetic */ boolean lambda$getAllBalanceRecord$15(Set allowAccounts, Map t) {
        return allowAccounts.contains(Long.parseLong(t.get("accountbank").toString()));
    }

    private static /* synthetic */ boolean lambda$getAllBalanceRecord$14(AccountPredictDateResult t) {
        return !t.isPermit();
    }

    private static /* synthetic */ List lambda$getAllBalanceRecord$13(List t) {
        return t.stream().map(w -> (Row)w.item2).collect(Collectors.toList());
    }

    private static /* synthetic */ String lambda$getAllBalanceRecord$11(Tuple t) {
        return (String)t.item1;
    }
}

