/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.helper;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.ExceptionUtils;
import kd.tmc.bei.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.bei.business.opservice.param.BalanceReconciliationParam;
import kd.tmc.bei.business.opservice.param.ElecBalanceAccQueryParam;
import kd.tmc.bei.business.opservice.param.QueryBalanceReconciliationParam;
import kd.tmc.bei.business.opservice.param.UpdateBalanceReconciliationParam;
import kd.tmc.bei.business.opservice.result.ElecBalanceResult;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ElecBalanceStateAccServiceHelper {
    private static final Log logger = LogFactory.getLog(ElecBalanceStateAccServiceHelper.class);

    public static void excuteToAqapService(DynamicObject[] dataEntities, OperationResult operationResult, String opKey) {
        HashMap<String, List<String>> recordMap = new HashMap<String, List<String>>(16);
        HashMap<String, List<DynamicObject>> recordIdMap = new HashMap<String, List<DynamicObject>>(16);
        HashMap<String, DynamicObject> currencyMap = new HashMap<String, DynamicObject>(16);
        Set bankSets = Arrays.stream(dataEntities).map(a -> a.getDynamicObject("accountbank").getDynamicObject("bank").getPkValue()).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", bankSets);
        Map finOrgInfo = TmcDataServiceHelper.loadFromCache((String)"bd_finorginfo", (String)"id,bank_cate", (QFilter[])qFilter.toArray());
        Map<String, List<DynamicObject>> transBalanceMap = Arrays.stream(dataEntities).collect(Collectors.groupingBy(o -> o.getDynamicObject("currency").getLong("id") + "#" + DateUtils.formatString((Date)o.getDate("period"), (String)"yyyyMM")));
        for (List<DynamicObject> value : transBalanceMap.values()) {
            DynamicObject currency = value.get(0).getDynamicObject("currency");
            String currencyNum = currency.getString("number");
            if (!currencyMap.containsKey(currencyNum)) {
                currencyMap.put(currencyNum, currency);
            }
            Date month = value.get(0).getDate("period");
            for (DynamicObject data : value) {
                DynamicObject accountBank = data.getDynamicObject("accountbank");
                Object bankId = accountBank.getDynamicObject("bank").getPkValue();
                DynamicObject bankCgSetting = (DynamicObject)finOrgInfo.get(bankId);
                String bankCateNumber = bankCgSetting.getString("number");
                String recordKey = bankCateNumber + ";" + currencyNum + ";" + DateUtils.formatString((Date)month, (String)"yyyyMM");
                List accountNumbers = recordMap.getOrDefault(recordKey, new ArrayList(10));
                accountNumbers.add(accountBank.getString("bankaccountnumber"));
                recordMap.put(recordKey, accountNumbers);
                List billList = recordIdMap.getOrDefault(recordKey, new ArrayList(10));
                billList.add(data);
                recordIdMap.put(recordKey, billList);
            }
        }
        ElecBalanceStateAccServiceHelper.dealAccRecordMapPart(recordMap, currencyMap, operationResult, opKey, recordIdMap);
    }

    public static void dealAccRecordMapPart(Map<String, List<String>> recordMap, Map<String, DynamicObject> currencyMap, OperationResult operationResult, String opKey, Map<String, List<DynamicObject>> recordIdMap) {
        for (Map.Entry<String, List<String>> record : recordMap.entrySet()) {
            String bankCurrency = record.getKey();
            logger.info("\u94f6\u884c\u7c7b\u522b#\u5e01\u522b:" + bankCurrency);
            String[] split = bankCurrency.split(";");
            String currNumber = split[1];
            String monthStr = split[2];
            List<String> accountNumbers = record.getValue();
            Map request = MutexServiceHelper.batchRequest(accountNumbers, (String)"bd_accountbanks", (String)(opKey + bankCurrency));
            List requestIds = request.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
            logger.info("\u7533\u8bf7\u5230\u4f59\u989d\u5bf9\u8d26\u5206\u5e03\u5f0f\u9501:" + JSON.toJSONString(requestIds));
            List requestFailIds = request.entrySet().stream().filter(s -> (Boolean)s.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList());
            logger.info("\u6ca1\u7533\u8bf7\u5230\u4f59\u989d\u5bf9\u8d26\u5206\u5e03\u5f0f\u9501:" + JSON.toJSONString(requestFailIds));
            try {
                List dealList = request.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
                int partLimit = 1000;
                int limit = (dealList.size() + partLimit - 1) / partLimit;
                ArrayList mglist = new ArrayList();
                Stream.iterate(0, n -> n + 1).limit(limit).forEach(i -> mglist.add(dealList.stream().skip(i * partLimit).limit(partLimit).collect(Collectors.toList())));
                for (List list : mglist) {
                    ElecBalanceResult result = ElecBalanceStateAccServiceHelper.execElecBalanceAccService(opKey, list, currencyMap.get(currNumber), monthStr);
                    if (result == null || !EmptyUtil.isNotBlank((CharSequence)result.getErrMsg())) continue;
                    List allErrorInfo = operationResult.getAllErrorInfo();
                    List<DynamicObject> billList = recordIdMap.get(bankCurrency);
                    for (DynamicObject bill : billList) {
                        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                        operateErrorInfo.setLevel(ErrorLevel.Error);
                        operateErrorInfo.setMessage(bill.get("billno") + ":" + result.getErrMsg());
                        operateErrorInfo.setPkValue(bill.getPkValue());
                        allErrorInfo.add(operateErrorInfo);
                    }
                }
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                operationResult.setMessage(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                operationResult.setSuccess(false);
                throw new KDBizException(e.getMessage());
            }
            finally {
                if (requestIds.size() <= 0) continue;
                MutexServiceHelper.batchRelease(requestIds, (String)"bd_accountbanks", (String)(opKey + bankCurrency));
                logger.info("\u91ca\u653e\u4f59\u989d\u5bf9\u8d26\u5206\u5e03\u5f0f\u9501:" + JSON.toJSONString(requestIds));
            }
        }
    }

    private static ElecBalanceResult execElecBalanceAccService(String opKey, List<String> dealList, DynamicObject currency, String monthStr) {
        ElecBalanceResult result = null;
        if ("op_balancestate_submit_".equals(opKey)) {
            BalanceReconciliationParam commitBeParam = new BalanceReconciliationParam(dealList, currency, DateUtils.stringToDate((String)monthStr, (String)"yyyyMM"), "Y");
            result = EBServiceFacadeFactory.getBankService().commitBeElecBalanceAcc(commitBeParam);
        } else if ("op_balancestate_feedback_".equals(opKey)) {
            UpdateBalanceReconciliationParam feedBackParam = new UpdateBalanceReconciliationParam(dealList, currency, DateUtils.stringToDate((String)monthStr, (String)"yyyyMM"), "OTHER_COMPLETED");
            result = EBServiceFacadeFactory.getBankService().feedBackElecBalanceAcc(feedBackParam);
        } else if ("op_balancestate_sync_".equals(opKey)) {
            QueryBalanceReconciliationParam queryParam = new QueryBalanceReconciliationParam(dealList, currency, DateUtils.stringToDate((String)monthStr, (String)"yyyyMM"));
            result = EBServiceFacadeFactory.getBankService().syncElecBalanceAcc(queryParam);
        }
        return result;
    }

    public static void queryRecordMapPart(Map<String, List<String>> recordMap, Map<String, DynamicObject> currencyMap, OperationResult operationResult, String opKey, Date startMonth, Date endMonth, Set<String> finishKeySet) {
        for (Map.Entry<String, List<String>> record : recordMap.entrySet()) {
            String bankCurrency = record.getKey();
            logger.info("\u94f6\u884c\u7c7b\u522b#\u5e01\u522b:" + bankCurrency);
            String[] split = bankCurrency.split(";");
            String currNumber = split[1];
            List<String> accountNumbers = record.getValue();
            Map request = MutexServiceHelper.batchRequest(accountNumbers, (String)"bd_accountbanks", (String)(opKey + bankCurrency));
            List requestIds = request.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
            logger.info("\u7533\u8bf7\u5230\u4f59\u989d\u5bf9\u8d26\u5206\u5e03\u5f0f\u9501:" + JSON.toJSONString(requestIds));
            List requestFailIds = request.entrySet().stream().filter(s -> (Boolean)s.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList());
            logger.info("\u6ca1\u7533\u8bf7\u5230\u4f59\u989d\u5bf9\u8d26\u5206\u5e03\u5f0f\u9501:" + JSON.toJSONString(requestFailIds));
            try {
                List dealList = request.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
                int partLimit = 1000;
                int limit = (dealList.size() + partLimit - 1) / partLimit;
                ArrayList mglist = new ArrayList();
                Stream.iterate(0, n -> n + 1).limit(limit).forEach(i -> mglist.add(dealList.stream().skip(i * partLimit).limit(partLimit).collect(Collectors.toList())));
                for (List list : mglist) {
                    DynamicObject currency = currencyMap.get(currNumber);
                    ElecBalanceAccQueryParam queryParam = new ElecBalanceAccQueryParam(list, currency, startMonth, endMonth, false, finishKeySet);
                    ElecBalanceResult result = EBServiceFacadeFactory.getBankService().queryElecBalanceAcc(queryParam);
                    if (result == null || !EmptyUtil.isNotBlank((CharSequence)result.getErrMsg())) continue;
                    operationResult.setSuccess(false);
                    operationResult.setMessage(result.getErrMsg());
                }
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                operationResult.setMessage(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                operationResult.setSuccess(false);
                throw new KDBizException(e.getMessage());
            }
            finally {
                if (requestIds.size() <= 0) continue;
                MutexServiceHelper.batchRelease(requestIds, (String)"bd_accountbanks", (String)(opKey + bankCurrency));
                logger.info("\u91ca\u653e\u4f59\u989d\u5bf9\u8d26\u5206\u5e03\u5f0f\u9501:" + JSON.toJSONString(requestIds));
            }
        }
    }
}

