/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.bei.business.helper.AutoMatchHelper;
import kd.tmc.bei.business.helper.MatchAmountDealHelper;
import kd.tmc.bei.common.constants.BillTypeConstants;
import kd.tmc.bei.common.enums.SourceBillTypeEnum;
import kd.tmc.fbp.common.enums.ReceredtypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.MutexServiceHelper;

public class TransDetailUpdataHelper {
    private static final String UPDATAINFODETAIL = "bei_updatainfodetail";
    private static final String PKID = "20221018000000000";
    private static final Log logger = LogFactory.getLog(TransDetailUpdataHelper.class);
    private static final int MAXSIZE = 100;

    public static void transDetailAndBillUpdata() {
        try {
            MutexServiceHelper.request((String)PKID, (String)"bei_transdetail_cas", (String)"TransDetailUpdataTask");
            Boolean isUpdateBusinessBill = !QueryServiceHelper.exists((String)UPDATAINFODETAIL, null);
            if (isUpdateBusinessBill.booleanValue()) {
                TransDetailUpdataHelper.updataPaymentBill();
                TransDetailUpdataHelper.updataReceivingBill();
            }
            int i = 0;
            Long beginId = 0L;
            do {
                ++i;
                logger.info("getUpdataTransDetail------------------------------1");
                ArrayList<Long> idList = new ArrayList<Long>(10);
                ArrayList<DynamicObject> tUpdataTransDetails = new ArrayList<DynamicObject>(10);
                QFilter tQFilter = new QFilter("receredtype", "=", (Object)ReceredtypeEnum.ACCOUNTED.getValue());
                tQFilter.and("isupsucess", "=", (Object)"0");
                String selectfields = AutoMatchHelper.getMatchFieldKeys().stream().reduce((s1, s2) -> String.join((CharSequence)",", s1, s2)).orElse("id");
                QFilter idFilter = new QFilter("id", ">", (Object)beginId);
                DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"bei", (String)"bei_transdetail_cas", (String)"id", (QFilter[])new QFilter[]{idFilter, tQFilter}, (String)"id", (int)999);
                DataSet getTranDetailId = queryDataSet.copy();
                for (Row tranDetailRow : getTranDetailId) {
                    idList.add(tranDetailRow.getLong("id"));
                    beginId = tranDetailRow.getLong("id");
                }
                if (idList.size() > 0) {
                    QFilter idInFilter = new QFilter("id", "in", (Object)idList.toArray());
                    DynamicObject[] tdIdsList = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)("id,billno,recedbilltype,recedbillnumber,isupsucess,currency,debitamount,creditamount," + selectfields), (QFilter[])new QFilter[]{idInFilter});
                    if (tdIdsList != null && tdIdsList.length > 0) {
                        logger.info("getUpdataTransDetail------------------------------2");
                        tUpdataTransDetails.addAll(Arrays.asList(tdIdsList));
                    }
                }
                List<DynamicObject> tUpdataInfoDetails = TransDetailUpdataHelper.updateTransDetails(tUpdataTransDetails);
                if (!tUpdataTransDetails.isEmpty() || !tUpdataInfoDetails.isEmpty()) continue;
                return;
            } while (i <= 50000);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw e;
        }
        finally {
            MutexServiceHelper.release((String)PKID, (String)"bei_transdetail_cas", (String)"TransDetailUpdataTask");
        }
    }

    public static List<DynamicObject> updateTransDetails(List<DynamicObject> tUpdataTransDetails) {
        List<DynamicObject> tUpdataInfoDetails;
        if (!tUpdataTransDetails.isEmpty()) {
            List<DynamicObject> tUpdataInfoDetail = TransDetailUpdataHelper.getUpdataInfoDetail(tUpdataTransDetails);
            TransDetailUpdataHelper.saveTransDetails(tUpdataTransDetails, tUpdataInfoDetail);
        }
        if (!(tUpdataInfoDetails = TransDetailUpdataHelper.getUpdataInfoDetails()).isEmpty()) {
            Map<String, List<DynamicObject>> tRecedBillsMap = TransDetailUpdataHelper.getRecedBillsWithInfoDetails(tUpdataInfoDetails);
            TransDetailUpdataHelper.saveUpdataInfo(tRecedBillsMap, tUpdataInfoDetails);
        }
        return tUpdataInfoDetails;
    }

    private static void updataReceivingBill() {
        logger.info("updataReceivingBill------------------------------1");
        QFilter tQFilter = new QFilter("payertype", "=", (Object)"bos_org").and(QFilter.sqlExpress((String)"org", (String)"=", (String)"fpayerid"));
        TransDetailUpdataHelper.updataBill(tQFilter, "cas_recbill");
    }

    private static void updataPaymentBill() {
        logger.info("updataPaymentBill------------------------------1");
        Long beginId = 0L;
        QFilter tQFilter1 = new QFilter("billtype", "=", (Object)BillTypeConstants.PAYBILL_SYN);
        QFilter tQFilter2 = new QFilter("payeetype", "=", (Object)"bos_org").and(QFilter.sqlExpress((String)"org", (String)"=", (String)"fpayeeid")).and("billtype", "!=", (Object)BillTypeConstants.PAYBILL_CASH);
        QFilter tQFilter = tQFilter1.or(tQFilter2);
        TransDetailUpdataHelper.updataBill(tQFilter, "cas_paybill");
    }

    private static void updataBill(QFilter tQFilter, String entityName) {
        logger.info(String.format("updata {%s}------------------------------1", entityName));
        Long beginId = 0L;
        String selectProperties = "id,org.id orgid,relateotherflow,billno";
        String order = "id";
        AppParam appParam = new AppParam();
        appParam.setAppId(TmcAppEnum.CAS.getId());
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        ArrayList<DynamicObject> dynamicObjectCollections = new ArrayList<DynamicObject>();
        while (true) {
            HashSet<Long> orgIdList = new HashSet<Long>();
            QFilter idFilter = new QFilter("id", ">", (Object)beginId);
            DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"cas", (String)entityName, (String)selectProperties, (QFilter[])new QFilter[]{idFilter, tQFilter}, (String)order, (int)100);
            DataSet getOrgId = queryDataSet.copy();
            for (Row orgIdRow : getOrgId) {
                orgIdList.add(orgIdRow.getLong("orgid"));
                beginId = orgIdRow.getLong("id");
            }
            Map<String, String> sysParamMaps = TransDetailUpdataHelper.getSysParamByOrgId(orgIdList);
            DataSet buildResult = queryDataSet.copy();
            for (Row buildRow : buildResult) {
                String orgId = buildRow.get("orgid").toString();
                String objSys = sysParamMaps.get(orgId);
                DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)entityType);
                dynamicObject.set("id", (Object)buildRow.getLong("id"));
                String trueOrFalse = objSys == null ? "0" : objSys;
                dynamicObject.set("relateotherflow", (Object)trueOrFalse);
                dynamicObjectCollections.add(dynamicObject);
                if (!dynamicObject.getBoolean("relateotherflow")) continue;
                logger.info("\u4e1a\u52a1\u5355\u636e\u9700\u8981\u5339\u914d\u5bf9\u65b9\u6d41\u6c34\uff0c\u5355\u636e\u7f16\u53f7\uff1a" + buildRow.getString("billno"));
            }
            if (dynamicObjectCollections.size() <= 0) break;
            try (TXHandle tx = TX.requiresNew();){
                logger.info(String.format("updata {%s}------------------------------3", entityName));
                SaveServiceHelper.update((DynamicObject[])dynamicObjectCollections.toArray(new DynamicObject[0]));
            }
            dynamicObjectCollections.clear();
            logger.info(String.format("updata {%s}------------------------------4", entityName));
        }
    }

    private static void saveUpdataInfo(Map<String, List<DynamicObject>> tRecedBillsMap, List<DynamicObject> tUpdataInfoDetail) {
        logger.info("saveUpdataInfo");
        for (Map.Entry<String, List<DynamicObject>> tRecedBillMap : tRecedBillsMap.entrySet()) {
            TXHandle tx = TX.requiresNew();
            Throwable throwable = null;
            try {
                try {
                    TransDetailUpdataHelper.save(tRecedBillMap.getValue());
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
            }
        }
        try (TXHandle tx = TX.requiresNew();){
            TransDetailUpdataHelper.save(tUpdataInfoDetail);
        }
    }

    private static void saveTransDetails(List<DynamicObject> tUpdataTransDetails, List<DynamicObject> tUpdataInfoDetail) {
        logger.info("saveTransDetails");
        try (TXHandle tx = TX.requiresNew();){
            try {
                TransDetailUpdataHelper.save(tUpdataTransDetails);
                TransDetailUpdataHelper.save(tUpdataInfoDetail);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                throw e;
            }
        }
    }

    private static void save(List<DynamicObject> tSaveList) {
        logger.info("save");
        if (tSaveList != null && !tSaveList.isEmpty()) {
            int startIndex;
            int endIndex = tSaveList.size();
            do {
                startIndex = Math.max(0, endIndex - 50000);
                SaveServiceHelper.save((DynamicObject[])tSaveList.subList(startIndex, endIndex).toArray(new DynamicObject[0]));
                endIndex = startIndex;
            } while (startIndex != 0);
        }
    }

    private static Map<String, String> getSysParamByOrgId(Set<Long> orgIdSet) {
        HashMap<String, String> resultMap = new HashMap<String, String>(orgIdSet.size());
        if (orgIdSet != null && !orgIdSet.isEmpty()) {
            int startIndex;
            AppParam appParam = new AppParam();
            appParam.setAppId(TmcAppEnum.CAS.getId());
            ArrayList<Long> orgIdList = new ArrayList<Long>(orgIdSet.size());
            orgIdList.addAll(orgIdSet);
            int endIndex = orgIdList.size();
            do {
                startIndex = Math.max(0, endIndex - 200);
                Map sysParamMaps = SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)appParam, new ArrayList(orgIdList.subList(startIndex, endIndex)));
                for (Map.Entry entry : sysParamMaps.entrySet()) {
                    String orgId = (String)entry.getKey();
                    Map value = (Map)entry.getValue();
                    if (null == value) continue;
                    Object objSys = value.get("cs1047");
                    String trueOrFalse = objSys == null ? "0" : ((Boolean)objSys != false ? "1" : "0");
                    resultMap.put(orgId, trueOrFalse);
                }
                endIndex = startIndex;
            } while (startIndex != 0);
        }
        return resultMap;
    }

    private static List<DynamicObject> getUpdataInfoDetails() {
        logger.info("getUpdataInfoDetails------------------------------1");
        ArrayList<DynamicObject> tUpdataInfoDetails = new ArrayList<DynamicObject>(10);
        QFilter tQFilter = new QFilter("isupsucess", "=", (Object)"0");
        String fields = EntityMetadataCache.getDataEntityType((String)UPDATAINFODETAIL).getProperties().stream().map(o -> o.getName()).reduce((s1, s2) -> String.join((CharSequence)",", s1, s2)).orElse("id");
        DynamicObject[] tdIdsList = BusinessDataServiceHelper.load((String)UPDATAINFODETAIL, (String)fields, (QFilter[])tQFilter.toArray());
        if (tdIdsList != null && tdIdsList.length > 0) {
            logger.info("getUpdataInfoDetails------------------------------2");
            tUpdataInfoDetails.addAll(Arrays.asList(tdIdsList));
        }
        return tUpdataInfoDetails;
    }

    private static Map<String, List<DynamicObject>> getRecedBillsWithInfoDetails(List<DynamicObject> tUpdataInfoDetail) {
        logger.info("getRecedBillsWithInfoDetails------------------------------1");
        Map recedbillMap = tUpdataInfoDetail.stream().collect(Collectors.groupingBy(o -> o.getString("recedbilltype"), Collectors.mapping(o -> o.getLong("recedbillid"), Collectors.toSet())));
        logger.info("getRecedBillsWithInfoDetails------------------------------2");
        HashMap<String, List<DynamicObject>> recedbillsMap = new HashMap<String, List<DynamicObject>>(recedbillMap.size());
        recedbillMap.entrySet().forEach(o -> recedbillsMap.put((String)o.getKey(), TransDetailUpdataHelper.updataRecedBill((String)o.getKey(), BusinessDataServiceHelper.load((Object[])((Set)o.getValue()).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)((String)o.getKey()))))));
        logger.info("getRecedBillsWithInfoDetails------------------------------3");
        tUpdataInfoDetail.forEach(o -> o.set("isupsucess", (Object)"1"));
        return recedbillsMap;
    }

    private static List<DynamicObject> updataRecedBill(String recedbilltype, DynamicObject[] recedbills) {
        logger.info("updataRecedBill------------------------------" + recedbilltype);
        if ("cas_recbill".equals(recedbilltype)) {
            Arrays.stream(recedbills).forEach(o -> {
                Map<String, Object> tMatchResult = AutoMatchHelper.getMatchAmount(o.getBigDecimal("unmatchamountrec"), o.getBigDecimal("matchamountrec"), o.getBigDecimal("unmatchamountrec"));
                AutoMatchHelper.initMatchAmount(o, tMatchResult, "matchamountrec", "unmatchamountrec", "matchflag", "matchflagmsg");
                if (o.getBoolean("relateotherflow")) {
                    tMatchResult = AutoMatchHelper.getMatchAmount(o.getBigDecimal("unmatchamountpay"), o.getBigDecimal("matchamountpay"), o.getBigDecimal("unmatchamountpay"));
                    AutoMatchHelper.initMatchAmount(o, tMatchResult, "matchamountpay", "unmatchamountpay", "matchflag", "matchflagmsg");
                }
            });
        } else if ("cas_paybill".equals(recedbilltype)) {
            Arrays.stream(recedbills).forEach(o -> {
                if (Long.compare(BillTypeConstants.PAYBILL_CASH, o.getLong("billtype.id")) == 0 && "cashin".equals(o.getString("businesstype"))) {
                    Map<String, Object> tMatchResult = AutoMatchHelper.getMatchAmount(o.getBigDecimal("unmatchamountrec"), o.getBigDecimal("matchamountrec"), o.getBigDecimal("unmatchamountrec"));
                    AutoMatchHelper.initMatchAmount(o, tMatchResult, "matchamountrec", "unmatchamountrec", "matchflag", "matchflagmsg");
                } else {
                    Map<String, Object> tMatchResult = AutoMatchHelper.getMatchAmount(o.getBigDecimal("unmatchamountpay"), o.getBigDecimal("matchamountpay"), o.getBigDecimal("unmatchamountpay"));
                    AutoMatchHelper.initMatchAmount(o, tMatchResult, "matchamountpay", "unmatchamountpay", "matchflag", "matchflagmsg");
                    if (o.getBoolean("relateotherflow")) {
                        tMatchResult = AutoMatchHelper.getMatchAmount(o.getBigDecimal("unmatchamountrec"), o.getBigDecimal("matchamountrec"), o.getBigDecimal("unmatchamountrec"));
                        AutoMatchHelper.initMatchAmount(o, tMatchResult, "matchamountrec", "unmatchamountrec", "matchflag", "matchflagmsg");
                    }
                }
            });
        } else if ("cas_agentpaybill".equals(recedbilltype)) {
            Arrays.stream(recedbills).forEach(o -> {
                Map<String, Object> tMatchResult = AutoMatchHelper.getMatchAmount(o.getBigDecimal("unmatchamount"), o.getBigDecimal("matchamount"), o.getBigDecimal("unmatchamount"));
                AutoMatchHelper.initMatchAmount(o, tMatchResult, "matchamount", "unmatchamount", "matchflag", "matcherrmsg");
                o.getDynamicObjectCollection("entry").forEach(entry -> {
                    Map<String, Object> tEntryMatchResult = AutoMatchHelper.getMatchAmount(entry.getBigDecimal("entryunmatchamount"), entry.getBigDecimal("entrymatchamount"), entry.getBigDecimal("entryunmatchamount"));
                    AutoMatchHelper.initMatchAmount(entry, tEntryMatchResult, "entrymatchamount", "entryunmatchamount", "entrymatchflag", "entrymatcherrmsg");
                });
            });
        } else if (SourceBillTypeEnum.EXCHANGEBILL.getValue().equals(recedbilltype)) {
            Arrays.stream(recedbills).forEach(o -> {
                Map<String, Object> tMatchResult = AutoMatchHelper.getMatchAmount(o.getBigDecimal("buyunmatchamount"), o.getBigDecimal("buymatchamount"), o.getBigDecimal("buyunmatchamount"));
                AutoMatchHelper.initMatchAmount(o, tMatchResult, "buymatchamount", "buyunmatchamount", "buymatchflag", "buymatchflagmsg");
                tMatchResult = AutoMatchHelper.getMatchAmount(o.getBigDecimal("sellunmatchamount"), o.getBigDecimal("sellmatchamount"), o.getBigDecimal("sellunmatchamount"));
                AutoMatchHelper.initMatchAmount(o, tMatchResult, "sellmatchamount", "sellunmatchamount", "sellmatchflag", "sellmatchflagmsg");
                tMatchResult = AutoMatchHelper.getMatchAmount(o.getBigDecimal("feeunmatchamount"), o.getBigDecimal("feematchamount"), o.getBigDecimal("feeunmatchamount"));
                AutoMatchHelper.initMatchAmount(o, tMatchResult, "feematchamount", "feeunmatchamount", "feematchflag", "feematchflagmsg");
                MatchAmountDealHelper.updataExchangeBill(o);
            });
        } else if ("fca_transupbill".equals(recedbilltype)) {
            Arrays.stream(recedbills).forEach(o -> {
                Map<String, Object> tMatchResult = AutoMatchHelper.getMatchAmount(o.getBigDecimal("unmatchamount"), o.getBigDecimal("matchamount"), o.getBigDecimal("unmatchamount"));
                AutoMatchHelper.initMatchAmount(o, tMatchResult, "matchamount", "unmatchamount", "matchflag", "matcherrmsg");
                o.getDynamicObjectCollection("entrys").forEach(entry -> {
                    Map<String, Object> tEntryMatchResult = AutoMatchHelper.getMatchAmount(entry.getBigDecimal("entryunmatchamount"), entry.getBigDecimal("entrymatchamount"), entry.getBigDecimal("entryunmatchamount"));
                    AutoMatchHelper.initMatchAmount(entry, tEntryMatchResult, "entrymatchamount", "entryunmatchamount", "entrymatchflag", "entrymatcherrmsg");
                });
            });
        } else if ("fca_transdownbill".equals(recedbilltype)) {
            Arrays.stream(recedbills).forEach(o -> {
                Map<String, Object> tMatchResult = AutoMatchHelper.getMatchAmount(o.getBigDecimal("unmatchamount"), o.getBigDecimal("matchamount"), o.getBigDecimal("unmatchamount"));
                AutoMatchHelper.initMatchAmount(o, tMatchResult, "matchamount", "unmatchamount", "matchflag", "matcherrmsg");
                o.getDynamicObjectCollection("entrys").forEach(entry -> {
                    Map<String, Object> tEntryMatchResult = AutoMatchHelper.getMatchAmount(entry.getBigDecimal("entryunmatchamount"), entry.getBigDecimal("entrymatchamount"), entry.getBigDecimal("entryunmatchamount"));
                    AutoMatchHelper.initMatchAmount(entry, tEntryMatchResult, "entrymatchamount", "entryunmatchamount", "entrymatchflag", "entrymatcherrmsg");
                });
            });
        } else if ("ifm_transhandlebill".equals(recedbilltype)) {
            Arrays.stream(recedbills).forEach(o -> {
                Map<String, Object> tMatchResult = AutoMatchHelper.getMatchAmount(o.getBigDecimal("unmatchamountpay"), o.getBigDecimal("matchamountpay"), o.getBigDecimal("unmatchamountpay"));
                AutoMatchHelper.initMatchAmount(o, tMatchResult, "matchamountpay", "unmatchamountpay", "matchflag", "matchflagmsg");
            });
        }
        return Arrays.stream(recedbills).collect(Collectors.toList());
    }

    private static List<DynamicObject> getUpdataInfoDetail(List<DynamicObject> tUpdataTransDetails) {
        logger.info("getUpdataInfoDetail------------------------------1");
        ArrayList<DynamicObject> tUpdataInfoDetails = new ArrayList<DynamicObject>(10);
        if (tUpdataTransDetails != null) {
            Map<Long, Map<String, DynamicObjectCollection>> tRecedBillsMap = TransDetailUpdataHelper.getRecedBills(tUpdataTransDetails);
            logger.info("getUpdataInfoDetail------------------------------2");
            for (DynamicObject tUpdataTransDetail : tUpdataTransDetails) {
                Long tTransDetailId = tUpdataTransDetail.getLong("id");
                logger.info("getUpdataInfoDetail------------------------------" + tTransDetailId);
                logger.info("getUpdataInfoDetail------------------------------" + tUpdataTransDetail.getString("billno"));
                boolean ispay = BigDecimal.ZERO.compareTo(tUpdataTransDetail.getBigDecimal("debitamount")) != 0;
                Map<String, DynamicObjectCollection> tRecedBills = tRecedBillsMap.get(tTransDetailId);
                tRecedBills.entrySet().stream().forEach(entry -> {
                    String amttype = SourceBillTypeEnum.EXCHANGEBILL.getValue().equals(entry.getKey()) ? (ispay ? "sell" : "buy") : null;
                    ((DynamicObjectCollection)entry.getValue()).stream().forEach(o -> {
                        List<DynamicObject> tRecedBillEntry = AutoMatchHelper.getRecedBillEntry(tUpdataTransDetail, o.getLong("id"));
                        if (tRecedBillEntry == null || tRecedBillEntry.size() < 1) {
                            AutoMatchHelper.setRecedBillEntry(tUpdataTransDetail, (String)entry.getKey(), o.getString("billno"), o.getLong("id"), null, amttype, BigDecimal.ZERO);
                        }
                    });
                });
                logger.info("getUpdataInfoDetail------------------------------3");
                List<DynamicObject> tUpdataInfoDetail = TransDetailUpdataHelper.createUpdataInfoDetail(tUpdataTransDetail);
                if (tUpdataInfoDetail != null && !tUpdataInfoDetail.isEmpty()) {
                    tUpdataInfoDetails.addAll(tUpdataInfoDetail);
                }
                tUpdataTransDetail.set("isupsucess", (Object)"1");
            }
        }
        return tUpdataInfoDetails;
    }

    private static List<DynamicObject> createUpdataInfoDetail(DynamicObject tUpdataTransDetail) {
        ArrayList<DynamicObject> tUpdataInfoList;
        logger.info("createUpdataInfoDetail");
        DynamicObjectCollection recedbillentrys = tUpdataTransDetail.getDynamicObjectCollection("recedbillentry");
        if (recedbillentrys != null) {
            tUpdataInfoList = new ArrayList(recedbillentrys.size());
            String recedbilltype = null;
            for (DynamicObject recedbillentry : recedbillentrys) {
                if (BigDecimal.ZERO.compareTo(recedbillentry.getBigDecimal("e_amount")) != 0) continue;
                DynamicObject tUpdataInfoDetail = BusinessDataServiceHelper.newDynamicObject((String)UPDATAINFODETAIL);
                tUpdataInfoDetail.set("id", (Object)DB.genLongId((String)UPDATAINFODETAIL));
                tUpdataInfoDetail.set("transdetailid", (Object)tUpdataTransDetail.getLong("id"));
                tUpdataInfoDetail.set("transdetailnumber", (Object)tUpdataTransDetail.getString("billno"));
                tUpdataInfoDetail.set("recedbilltype", (Object)recedbillentry.getString("e_recedbilltype"));
                tUpdataInfoDetail.set("recedbillnumber", (Object)recedbillentry.getString("e_recedbillnumber"));
                tUpdataInfoDetail.set("recedbillid", (Object)recedbillentry.getLong("e_recedbillid"));
                tUpdataInfoDetail.set("currency", (Object)tUpdataTransDetail.getLong("currency.id"));
                tUpdataInfoDetail.set("amount", (Object)recedbillentry.getBigDecimal("e_amount"));
                tUpdataInfoDetail.set("isupsucess", (Object)"0");
                recedbilltype = recedbillentry.getString("e_recedbilltype");
                if (Arrays.asList("cas_paybill_synonym", "cas_paybill_cash", "cas_paybill_spanmainpart").contains(recedbilltype)) {
                    recedbilltype = "cas_paybill";
                }
                tUpdataInfoDetail.set("recedbilltype", (Object)recedbilltype);
                tUpdataInfoList.add(tUpdataInfoDetail);
            }
        } else {
            tUpdataInfoList = new ArrayList<DynamicObject>(0);
        }
        return tUpdataInfoList;
    }

    private static Map<Long, Map<String, DynamicObjectCollection>> getRecedBills(List<DynamicObject> tUpdataTransDetails) {
        logger.info("getRecedBills------------------------------1");
        List<String> busnessBillList = Arrays.asList("cas_recbill", "cas_paybill", "cas_agentpaybill", "fca_transupbill", "fca_transdownbill", "ifm_transhandlebill", SourceBillTypeEnum.EXCHANGEBILL.getValue());
        ConvertDataService reader = new ConvertDataService();
        HashMap<Long, String> busnessBillMap = new HashMap<Long, String>(busnessBillList.size());
        for (String busnessBill : busnessBillList) {
            try {
                TableDefine tableDefine = reader.loadTableDefine(busnessBill, busnessBill);
                if (tableDefine == null) continue;
                busnessBillMap.put(tableDefine.getTableId(), busnessBill);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
        Long[] tUpdataTransDetailIds = (Long[])tUpdataTransDetails.stream().map(o -> o.getLong("id")).toArray(Long[]::new);
        Map transTargetBills = BFTrackerServiceHelper.findDirtTargetBills((String)"bei_transdetail_cas", (Long[])tUpdataTransDetailIds);
        Map payTargetBills = BFTrackerServiceHelper.findDirtTargetBills((String)"bei_intelpay", (Long[])tUpdataTransDetailIds);
        Map recTargetBills = BFTrackerServiceHelper.findDirtTargetBills((String)"bei_intelrec", (Long[])tUpdataTransDetailIds);
        Map<Long, List<BFRow>> targetBills = TransDetailUpdataHelper.mergerMap(transTargetBills, payTargetBills);
        targetBills = TransDetailUpdataHelper.mergerMap(targetBills, recTargetBills);
        HashMap tDirtTargetBillsMap = new HashMap(tUpdataTransDetails.size());
        Map targetBillEntryMap = null;
        HashMap tDirtTargetBillMap = null;
        for (Map.Entry<Long, List<BFRow>> targetBillEntry : targetBills.entrySet()) {
            targetBillEntry.getValue().removeIf(o -> !busnessBillMap.containsKey(o.getId().getMainTableId()));
            targetBillEntryMap = targetBillEntry.getValue().stream().collect(Collectors.groupingBy(k -> k.getId().getMainTableId(), Collectors.mapping(o -> o.getId().getBillId(), Collectors.toSet())));
            tDirtTargetBillMap = new HashMap(targetBillEntryMap.size());
            for (Map.Entry targetBill : targetBillEntryMap.entrySet()) {
                tDirtTargetBillMap.put(busnessBillMap.get(targetBill.getKey()), targetBill.getValue());
            }
            logger.info("\u4ea4\u6613\u660e\u7ec6\u5173\u8054\u7684\u5355\u636e\u7c7b\u578b\uff1a" + tDirtTargetBillMap.values().toString());
            tDirtTargetBillsMap.put(targetBillEntry.getKey(), tDirtTargetBillMap);
        }
        HashMap<Long, Map<String, DynamicObjectCollection>> result = new HashMap<Long, Map<String, DynamicObjectCollection>>(tUpdataTransDetails.size());
        for (DynamicObject tUpdataTransDetail : tUpdataTransDetails) {
            Long tTransDetailId = tUpdataTransDetail.getLong("id");
            logger.info("\u4ea4\u6613\u660e\u7ec6ID\uff1a" + tTransDetailId.toString());
            Map recedbillsMap = (Map)tDirtTargetBillsMap.get(tTransDetailId);
            String recedbilltype = tUpdataTransDetail.getString("recedbilltype");
            String recedbillnumber = tUpdataTransDetail.getString("recedbillnumber");
            QFilter billno = null;
            if (recedbillnumber != null && recedbillnumber.trim().length() > 0) {
                logger.info("\u4ea4\u6613\u660e\u7ec6\u5b58\u5728\u63a5\u6536\u5355\u636e\u7c7b\u578b\uff1a" + recedbilltype + "\u63a5\u6536\u5355\u636e\u7f16\u53f7\uff1a" + recedbillnumber);
                billno = new QFilter("billno", "=", (Object)recedbillnumber);
            }
            HashMap<String, DynamicObjectCollection> targetBillresults = new HashMap<String, DynamicObjectCollection>();
            DynamicObjectCollection recedbills = null;
            for (String busnessBillType : busnessBillList) {
                HashSet recedbillIdSet = new HashSet();
                if (recedbillsMap != null && recedbillsMap.containsKey(busnessBillType)) {
                    recedbillIdSet.addAll((Collection)recedbillsMap.get(busnessBillType));
                }
                if (recedbillIdSet.size() < 1 && billno == null) continue;
                QFilter tQFilter = new QFilter("id", "in", recedbillIdSet);
                if (billno != null) {
                    tQFilter.or(billno);
                }
                try {
                    recedbills = QueryServiceHelper.query((String)busnessBillType, (String)"id,billno", (QFilter[])tQFilter.toArray());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (recedbills == null || recedbills.isEmpty()) continue;
                targetBillresults.put(busnessBillType, recedbills);
            }
            logger.info("getRecedBills------------------------------2");
            result.put(tTransDetailId, targetBillresults);
        }
        return result;
    }

    private static Map<Long, List<BFRow>> mergerMap(Map<Long, List<BFRow>> aDirtTargetBills, Map<Long, List<BFRow>> bDirtTargetBills) {
        if (aDirtTargetBills == null || aDirtTargetBills.isEmpty()) {
            if (bDirtTargetBills == null || bDirtTargetBills.isEmpty()) {
                return new HashMap<Long, List<BFRow>>(0);
            }
            return bDirtTargetBills;
        }
        if (bDirtTargetBills == null || bDirtTargetBills.isEmpty()) {
            return aDirtTargetBills;
        }
        HashMap<Long, List<BFRow>> aResult = new HashMap<Long, List<BFRow>>(aDirtTargetBills);
        HashMap<Long, List<BFRow>> bResult = new HashMap<Long, List<BFRow>>(bDirtTargetBills);
        for (Map.Entry setEntry : bResult.entrySet()) {
            List aList = (List)setEntry.getValue();
            if (aResult.containsKey(setEntry.getKey())) {
                aList.addAll((Collection)aResult.get(setEntry.getKey()));
            }
            aResult.put((Long)setEntry.getKey(), aList);
        }
        bResult.putAll(aResult);
        return bResult;
    }
}

