/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ocr.impl;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.isc.util.misc.NetUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.tmc.bei.business.ocr.api.ScanService;
import kd.tmc.bei.common.scan.ScanResponse;
import kd.tmc.bei.common.scan.ScanResponseData;
import kd.tmc.bei.common.scan.ScanTokenRequest;
import kd.tmc.fbp.common.helper.TmcCacheHelper;
import kd.tmc.fbp.service.ebservice.errorcode.ErrorCodeUtils;
import kd.tmc.fbp.service.ebservice.exception.EBBizNCException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class ScanService2Impl
implements ScanService {
    private final Log logger = LogFactory.getLog(ScanService2Impl.class);
    private DistributeSessionlessCache cache = TmcCacheHelper.getSessionlessCacheInstance();
    private final int TOKEN_TIMEOUT_MINUTES_HOUR = 2;

    @Override
    public String getScanSystem(String clientId, String clientSercet, String url, String phone) {
        return this.getPageUrl(clientId, clientSercet, url, phone);
    }

    private String getTokenRequestBody(String clientId, String clientSercet, String phone) {
        StringBuilder sb = new StringBuilder();
        long currentTimeMillis = System.currentTimeMillis();
        String timestamp = String.valueOf(currentTimeMillis);
        sb.append(clientId);
        sb.append(clientSercet);
        sb.append(timestamp);
        String sign = DigestUtils.md5Hex((String)sb.toString());
        ScanTokenRequest request = new ScanTokenRequest();
        request.setClientId(clientId);
        request.setSign(sign);
        request.setTimestamp(Long.valueOf(currentTimeMillis));
        request.setFphoneNumber(phone);
        request.setLanguage("zh-CN");
        return JSON.toJSONString((Object)request);
    }

    private String getPageUrl(String clientId, String clientSercet, String url, String phone) {
        String jsonBody = this.getTokenRequestBody(clientId, clientSercet, phone);
        this.logger.info("ScanServiceImpl.getPageUrl jsonBody=" + jsonBody);
        return this.doPost(url, jsonBody);
    }

    public InputStream getImage(String clientId, String clientSercet, String url, String phone, String fileId) {
        String imgsysUrl = this.getImgsysUrl(clientId, clientSercet, url, phone, fileId);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet httpGet = new HttpGet(imgsysUrl);
        InputStream content = null;
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            content = response.getEntity().getContent();
        }
        catch (IOException e) {
            this.logger.error((Throwable)e);
        }
        return content;
    }

    public String getImgsysUrl(String clientId, String clientSercet, String url, String phone, String fileId) {
        String jsonBody = this.getTokenRequestBody(clientId, clientSercet, phone);
        String token = this.getToken(url, jsonBody);
        String returnUrl = url + "/imgsys/bill/erp/bankReceipt/view?access_token=" + token + "&fileId=" + fileId;
        return returnUrl;
    }

    private String doPost(String url, String body) {
        String responseDody;
        String pageUrl = "";
        String token = this.getToken(url, body);
        String number = "tmc-bei-invokeimage";
        this.importResource(number);
        String scanImageUrl = url + "imgsys/bill/erp/bankReceipt/bankReceiptPageUrl?access_token=" + token;
        HashMap params = new HashMap(16);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        HashMap<String, String> headersMap = new HashMap<String, String>(16);
        paramMap.put("url", scanImageUrl);
        paramMap.put("method", "GET");
        paramMap.put("charset", "utf-8");
        headersMap.put("Content-Type", "application/json; charset=UTF-8");
        paramMap.put("headers", headersMap);
        paramMap.put("timeout", 5000);
        params.put("paramMap", paramMap);
        try {
            Object response = DispatchServiceHelper.invokeExternalService((String)"bei", (String)number, params);
            this.logger.info("ScanServiceImpl.doPost response=" + response);
            responseDody = response.toString();
            this.logger.info("ScanServiceImpl.doPost responseDody=" + responseDody);
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            throw new EBBizNCException(ErrorCodeUtils.create((String)"TOKEN", (String)ResManager.loadKDString((String)"\u8df3\u8f6c\u626b\u63cf\u7cfb\u7edf\u5931\u8d25\uff1a%s\u3002", (String)"ScanServiceImpl_0", (String)"tmc-bei-business", (Object[])new Object[]{e.getMessage()})));
        }
        ScanResponse osResponse = (ScanResponse)JSON.parseObject((String)responseDody, ScanResponse.class);
        if (!"0000".equals(osResponse.getErrcode())) {
            throw new EBBizNCException(ErrorCodeUtils.create((String)"TOKEN", (String)ResManager.loadKDString((String)"\u8df3\u8f6c\u626b\u63cf\u7cfb\u7edf\u5931\u8d25\uff1a%s\u3002", (String)"ScanServiceImpl_0", (String)"tmc-bei-business", (Object[])new Object[]{osResponse.getDescription()})));
        }
        pageUrl = osResponse.getData().getBankReceiptPageUrl();
        return pageUrl;
    }

    private String getToken(String url, String body) {
        String responseDody;
        String token = (String)this.cache.get("imisys_token");
        if (token != null && !this.isTokenExpired()) {
            return token;
        }
        String number = "tmc-bei-gettoken";
        this.importResource(number);
        String tokenUrl = url + "/archivebase/scan/login/token";
        this.logger.info("\u8bf7\u6c42\u5f71\u50cf\u7cfb\u7edf\u83b7\u53d6token\u7684url:" + tokenUrl);
        HashMap params = new HashMap(16);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        HashMap<String, String> headersMap = new HashMap<String, String>(16);
        paramMap.put("url", tokenUrl);
        paramMap.put("method", "POST");
        paramMap.put("charset", "utf-8");
        paramMap.put("data", body);
        headersMap.put("Content-Type", "application/json; charset=UTF-8");
        paramMap.put("headers", headersMap);
        paramMap.put("timeout", 5000);
        params.put("paramMap", paramMap);
        try {
            Object response = DispatchServiceHelper.invokeExternalService((String)"bei", (String)"tmc-bei-gettoken", params);
            responseDody = response.toString();
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            throw new EBBizNCException(ErrorCodeUtils.create((String)"TOKEN", (String)ResManager.loadKDString((String)"\u83b7\u53d6TOKEN\u5931\u8d25\u3002", (String)"ScanServiceImpl_1", (String)"tmc-bei-business", (Object[])new Object[0])));
        }
        ScanResponse result = (ScanResponse)JSON.parseObject((String)responseDody, ScanResponse.class);
        if (!"0000".equals(result.getErrcode())) {
            throw new EBBizNCException(ErrorCodeUtils.create((String)"TOKEN", (String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6TOKEN\u5931\u8d25\uff1a%s\u3002", (String)"ScanServiceImpl_3", (String)"tmc-bei-business", (Object[])new Object[0]), result.getDescription())));
        }
        ScanResponseData data = result.getData();
        String accessToken = data.getAccessToken();
        String timeStr = System.currentTimeMillis() + "";
        this.cache.put("imisys_timeout", (Object)timeStr);
        this.cache.put("imisys_token", (Object)accessToken);
        return accessToken;
    }

    private void importResource(String number) {
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)"isc_apic_script", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        if (object == null) {
            try (InputStream in = this.getClass().getClassLoader().getResource("resources/" + number + ".dts").openStream();){
                String jsonStr = NetUtil.readText((InputStream)in);
                Object result = DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscResourceService", (String)"importResourceWithPattern", (Object[])new Object[]{jsonStr, true});
                if (result == null) {
                    this.logger.info("\u3010\u8d44\u91d1-\u94f6\u4f01\u4e92\u8054\u3011\u6a21\u5757\uff0c\u7f16\u7801\u4e3a\uff1a" + number + "\u7684\u81ea\u5b9a\u4e49API\u5bfc\u5165\u6210\u529f\u3002");
                }
            }
            catch (IOException e) {
                this.logger.error("\u3010\u8d44\u91d1-\u94f6\u4f01\u4e92\u8054\u3011\u6a21\u5757\u5bfc\u5165\u81ea\u5b9a\u4e49API\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a", (Throwable)e);
            }
        }
    }

    private boolean isTokenExpired() {
        String timeStr = (String)this.cache.get("imisys_timeout");
        if (timeStr != null) {
            try {
                long currTime = System.currentTimeMillis();
                long prevTime = Long.parseLong(timeStr);
                long minuteDiff = (currTime - prevTime) / 1000L / 60L / 60L;
                return minuteDiff >= 2L;
            }
            catch (Exception ignored) {
                return true;
            }
        }
        return true;
    }
}

