/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ocr.invoke;

import com.alibaba.fastjson.JSON;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.bei.common.constants.OcrReceiptBean;

public class ParReceiptForOrc {
    private static final Log logger = LogFactory.getLog(ParReceiptForOrc.class);
    private static volatile ParReceiptForOrc instance = null;

    private ParReceiptForOrc() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ParReceiptForOrc getInstance() {
        if (instance != null) return instance;
        Class<ParReceiptForOrc> clazz = ParReceiptForOrc.class;
        synchronized (ParReceiptForOrc.class) {
            if (instance != null) return instance;
            instance = new ParReceiptForOrc();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public OcrReceiptBean doPost(InputStream ins, String filename) throws Exception {
        String businessObject = "bei_elecreceipt";
        String templateNumber = "OPM-BankReceipt";
        String imageData = this.getBase64String(ins);
        Object[] params = new Object[]{businessObject, templateNumber, imageData};
        String result = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"cvp", (String)"OcrService", (String)"distinguishOcrImage", (Object[])params);
        logger.info("ocrResult: " + result);
        return (OcrReceiptBean)JSON.parseObject((String)result, OcrReceiptBean.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getBase64String(InputStream ins) throws IOException {
        byte[] buff = new byte[1024];
        int len = 0;
        try (ByteArrayOutputStream swapStream = new ByteArrayOutputStream();){
            while ((len = ins.read(buff)) != -1) {
                swapStream.write(buff, 0, len);
            }
            String string = Base64.getEncoder().encodeToString(swapStream.toByteArray());
            return string;
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw e;
        }
    }
}

