/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.balance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.bei.business.ebservice.EBBalanceQueryService;
import kd.tmc.bei.business.opservice.helper.ErrorInfoHelper;
import kd.tmc.bei.business.opservice.param.BalanceQueryParam;
import kd.tmc.bei.business.opservice.result.BalanceResult;
import kd.tmc.bei.business.task.balance.SyncBalanceByMQTask;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.TmcCacheHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BalanceDownScheduleService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(BalanceDownScheduleService.class);

    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>();
        lst.add("issetbankinterface");
        lst.add("bankaccountnumber");
        lst.add("company");
        lst.add("currency.fbasedataid.id");
        lst.add("bank");
        lst.add("defaultcurrency");
        lst.add("bankinterface");
        lst.add("createorg");
        return lst;
    }

    public void process(DynamicObject[] dataEntities) throws TmcBizException {
        try {
            Date startdate = DateUtils.getCurrentDate();
            Date enddate = DateUtils.getCurrentDate();
            String cycle = (String)this.operationVariable.get("schedule_cycle");
            if (StringUtils.isNotEmpty((CharSequence)cycle)) {
                enddate = DateUtils.getLastDay((Date)enddate, (int)1);
                startdate = DateUtils.getLastDay((Date)startdate, (int)Integer.parseInt(cycle));
            }
            DistributeSessionlessCache cache = TmcCacheHelper.getSessionlessCacheInstance();
            String cacheKey = "refreshBalance-" + RequestContext.get().getCurrUserId();
            String cacheValue = (String)cache.get(cacheKey);
            boolean isHomePageRefresh = false;
            if (EmptyUtil.isNoEmpty((String)cacheValue)) {
                isHomePageRefresh = true;
                cache.remove(cacheKey);
            }
            List<Long> idList = Arrays.stream(dataEntities).map(d -> (Long)d.getPkValue()).collect(Collectors.toList());
            boolean isByMQQueryData = TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.BEI.getId(), (long)OrgUnitServiceHelper.getRootOrgId(), (String)"bei011");
            if (isByMQQueryData && !isHomePageRefresh) {
                HashMap<String, Object> param = new HashMap<String, Object>(8);
                param.put("accountid", idList);
                param.put("startdate", startdate);
                param.put("enddate", enddate);
                new SyncBalanceByMQTask().execute(param);
            } else {
                BalanceQueryParam balanceQueryParam = new BalanceQueryParam(null, startdate, enddate, idList);
                List<BalanceResult> balanceResults = new EBBalanceQueryService(balanceQueryParam).queryBatchBalance();
                List<OperateErrorInfo> operateErrorInfos = ErrorInfoHelper.convertBalanceErrorInfos(balanceResults);
                if (!CollectionUtils.isEmpty(operateErrorInfos)) {
                    this.operationResult.setSuccess(false);
                    this.operationResult.setAllErrorInfo(operateErrorInfos);
                    this.operationResult.setShowMessage(false);
                } else {
                    this.operationResult.setSuccess(true);
                }
            }
        }
        catch (Exception e) {
            ArrayList<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>(dataEntities.length);
            for (DynamicObject dataEntity : dataEntities) {
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setLevel(ErrorLevel.FatalError);
                operateErrorInfo.setMessage(e.getMessage());
                operateErrorInfo.setPkValue(dataEntity.getPkValue());
                errorInfos.add(operateErrorInfo);
            }
            this.operationResult.setSuccess(false);
            this.operationResult.setAllErrorInfo(errorInfos);
            this.operationResult.setShowMessage(false);
        }
    }
}

