/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.bankpay;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.tmc.bei.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.service.ebservice.data.EBResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;

public abstract class AbstractQueryOpService
extends AbstractTmcBizOppService {
    protected List<OperateErrorInfo> errorInfoList = new ArrayList<OperateErrorInfo>();

    public void process(DynamicObject[] dynamicObjects) throws KDException {
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        Map bankBillIdMap = Arrays.stream(dataEntities).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
        List<EBResult> resultList = EBServiceFacadeFactory.getBankService().queryPay(Arrays.asList(dataEntities), false);
        for (EBResult ebResult : resultList) {
            if (ebResult.getStatusCode() == EBResultStatusCode.SUCCESS) continue;
            DynamicObject bankBill = (DynamicObject)bankBillIdMap.get(ebResult.getBankBillId());
            if (bankBill == null) {
                if (ebResult.getErrMsg() == null) continue;
                throw new KDBizException(ebResult.getErrMsg());
            }
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo("", ErrorLevel.Error, bankBill.getPkValue(), (Object)bankBill.getDynamicObjectType().getName());
            if (ebResult.getErrCode() != null) {
                operateErrorInfo.setErrorCode(ebResult.getErrCode().getCode());
            }
            operateErrorInfo.setMessage(bankBill.get("billno") + ":" + ebResult.getErrMsg());
            this.errorInfoList.add(operateErrorInfo);
        }
    }

    public void onReturnOperation(IOperationResult e) throws KDException {
        super.onReturnOperation(e);
        for (OperateErrorInfo operateErrorInfo : this.errorInfoList) {
            e.addErrorInfo(operateErrorInfo);
        }
    }
}

