/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.bankpay;

import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.bei.common.helper.AttachmentHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;

public class BankPayingSaveService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(BankPayingSaveService.class);

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        try (TXHandle tx = TX.requiresNew();){
            try {
                for (DynamicObject bankPayBill : dataEntities) {
                    boolean overseaPay = bankPayBill.getBoolean("istranspay");
                    String srcBillType = bankPayBill.getString("srcbilltype");
                    if (!"cas_paybill".equals(srcBillType) || !overseaPay) continue;
                    String srcBillNo = bankPayBill.getString("srcbillno");
                    long srcBillId = bankPayBill.getLong("sourcebillid");
                    List attachmentList = AttachmentServiceHelper.getAttachments((String)srcBillType, (Object)srcBillId, (String)"attachmentpanel", (boolean)false);
                    logger.info("bei_bankpaybill billno:{}, {} srcBillNo:{}, attachment file size is {}", new Object[]{bankPayBill.getString("billno"), srcBillType, srcBillNo, attachmentList.size()});
                    if (!CollectionUtils.isNotEmpty((Collection)attachmentList)) continue;
                    String entityName = bankPayBill.getDataEntityType().getName();
                    long billId = bankPayBill.getLong("Id");
                    AttachmentHelper.copyAttachment((String)srcBillType, (long)srcBillId, (String)"attachmentpanel", (String)entityName, (long)billId, (String)"attachmentpanel");
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("upload attachment file fail", (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u8de8\u5883\u652f\u4ed8\u7684\u94f6\u884c\u4ed8\u6b3e\u5355\u4e0a\u4f20\u9644\u4ef6\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"BankPayingSaveService_0", (String)"tmc-bei-business", (Object[])new Object[0]));
            }
        }
    }
}

