/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.detail;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.bei.business.helper.AccountBankHelper;
import kd.tmc.bei.business.task.transdetail.SyncTransDetailByMQTask;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.DateUtils;

public class DetailDownScheduleService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(DetailDownScheduleService.class);

    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>(6);
        lst.add("issetbankinterface");
        lst.add("bankaccountnumber");
        lst.add("company");
        lst.add("currency.fbasedataid.id");
        lst.add("defaultcurrency");
        lst.add("createorg");
        return lst;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        try {
            boolean isByMQQueryData;
            String cycle = (String)this.operationVariable.get("schedule_cycle");
            String downloadFromBankStr = (String)this.operationVariable.get("downloadFromBank");
            Date startdate = DateUtils.getCurrentDate();
            Date enddate = DateUtils.getCurrentDate();
            if (StringUtils.isNotEmpty((CharSequence)cycle)) {
                enddate = DateUtils.getLastDay((Date)enddate, (int)1);
                startdate = DateUtils.getLastDay((Date)startdate, (int)Integer.parseInt(cycle));
            }
            if (isByMQQueryData = TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.BEI.getId(), (long)OrgUnitServiceHelper.getRootOrgId(), (String)"bei012")) {
                HashMap<String, Object> param = new HashMap<String, Object>(8);
                param.put("accountid", Arrays.stream(dataEntities).map(d -> (Long)d.getPkValue()).collect(Collectors.toList()));
                param.put("startdate", startdate);
                param.put("enddate", enddate);
                param.put("downloadFromBank", downloadFromBankStr);
                new SyncTransDetailByMQTask().execute(param);
            } else {
                boolean downloadFromBank;
                List<DynamicObject> accountBanks = Arrays.stream(dataEntities).collect(Collectors.toList());
                List<OperateErrorInfo> operateErrorInfos = AccountBankHelper.downTransDetailsSync(accountBanks, startdate, enddate, true, downloadFromBank = Boolean.parseBoolean(downloadFromBankStr));
                if (!CollectionUtils.isEmpty(operateErrorInfos)) {
                    this.operationResult.setSuccess(false);
                    this.operationResult.setAllErrorInfo(operateErrorInfos);
                    this.operationResult.setShowMessage(false);
                } else {
                    this.operationResult.setSuccess(true);
                }
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            ArrayList<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>(dataEntities.length);
            for (DynamicObject dataEntity : dataEntities) {
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setLevel(ErrorLevel.Error);
                operateErrorInfo.setMessage(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                operateErrorInfo.setPkValue(dataEntity.getPkValue());
                errorInfos.add(operateErrorInfo);
            }
            this.operationResult.setSuccess(false);
            this.operationResult.setAllErrorInfo(errorInfos);
            this.operationResult.setShowMessage(false);
        }
    }
}

