/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.detail;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.tmc.bei.business.helper.TransDetailHelper;
import kd.tmc.bei.common.helper.SyncAutoBalanceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.GenBankcheckCode;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DetailImportSaveService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(DetailImportSaveService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("receredtype");
        selector.add("claimnoticebillno");
        selector.add("isdowntobankstate");
        selector.add("bankcheckflag");
        selector.add("company");
        selector.add("currency");
        selector.add("creditamount");
        selector.add("receredtype");
        selector.add("datasource");
        selector.add("billno");
        selector.add("accountbank");
        selector.add("bizdate");
        selector.add("transbalance");
        selector.add("sortno");
        selector.add("biztime");
        selector.add("modifytime");
        selector.add("lastmodifytime");
        selector.add("uniqueSeq");
        selector.add("synonym");
        selector.add("opprelacct");
        return selector;
    }

    public void process(DynamicObject[] details) throws KDException {
        Map<String, List<DynamicObject>> groupMap = Arrays.stream(details).collect(Collectors.groupingBy(v -> (v.getDynamicObject("accountbank") == null ? "accountbank" : v.getDynamicObject("accountbank").getString("bankaccountnumber")) + "---" + (v.getDynamicObject("currency") == null ? "currency" : v.getDynamicObject("currency").getString("number"))));
        HashMap<String, Boolean> needResortMap = new HashMap<String, Boolean>(16);
        for (Map.Entry<String, List<DynamicObject>> entry : groupMap.entrySet()) {
            List<DynamicObject> dataList = entry.getValue();
            List sortNoList = dataList.stream().map(b -> b.getInt("sortno")).filter(c -> c != 0).collect(Collectors.toList());
            boolean needReSort = sortNoList.size() < 1;
            needResortMap.put(entry.getKey(), needReSort);
        }
        long count = 0L;
        for (DynamicObject detail : details) {
            DynamicObject accountBank;
            String checkFlag = detail.getString("bankcheckflag");
            if (StringUtils.isEmpty((String)checkFlag)) {
                detail.set("bankcheckflag", (Object)GenBankcheckCode.genCode());
            }
            String acctBankPropVal = (accountBank = detail.getDynamicObject("accountbank")) == null ? "accountbank" : accountBank.getString("bankaccountnumber");
            DynamicObject currency = detail.getDynamicObject("currency");
            String currencyPropVal = currency == null ? "currency" : currency.getString("number");
            String key = acctBankPropVal + "---" + currencyPropVal;
            if (((Boolean)needResortMap.get(key)).booleanValue()) {
                detail.set("sortno", (Object)(DateUtils.getCurrentTime().getTime() * 100000L + count++ % 100000L));
            }
            detail.set("modifytime", (Object)DateUtils.getCurrentTime());
            detail.set("lastmodifytime", (Object)DateUtils.getCurrentTime());
            detail.set("confirmamount", (Object)Constants.ZERO);
            detail.set("unconfirmamount", (Object)(EmptyUtil.isNoEmpty((BigDecimal)detail.getBigDecimal("creditamount")) ? detail.getBigDecimal("creditamount") : detail.getBigDecimal("debitamount")));
            detail.set("synonym", (Object)TransDetailHelper.updateSynonym(detail, accountBank, detail.getDynamicObject("company")));
            detail.set("opprelacct", (Object)TransDetailHelper.getOppRelAcct(detail.getString("oppbanknumber")));
        }
    }

    public void beforeCommit(DynamicObject[] details) throws KDException {
        super.beforeCommit(details);
        logger.info("\u79bb\u7ebf\u660e\u7ec6\u5f15\u5165\u4fdd\u5b58\uff1a\u81ea\u52a8\u751f\u6210\u4f59\u989d\u5f00\u59cb");
        SyncAutoBalanceHelper.checkAndAutoBalance((DynamicObject[])details, (boolean)false, null);
        logger.info("\u79bb\u7ebf\u660e\u7ec6\u5f15\u5165\u4fdd\u5b58\uff1a\u81ea\u52a8\u751f\u6210\u4f59\u989d\u7ed3\u675f");
    }
}

