/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.detail;

import java.util.ArrayList;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.util.ExceptionUtils;
import kd.tmc.bei.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.bei.business.opservice.param.ElecBalanceQueryParam;
import kd.tmc.bei.business.opservice.result.ElecBalanceResult;
import kd.tmc.fbp.common.helper.MutexServiceHelper;

public class QueryElecBalanceTask
implements Runnable {
    private OperationResult operationResult;
    private ElecBalanceQueryParam param;

    public QueryElecBalanceTask(OperationResult operationResult, ElecBalanceQueryParam param) {
        this.operationResult = operationResult;
        this.param = param;
    }

    @Override
    public void run() {
        ArrayList<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>();
        String id = String.valueOf(this.param.getBankType().getLong("id"));
        boolean lock = MutexServiceHelper.requestWithLostTime((String)id, (String)"bei_elecbalancestate", (String)"queryelecbalance");
        if (lock) {
            try {
                ElecBalanceResult result = EBServiceFacadeFactory.getBankService().queryElecBalance(this.param);
                if (result != null && result.getErrMsg() != null) {
                    OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                    operateErrorInfo.setLevel(ErrorLevel.Error);
                    operateErrorInfo.setMessage(result.getErrMsg());
                    errorInfos.add(operateErrorInfo);
                }
            }
            catch (Exception exception) {
                this.operationResult.setMessage(ExceptionUtils.getExceptionStackTraceMessage((Exception)exception));
                this.operationResult.setSuccess(false);
                throw new KDBizException(exception.getMessage());
            }
            finally {
                MutexServiceHelper.release((String)id, (String)"bei_elecbalancestate", (String)"queryelecbalance");
            }
            if (!errorInfos.isEmpty()) {
                this.operationResult.setSuccess(false);
                this.operationResult.setAllErrorInfo(errorInfos);
            } else {
                this.operationResult.setSuccess(true);
            }
        } else {
            this.operationResult.setSuccess(false);
        }
    }
}

