/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.detailschedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.bei.business.helper.AutoMatchScheDuleHelper;
import kd.tmc.bei.business.task.recpayintel.IntelRecPayAutoMatchTaskHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.MatchBizTypeEnum;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RecAutoMatchScheduleService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(RecAutoMatchScheduleService.class);

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void afterProcess(DynamicObject[] dataEntities) throws TmcBizException {
        ArrayList<Object> succIdList = new ArrayList<Object>();
        HashSet failIdSet = new HashSet();
        List allDetailIds = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        ArrayList<OperateErrorInfo> errors = new ArrayList<OperateErrorInfo>();
        try {
            List<DynamicObject> firstFailList;
            String direction = "rec";
            String opNumber = DB.genGlobalLongId() + "";
            logger.info("dataEntities length is:" + dataEntities.length);
            HashSet<Object> tranSupSuccessIds = AutoMatchScheDuleHelper.autoMatch(Arrays.asList(dataEntities), MatchBizTypeEnum.TRANSUP, true, direction);
            for (Object id : allDetailIds) {
                if (tranSupSuccessIds.contains(id)) continue;
                failIdSet.add(id);
            }
            logger.info("failIdSet is:" + failIdSet.size());
            if (!EmptyUtil.isEmpty(tranSupSuccessIds)) {
                logger.info("tranSupSuccList is:" + tranSupSuccessIds.size());
                List<DynamicObject> recSuccList = Arrays.stream(dataEntities).filter(e -> tranSupSuccessIds.contains(e.getPkValue())).collect(Collectors.toList());
                logger.info("tranSupSuccList size is:" + recSuccList.size());
                IntelRecPayAutoMatchTaskHelper.autoMatch(recSuccList.toArray(new DynamicObject[0]), MatchBizTypeEnum.TRANSUP.getValue(), direction, opNumber);
                succIdList.addAll(tranSupSuccessIds);
                this.getOperationResult().setSuccessPkIds(succIdList);
                this.getOperationResult().setSuccess(true);
            }
            if (!EmptyUtil.isEmpty(failIdSet)) {
                firstFailList = Arrays.stream(dataEntities).filter(e -> failIdSet.contains(e.getPkValue())).collect(Collectors.toList());
                logger.info("firstFailList size is:" + firstFailList.size());
                HashSet<Object> recSupSuccessIds = AutoMatchScheDuleHelper.autoMatch(firstFailList, MatchBizTypeEnum.REC, true, direction);
                if (!EmptyUtil.isEmpty(recSupSuccessIds)) {
                    List<DynamicObject> recSuccList = Arrays.stream(dataEntities).filter(e -> recSupSuccessIds.contains(e.getPkValue())).collect(Collectors.toList());
                    logger.info("recSuccList size is:" + recSuccList.size());
                    IntelRecPayAutoMatchTaskHelper.autoMatch(recSuccList.toArray(new DynamicObject[0]), MatchBizTypeEnum.REC.getValue(), direction, opNumber);
                    succIdList.addAll(recSupSuccessIds);
                    this.getOperationResult().setSuccessPkIds(succIdList);
                    this.getOperationResult().setSuccess(true);
                    failIdSet.removeAll(recSupSuccessIds);
                }
            }
            if (!EmptyUtil.isEmpty(failIdSet)) {
                firstFailList = Arrays.stream(dataEntities).filter(e -> failIdSet.contains(e.getPkValue())).collect(Collectors.toList());
                logger.info("firstFailList size is:" + firstFailList.size());
                HashSet<Object> paySuccessIds = AutoMatchScheDuleHelper.autoMatch(firstFailList, MatchBizTypeEnum.PAY, true, direction);
                if (!EmptyUtil.isEmpty(paySuccessIds)) {
                    List<DynamicObject> paySuccList = Arrays.stream(dataEntities).filter(e -> paySuccessIds.contains(e.getPkValue())).collect(Collectors.toList());
                    logger.info("paySuccList size is:" + paySuccList.size());
                    IntelRecPayAutoMatchTaskHelper.autoMatch(paySuccList.toArray(new DynamicObject[0]), MatchBizTypeEnum.PAY.getValue(), direction, opNumber);
                    succIdList.addAll(paySuccessIds);
                    this.getOperationResult().setSuccessPkIds(succIdList);
                    this.getOperationResult().setSuccess(true);
                    failIdSet.removeAll(paySuccessIds);
                }
            }
            if (!EmptyUtil.isEmpty(failIdSet)) {
                firstFailList = Arrays.stream(dataEntities).filter(e -> failIdSet.contains(e.getPkValue())).collect(Collectors.toList());
                logger.info("firstFailList size is:" + firstFailList.size());
                HashSet<Object> exchangeSuccessIds = AutoMatchScheDuleHelper.autoMatch(firstFailList, MatchBizTypeEnum.EXCHANGE, true, direction);
                if (!EmptyUtil.isEmpty(exchangeSuccessIds)) {
                    List<DynamicObject> exchangeSuccList = Arrays.stream(dataEntities).filter(e -> exchangeSuccessIds.contains(e.getPkValue())).collect(Collectors.toList());
                    logger.info("exchangeSuccList size is:" + exchangeSuccList.size());
                    IntelRecPayAutoMatchTaskHelper.autoMatch(exchangeSuccList.toArray(new DynamicObject[0]), MatchBizTypeEnum.EXCHANGE.getValue(), direction, opNumber);
                    succIdList.addAll(exchangeSuccessIds);
                    this.getOperationResult().setSuccessPkIds(succIdList);
                    this.getOperationResult().setSuccess(true);
                    failIdSet.removeAll(exchangeSuccessIds);
                }
            }
        }
        catch (Exception e2) {
            for (Object failId : failIdSet) {
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setLevel(ErrorLevel.Error);
                operateErrorInfo.setMessage(e2.getMessage());
                operateErrorInfo.setPkValue(failId);
                errors.add(operateErrorInfo);
            }
            this.getOperationResult().getSuccessPkIds().removeAll(failIdSet);
            this.getOperationResult().setAllErrorInfo(errors);
            this.getOperationResult().setSuccess(false);
            logger.info("PayAutoMatchScheduleService.process error:", (Object)e2);
            return;
        }
        if (EmptyUtil.isNoEmpty(failIdSet)) {
            for (Object failId : failIdSet) {
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setLevel(ErrorLevel.Error);
                operateErrorInfo.setMessage(ResManager.loadKDString((String)"\u81ea\u52a8\u5339\u914d\u7ed3\u679c\u4e3a\u7a7a\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u672a\u914d\u7f6e\u81ea\u52a8\u5339\u914d\u89c4\u5219\uff0c\u6216\u6839\u636e\u89c4\u5219\u672a\u5339\u914d\u5230\u4e1a\u52a1\u5355\u636e\u3002", (String)"PayAutoMatchScheduleService_1", (String)"tmc-bei-business", (Object[])new Object[0]));
                operateErrorInfo.setPkValue(failId);
                errors.add(operateErrorInfo);
            }
            this.getOperationResult().getSuccessPkIds().removeAll(failIdSet);
            this.getOperationResult().setAllErrorInfo(errors);
            this.getOperationResult().setSuccess(false);
        }
    }
}

