/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.elec;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.form.MessageTypes;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.tmc.bei.business.helper.ElecBalanceStateAccServiceHelper;
import kd.tmc.bei.common.enums.ElecStatementStatusEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;

public class ElecBalanceStateAccQueryService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("accountbank");
        selector.add("startmonth");
        selector.add("endmonth");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        HashMap recordMap = new HashMap(16);
        HashMap<String, List<Long>> bankAccountNumberIdMap = new HashMap<String, List<Long>>(16);
        HashMap<String, DynamicObject> currencyMap = new HashMap<String, DynamicObject>(16);
        DynamicObjectCollection accountBanks = dataEntities[0].getDynamicObjectCollection("accountbank");
        Date startMonth = dataEntities[0].getDate("startmonth");
        Date endMonth = dataEntities[0].getDate("endmonth");
        HashSet bankSets = new HashSet(16);
        accountBanks.forEach(s -> {
            DynamicObject account = s.getDynamicObject("fbasedataid");
            Object bankId = account.getDynamicObject("bank").getPkValue();
            bankSets.add(bankId);
        });
        QFilter qFilter = new QFilter("id", "in", bankSets);
        Map finOrgInfo = TmcDataServiceHelper.loadFromCache((String)"bd_finorginfo", (String)"id,bank_cate", (QFilter[])qFilter.toArray());
        accountBanks.forEach(s -> {
            DynamicObject account = s.getDynamicObject("fbasedataid");
            Object bankId = account.getDynamicObject("bank").getPkValue();
            DynamicObject bankCgSetting = (DynamicObject)finOrgInfo.get(bankId);
            String bankCateNumber = bankCgSetting.getString("number");
            Long accountNumberId = (Long)account.getPkValue();
            String accountNumber = account.getString("bankaccountnumber");
            DynamicObjectCollection currencys = account.getDynamicObjectCollection("currency");
            for (DynamicObject currency : currencys) {
                String currencyNum = (currency = currency.getDynamicObject("fbasedataid")).getString("number");
                if (!currencyMap.containsKey(currencyNum)) {
                    currencyMap.put(currencyNum, currency);
                }
                String recordKey = bankCateNumber + ";" + currencyNum;
                List accountNumbers = recordMap.getOrDefault(recordKey, new ArrayList(10));
                accountNumbers.add(accountNumber);
                recordMap.put(recordKey, accountNumbers);
                List accountNumberIds = bankAccountNumberIdMap.getOrDefault(recordKey, new ArrayList(10));
                accountNumberIds.add(accountNumberId);
                bankAccountNumberIdMap.put(recordKey, accountNumberIds);
            }
        });
        Set<String> finishKeySet = this.execFinishStateTips(bankAccountNumberIdMap, currencyMap, this.operationResult, startMonth, endMonth);
        if (dataEntities.length == 1) {
            ThreadPools.executeOnceIncludeRequestContext((String)"ElecBalanceStateAccQuerySeexice", () -> ElecBalanceStateAccServiceHelper.queryRecordMapPart(recordMap, currencyMap, this.operationResult, "op_balancestate_acc_", startMonth, endMonth, finishKeySet));
        }
    }

    private Set<String> execFinishStateTips(Map<String, List<Long>> bankAccountNumberIdMap, Map<String, DynamicObject> currencyMap, OperationResult operationResult, Date startMonth, Date endMonth) {
        HashSet<String> finishKeySet = null;
        List<Date> periodList = ElecBalanceStateAccQueryService.getPeriod(startMonth, endMonth);
        for (Map.Entry<String, List<Long>> record : bankAccountNumberIdMap.entrySet()) {
            String bankCurrency = record.getKey();
            String[] split = bankCurrency.split(";");
            String currNumber = split[1];
            Long currencyId = (Long)currencyMap.get(currNumber).getPkValue();
            List<Long> accountNumberIds = record.getValue();
            QFilter finishFilter = new QFilter("accountbank", "in", accountNumberIds);
            finishFilter.and("currency", "=", (Object)currencyId);
            finishFilter.and("period", "in", periodList);
            QFilter elecAccFinishFilter = new QFilter("matchresult", "=", (Object)"Y");
            elecAccFinishFilter.or("bankstatus", "=", (Object)ElecStatementStatusEnum.OC.getValue());
            QFilter elecAccFilter = new QFilter("billtype", "=", (Object)"bei_elecbalancestate_acc");
            DynamicObject[] finishObjs = BusinessDataServiceHelper.load((String)"bei_elecbalancestate_acc", (String)"id,accountbank,currency,period,billtype,matchresult,bankstatus", (QFilter[])new QFilter[]{elecAccFilter, elecAccFinishFilter, finishFilter});
            if (finishObjs.length <= 0) continue;
            finishKeySet = new HashSet<String>(finishObjs.length * 2);
            HashSet<String> finishTipsSet = new HashSet<String>(finishObjs.length);
            String tips = ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\uff1a%1$s\u5e01\u79cd\uff1a%2$s\u5728%3$s\u5e74%4$s\u6708\u5df2\u5b8c\u6210\u4f59\u989d\u5bf9\u8d26\uff0c\u4e0d\u80fd\u518d\u6b21\u67e5\u8be2\u3002", (String)"ElecBalanceStateAccSyncService_0", (String)"tmc-bei-business", (Object[])new Object[0]);
            for (DynamicObject finishObj : finishObjs) {
                DynamicObject accountObj = finishObj.getDynamicObject("accountbank");
                String bankAccountNumber = accountObj.getString("bankaccountnumber");
                DynamicObject currencyObj = finishObj.getDynamicObject("currency");
                String currencyNum = currencyObj.getString("number");
                String currencyName = currencyObj.getString("name");
                Date period = finishObj.getDate("period");
                String yyyy = DateUtils.formatString((Date)period, (String)"yyyy");
                String MM = DateUtils.formatString((Date)period, (String)"MM");
                String message = String.format(tips, bankAccountNumber, currencyName, yyyy, MM);
                finishTipsSet.add(message);
                String finishKey = bankAccountNumber + currencyNum + yyyy + MM;
                finishKeySet.add(finishKey);
            }
            if (!CollectionUtils.isNotEmpty(finishTipsSet)) continue;
            String tipMsg = String.join((CharSequence)"\r\n", finishTipsSet);
            operationResult.setMessage(tipMsg);
            operationResult.setMessageType(MessageTypes.Business.getValue());
        }
        return finishKeySet;
    }

    private static List<Date> getPeriod(Date startMonth, Date endMonth) {
        ArrayList<Date> periodList = new ArrayList<Date>(8);
        Calendar beginCalendar = Calendar.getInstance();
        startMonth = DateUtils.getFirstDateOfAnyMonth((Date)startMonth, (int)0);
        beginCalendar.setTime(startMonth);
        Calendar endCalendar = Calendar.getInstance();
        endMonth = DateUtils.getLastDateOfAnyMonth((Date)endMonth, (int)0);
        endCalendar.setTime(endMonth);
        while (beginCalendar.before(endCalendar)) {
            Date time = beginCalendar.getTime();
            String yyyyMM = DateUtils.formatString((Date)time, (String)"yyyyMM");
            Date period = DateUtils.stringToDate((String)yyyyMM, (String)"yyyyMM");
            periodList.add(period);
            beginCalendar.add(2, 1);
        }
        return periodList;
    }
}

