/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.elec;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.MessageTypes;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import kd.tmc.bei.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.bei.business.opservice.param.ElecBalanceQueryParam;
import kd.tmc.bei.business.opservice.result.ElecBalanceResult;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ElecBalanceStateQueryService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>(4);
        lst.add("banktype");
        lst.add("org");
        lst.add("begindate");
        lst.add("enddate");
        return lst;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        if (dataEntities.length == 1) {
            DynamicObject bankType = dataEntities[0].getDynamicObject("banktype");
            DynamicObject org = dataEntities[0].getDynamicObject("org");
            Date beginDate = dataEntities[0].getDate("begindate");
            Date endDate = dataEntities[0].getDate("enddate");
            ElecBalanceQueryParam param = new ElecBalanceQueryParam(bankType, org, beginDate, endDate);
            String error = "";
            String id = String.valueOf(bankType.getLong("id"));
            boolean lock = MutexServiceHelper.requestWithLostTime((String)id, (String)"bei_elecbalancestate", (String)"queryelecbalance");
            if (lock) {
                Set<String> existFinishTips = this.getExistFinishTips(param);
                try {
                    ElecBalanceResult result = EBServiceFacadeFactory.getBankService().queryElecBalance(param);
                    if (result != null && result.getErrMsg() != null) {
                        error = result.getErrMsg();
                    }
                }
                catch (Exception exception) {
                    this.operationResult.setMessage(ExceptionUtils.getExceptionStackTraceMessage((Exception)exception));
                    this.operationResult.setSuccess(false);
                    throw new KDBizException(exception.getMessage());
                }
                finally {
                    MutexServiceHelper.release((String)id, (String)"bei_elecbalancestate", (String)"queryelecbalance");
                }
                if (EmptyUtil.isNoEmpty((String)error)) {
                    this.operationResult.setSuccess(false);
                    this.operationResult.setMessage(error);
                } else {
                    this.operationResult.setSuccess(true);
                    if (CollectionUtils.isNotEmpty(existFinishTips)) {
                        String tips = String.join((CharSequence)"\r\n", existFinishTips);
                        this.operationResult.setMessage(tips);
                        this.operationResult.setMessageType(MessageTypes.Business.getValue());
                    }
                }
            } else {
                this.operationResult.setSuccess(false);
                this.operationResult.setMessage("trylock fail");
            }
        }
    }

    private Set<String> getExistFinishTips(ElecBalanceQueryParam queryParam) {
        DynamicObjectCollection orgProtocolList;
        HashSet<String> existFinishTipsSet = new HashSet<String>(5);
        QFilter qFilter = new QFilter("banktype", "=", queryParam.getBankType().get("id"));
        qFilter.and("enable", "=", (Object)"1");
        if (queryParam.getOrg() != null && queryParam.getOrg().getLong("id") != 0L) {
            qFilter.and("org", "=", (Object)queryParam.getOrg().getLong("id"));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(orgProtocolList = QueryServiceHelper.query((String)"bei_orgprotocol", (String)"banktype.id,org.id,number", (QFilter[])new QFilter[]{qFilter})))) {
            List<Date> periodList = this.getPeriod(queryParam.getBeginDate(), queryParam.getEndDate());
            ArrayList<QFilter> finishFilterList = new ArrayList<QFilter>(16);
            for (DynamicObject orgProtocol : orgProtocolList) {
                Long orgId = orgProtocol.getLong("org.id");
                String number = orgProtocol.getString("number");
                QFilter finishFilter = new QFilter("company", "=", (Object)orgId);
                finishFilter.and("protocol", "=", (Object)number);
                finishFilter.and("period", "in", periodList);
                finishFilterList.add(finishFilter);
            }
            if (CollectionUtils.isNotEmpty(finishFilterList)) {
                List partition = Lists.partition(finishFilterList, (int)6);
                partition.stream().forEach(subFilter -> {
                    QFilter finishFilter = (QFilter)subFilter.get(0);
                    for (int i = 1; i < subFilter.size(); ++i) {
                        finishFilter = finishFilter.or((QFilter)subFilter.get(i));
                    }
                    QFilter elecBalanceFilter = new QFilter("billtype", "=", (Object)"bei_elecbalancestate");
                    elecBalanceFilter.and("matchresult", "=", (Object)"Y");
                    DynamicObject[] finishObjs = BusinessDataServiceHelper.load((String)"bei_elecbalancestate", (String)"id,company,protocol,period,stateno,matchresult,company.name", (QFilter[])new QFilter[]{elecBalanceFilter, finishFilter});
                    if (finishObjs.length > 0) {
                        String tips = ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\uff1a\u3010%1$s\u3011\u5bf9\u8d26\u7b7e\u7ea6\u534f\u8bae\u53f7%2$s\u5728%3$s\u5e74%4$s\u6708\u5df2\u5b8c\u6210\u4f59\u989d\u5bf9\u8d26\uff0c\u4e0d\u80fd\u518d\u6b21\u67e5\u8be2\u3002", (String)"ElecBalanceStateQueryService_1", (String)"tmc-bei-business", (Object[])new Object[0]);
                        HashSet<String> existFinishKeyList = new HashSet<String>(finishObjs.length);
                        for (DynamicObject finishObj : finishObjs) {
                            String protocolNo = finishObj.getString("protocol");
                            String reconciliationNo = finishObj.getString("stateno");
                            Date period = finishObj.getDate("period");
                            String companyName = finishObj.getString("company.name");
                            String yyyy = DateUtils.formatString((Date)period, (String)"yyyy");
                            String MM = DateUtils.formatString((Date)period, (String)"MM");
                            String message = String.format(tips, companyName, protocolNo, yyyy, MM);
                            existFinishTipsSet.add(message);
                            String key = protocolNo + reconciliationNo + yyyy + MM;
                            existFinishKeyList.add(key);
                        }
                        queryParam.setExistFinishKey(existFinishKeyList);
                    }
                });
            }
        }
        return existFinishTipsSet;
    }

    private List<Date> getPeriod(Date beginDate, Date endDate) {
        ArrayList<Date> periodList = new ArrayList<Date>(8);
        Calendar beginCalendar = Calendar.getInstance();
        beginDate = DateUtils.getFirstDateOfAnyMonth((Date)beginDate, (int)0);
        beginCalendar.setTime(beginDate);
        Calendar endCalendar = Calendar.getInstance();
        endDate = DateUtils.getLastDateOfAnyMonth((Date)endDate, (int)0);
        endCalendar.setTime(endDate);
        while (beginCalendar.before(endCalendar)) {
            Date time = beginCalendar.getTime();
            String yyyyMM = DateUtils.formatString((Date)time, (String)"yyyyMM");
            Date period = DateUtils.stringToDate((String)yyyyMM, (String)"yyyyMM");
            periodList.add(period);
            beginCalendar.add(2, 1);
        }
        return periodList;
    }
}

