/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.elec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.tmc.bei.business.helper.ElecMatchCheckHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class ElecMatchCheckService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(ElecMatchCheckService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("issetbankinterface");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        try {
            List<Long> idList = Arrays.stream(dataEntities).map(d -> (Long)d.getPkValue()).collect(Collectors.toList());
            Date bizDate = this.getBizeDate();
            String bankNumber = (String)this.operationVariable.get("bankaccountnumber");
            logger.info("process check error bizdate [{}], bankNumber [{}], entity size {}", new Object[]{DateUtils.formatString((Date)bizDate, (String)"yyyy-MM-dd"), bankNumber, idList.size()});
            if (CollectionUtils.isEmpty(idList)) {
                this.operationResult.setSuccess(true);
                return;
            }
            ArrayList operateErrorInfos = new ArrayList(16);
            Map<Long, String> msgMap = ElecMatchCheckHelper.processBankCheck(idList, bizDate, bankNumber);
            List temp = msgMap.entrySet().stream().map(t -> new OperateErrorInfo((String)t.getValue(), ErrorLevel.Error, t.getKey())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(temp)) {
                operateErrorInfos.addAll(temp);
            }
            if (!CollectionUtils.isEmpty(operateErrorInfos)) {
                this.operationResult.setSuccess(false);
                this.operationResult.setAllErrorInfo(operateErrorInfos);
                this.operationResult.setShowMessage(false);
            } else {
                this.operationResult.setSuccess(true);
            }
        }
        catch (Exception e) {
            ArrayList<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>(dataEntities.length);
            for (DynamicObject dataEntity : dataEntities) {
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setLevel(ErrorLevel.FatalError);
                operateErrorInfo.setMessage(e.getMessage());
                operateErrorInfo.setPkValue(dataEntity.getPkValue());
                errorInfos.add(operateErrorInfo);
            }
            this.operationResult.setSuccess(false);
            this.operationResult.setAllErrorInfo(errorInfos);
            this.operationResult.setShowMessage(false);
        }
    }

    private Date getBizeDate() {
        String cycle = (String)this.operationVariable.get("schedule_cycle");
        Date startdate = DateUtils.getCurrentDate();
        int cyc = StringUtils.isNotEmpty((CharSequence)cycle) ? Integer.parseInt(cycle) : 1;
        startdate = DateUtils.getLastDay((Date)startdate, (int)cyc);
        return startdate;
    }
}

