/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.elec;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.bei.business.helper.CasBotpHelper;
import kd.tmc.bei.business.helper.ElecMatchCheckHelper;
import kd.tmc.bei.business.helper.HandMatchServiceHelper;
import kd.tmc.bei.common.enums.ReceiptMatchTypeEnum;
import kd.tmc.bei.common.enums.SourceBillTypeEnum;
import kd.tmc.bei.common.helper.BeiHelper;
import kd.tmc.bei.common.resource.BeiBizResource;
import kd.tmc.fbp.common.compare.api.impl.CompareApiImpl;
import kd.tmc.fbp.common.compare.result.CompareResult;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ElecMatchDetailService {
    private static final Log logger = LogFactory.getLog(ElecMatchDetailService.class);
    private int onceCount = 200;
    private static final int RULE_COMPARE_BATCH = 100;
    private static final String SELECT_DETAIL = "id,company,accountbank,currency,creditamount,debitamount,description,oppunit,oppbanknumber,oppbank,bizdate,receiptno,matchreceiptentry,matchreceiptentry.e_receiptno,matchreceiptentry.e_receiptid,ismatchereceipt,bankcheckflag";

    /*
     * Unable to fully structure code
     */
    public void doMatchDetail(DynamicObject accountBank, OperationResult operationResult) {
        acctId = accountBank.getLong("id");
        errorInfos = new ArrayList<OperateErrorInfo>();
        operateErrorInfo = new OperateErrorInfo();
        totalCount = this.getReceiptCount(acctId);
        ElecMatchDetailService.logger.info("do Mathch Detail\uff1a" + totalCount + " acctId " + acctId);
        if (totalCount > 0) {
            if (totalCount <= this.onceCount) {
                this.doMatch(acctId, this.getReceiptFilter(acctId));
            } else {
                receiptIdList = new ArrayList<Long>();
                receiptSet = QueryServiceHelper.queryDataSet((String)(this.getClass() + " match"), (String)"bei_elecreceipt", (String)"id,receiptno,bizdate", (QFilter[])this.getReceiptFilter(acctId).toArray(), (String)"bizdate,creditamount,debitamount");
                var10_9 = null;
                try {
                    receiptRows = receiptSet.iterator();
                    bizdate = null;
                    while (receiptRows.hasNext()) {
                        receiptRow = (Row)receiptRows.next();
                        if (bizdate == null) {
                            bizdate = receiptRow.getDate("bizdate");
                        }
                        if (DateUtils.isSameDay((Date)bizdate, (Date)receiptRow.getDate("bizdate"))) {
                            receiptIdList.add(receiptRow.getLong("id"));
                            continue;
                        }
                        this.doMatchBizDate(acctId, receiptIdList);
                        receiptIdList.clear();
                        bizdate = receiptRow.getDate("bizdate");
                        receiptIdList.add(receiptRow.getLong("id"));
                    }
                    if (receiptIdList.size() <= 0) ** GOTO lbl52
                    this.doMatchBizDate(acctId, receiptIdList);
                }
                catch (Throwable var11_12) {
                    var10_9 = var11_12;
                    throw var11_12;
                }
                finally {
                    if (receiptSet != null) {
                        if (var10_9 != null) {
                            try {
                                receiptSet.close();
                            }
                            catch (Throwable var11_11) {
                                var10_9.addSuppressed(var11_11);
                            }
                        } else {
                            receiptSet.close();
                        }
                    }
                }
            }
        } else {
            operateErrorInfo.setLevel(ErrorLevel.Error);
            operateErrorInfo.setMessage(new BeiBizResource().getNoUnmatChreceipt());
            operateErrorInfo.setPkValue((Object)acctId);
            errorInfos.add(operateErrorInfo);
        }
lbl52:
        // 4 sources

        if (errorInfos.size() > 0) {
            operationResult.setSuccess(true);
            operationResult.setAllErrorInfo(errorInfos);
            operationResult.setShowMessage(false);
        } else {
            operationResult.setSuccess(true);
        }
    }

    private void doMatchBizDate(long acctId, List<Long> receiptIdList) {
        List receiptPart = Lists.partition(receiptIdList, (int)this.onceCount);
        for (int i = 0; i < receiptPart.size(); ++i) {
            QFilter receiptFilter = new QFilter("id", "in", receiptPart.get(i));
            this.doMatch(acctId, receiptFilter);
        }
    }

    private void doMatch(long acctId, QFilter receiptFilter) {
        DynamicObject[] receiptColl = BusinessDataServiceHelper.load((String)"bei_elecreceipt", (String)"id,company,accountbank,currency,creditamount,debitamount,description,oppunit,oppbanknumber,oppbank,amount,creditdebitflag,bizdate,receiptno,ismatch,transdetailid,bankcheckflag,matchdetailentry,matchdetailentry.e_transdetailid,matchdetailentry.e_bankcheckflag,matchtype,matcher,matchtime,fileflag,uploadfilename,datasource,accno,accname,bankname,recno,recname,recbankname", (QFilter[])receiptFilter.toArray(), (String)"bizdate,creditamount,debitamount");
        if (receiptColl.length > 0) {
            DynamicObject[] detailColl;
            ArrayList<DynamicObject> receiptList = new ArrayList<DynamicObject>(receiptColl.length);
            ArrayList<DynamicObject> detailList = new ArrayList<DynamicObject>(receiptColl.length);
            HashMap<Object, DynamicObject> receiptMap = new HashMap(16);
            ArrayList<Object> matchDetailIds = new ArrayList<Object>(receiptColl.length);
            HashSet<Long> matchRelatedBizBillSet = new HashSet<Long>(receiptColl.length);
            QFilter detailFilter = this.getDetailFilter(acctId);
            Set receiptnoSet = Arrays.stream(receiptColl).map(t -> t.getString("receiptno")).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(receiptnoSet)) {
                detailFilter.and("receiptno", "in", receiptnoSet);
            }
            if ((detailColl = BusinessDataServiceHelper.load((String)"bei_transdetail", (String)SELECT_DETAIL, (QFilter[])detailFilter.toArray(), (String)"bizdate,creditamount,debitamount")).length > 0) {
                for (int i = 0; i < receiptColl.length; ++i) {
                    DynamicObject receipt = receiptColl[i];
                    String detailno = receipt.getString("receiptno");
                    ArrayList<DynamicObject> matchedDetailList = new ArrayList<DynamicObject>(4);
                    for (int j = 0; j < detailColl.length; ++j) {
                        DynamicObject detail = detailColl[j];
                        String detailid = detail.getString("receiptno");
                        if (detailid.compareTo(detailno) != 0) continue;
                        matchedDetailList.add(detail);
                        break;
                    }
                    if (!matchedDetailList.isEmpty()) {
                        DynamicObject detail = (DynamicObject)matchedDetailList.get(0);
                        this.setMatchReceipt(receipt, detail, ReceiptMatchTypeEnum.ACCURATE.getValue());
                        Set<Long> billIds = this.checkBizBillGetReceipt("cas_paybill", "bei_transdetail", detail.getLong("id"), detail.getString("bankcheckflag"));
                        if (!billIds.isEmpty()) {
                            matchRelatedBizBillSet.addAll(billIds);
                        }
                        receiptList.add(receipt);
                        detailList.add(detail);
                        matchDetailIds.add(detail.getPkValue());
                        continue;
                    }
                    receiptMap.put(receipt.getPkValue(), receipt);
                }
                receiptColl = null;
                detailColl = null;
            } else {
                receiptMap = Arrays.stream(receiptColl).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity(), (p, q) -> p));
            }
            this.ruleMatchReceipt(acctId, receiptMap, matchDetailIds, receiptList, detailList, matchRelatedBizBillSet);
            if (receiptList.size() > 0 && detailList.size() > 0) {
                List receiptPart = Lists.partition(receiptList, (int)5);
                List detailPart = Lists.partition(detailList, (int)5);
                for (int i = 0; i < receiptPart.size(); ++i) {
                    this.updateReceiptDetail((List)receiptPart.get(i), (List)detailPart.get(i), 3);
                }
            }
            if (!matchRelatedBizBillSet.isEmpty()) {
                ElecMatchCheckHelper.setBizBillGetReceipt("cas_paybill", matchRelatedBizBillSet, false);
            }
        } else {
            logger.info("doMatch acctId:" + acctId + " , receiptColl is empty");
        }
    }

    private void updateReceiptDetail(List<DynamicObject> receipts, List<DynamicObject> details, int retryNum) {
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])receipts.toArray(new DynamicObject[0]));
            SaveServiceHelper.save((DynamicObject[])details.toArray(new DynamicObject[0]));
            return;
        }
        catch (Exception e) {
            tx.markRollback();
            if (1 == retryNum) {
                logger.error((Throwable)e);
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        if (retryNum - 1 > 0) {
            this.updateReceiptDetail(receipts, details, retryNum - 1);
        }
    }

    private void ruleMatchReceipt(long acctId, Map<Object, DynamicObject> receiptMap, List<Object> matchDetailIds, List<DynamicObject> receiptList, List<DynamicObject> detailList, Set<Long> matchRelatedBizBillSet) {
        if (CollectionUtils.isEmpty(receiptMap.keySet())) {
            return;
        }
        ArrayList<Long> details = new ArrayList<Long>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryTransDetail", (String)"bei_transdetail", (String)"id", (QFilter[])this.getRuleDetailFilter(acctId, receiptMap.values()).toArray(), (String)"bizdate,creditamount,debitamount");){
            while (ds.hasNext()) {
                Row r = ds.next();
                if (matchDetailIds.contains(r.getLong("id"))) continue;
                details.add(r.getLong("id"));
            }
        }
        logger.info("ruleMatchReceipt acctId:" + acctId + " , detail size:" + details.size());
        if (CollectionUtils.isEmpty(details)) {
            return;
        }
        ArrayList<Object> receipts = new ArrayList<Object>(receiptMap.keySet());
        List detailPart = Lists.partition(details, (int)100);
        for (int i = 0; i < detailPart.size() && !CollectionUtils.isEmpty(receipts); ++i) {
            this.doCompare(receipts, (List)detailPart.get(i), receiptMap, receiptList, detailList, matchRelatedBizBillSet);
        }
    }

    private void doCompare(List<Object> receiptIds, List<Object> detailIds, Map<Object, DynamicObject> receiptMap, List<DynamicObject> receiptList, List<DynamicObject> detailList, Set<Long> matchRelatedBizBillSet) {
        DynamicObject[] detailColl;
        DynamicObject receipt;
        CompareApiImpl compareApi = new CompareApiImpl();
        List list = compareApi.compare(receiptIds, detailIds, "bei_elecreceipt", "bei_transdetail", "company");
        HashMap tranReceiptMap = new HashMap(list.size());
        for (CompareResult compareResult : list) {
            Set elecIdSet = compareResult.getSrcIdSet();
            Set tranIdSet = compareResult.getTarIdSet();
            if (elecIdSet.size() <= 0 || tranIdSet.size() <= 0) continue;
            Object elecId = elecIdSet.iterator().next();
            Object tranId = tranIdSet.iterator().next();
            receipt = receiptMap.get(elecId);
            if (ObjectUtils.anyNull((Object[])new Object[]{receipt, tranId}) || !(tranId instanceof Long)) continue;
            tranReceiptMap.put(tranId, receipt);
            receiptIds.remove(elecId);
        }
        if (CollectionUtils.isEmpty(tranReceiptMap.keySet())) {
            return;
        }
        QFilter qFilter = new QFilter("id", "in", tranReceiptMap.keySet());
        for (DynamicObject detail : detailColl = BusinessDataServiceHelper.load((String)"bei_transdetail", (String)SELECT_DETAIL, (QFilter[])qFilter.toArray(), (String)"receiptno")) {
            receipt = (DynamicObject)tranReceiptMap.get(detail.getPkValue());
            detail.set("receiptno", receipt.get("receiptno"));
            this.setMatchReceipt(receipt, detail, ReceiptMatchTypeEnum.PARSE.getValue());
            Set<Long> billIds = this.checkBizBillGetReceipt("cas_paybill", "bei_transdetail", detail.getLong("id"), detail.getString("bankcheckflag"));
            if (!billIds.isEmpty()) {
                matchRelatedBizBillSet.addAll(billIds);
            }
            receiptList.add(receipt);
            detailList.add(detail);
        }
    }

    private void setMatchReceipt(DynamicObject receipt, DynamicObject detail, String matchType) {
        receipt.set("ismatch", (Object)"1");
        receipt.set("currency", (Object)(receipt.getDynamicObject("currency") == null ? detail.getDynamicObject("currency") : receipt.getDynamicObject("currency")));
        DynamicObjectCollection matchdetailentry = receipt.getDynamicObjectCollection("matchdetailentry");
        DynamicObject entry = matchdetailentry.addNew();
        entry.set("e_transdetailid", (Object)detail.getLong("id"));
        entry.set("e_bankcheckflag", (Object)detail.getString("bankcheckflag"));
        BigDecimal debitamount = detail.getBigDecimal("debitamount");
        BigDecimal creditamount = detail.getBigDecimal("creditamount");
        if (ElecMatchCheckHelper.checkReceiptIsFile(receipt)) {
            receipt.set("debitamount", (Object)debitamount);
            receipt.set("creditamount", (Object)creditamount);
        }
        if (debitamount.compareTo(BigDecimal.ZERO) > 0) {
            receipt.set("amount", (Object)debitamount);
            receipt.set("creditdebitflag", (Object)"1");
        } else if (debitamount.compareTo(BigDecimal.ZERO) < 0) {
            receipt.set("amount", (Object)debitamount.abs());
            receipt.set("creditdebitflag", (Object)"2");
        } else if (creditamount.compareTo(BigDecimal.ZERO) < 0) {
            receipt.set("amount", (Object)creditamount.abs());
            receipt.set("creditdebitflag", (Object)"1");
        } else {
            receipt.set("amount", (Object)creditamount);
            receipt.set("creditdebitflag", (Object)"2");
        }
        ElecMatchCheckHelper.setFieldValue(detail, receipt);
        receipt.set("oppunit", (Object)(EmptyUtil.isEmpty((String)receipt.getString("oppunit")) ? detail.getString("oppunit") : receipt.getString("oppunit")));
        receipt.set("oppbanknumber", (Object)(EmptyUtil.isEmpty((String)receipt.getString("oppbanknumber")) ? detail.getString("oppbanknumber") : receipt.getString("oppbanknumber")));
        receipt.set("oppbank", (Object)(EmptyUtil.isEmpty((String)receipt.getString("oppbank")) ? detail.getString("oppbank") : receipt.getString("oppbank")));
        receipt.set("description", (Object)(EmptyUtil.isEmpty((String)receipt.getString("description")) || BeiHelper.isReceiptFileFromBank((DynamicObject)receipt) ? detail.getString("description") : receipt.getString("description")));
        receipt.set("bankcheckflag", (Object)detail.getString("bankcheckflag"));
        receipt.set("matchtype", (Object)matchType);
        receipt.set("matcher", (Object)RequestContext.get().getCurrUserId());
        receipt.set("matchtime", (Object)new Date());
        detail.set("ismatchereceipt", (Object)"1");
        HandMatchServiceHelper.setMatchReceiptEntry(detail, receipt.getLong("id"), receipt.getString("receiptno"));
    }

    private int getReceiptCount(long acctId) {
        String sql = "select count(*) as count from t_bei_elecreceipt where faccountbankid=? and fismatch='0' and freceiptno<>' '";
        int totalCount = (Integer)DB.query((DBRoute)DBRouteConst.TMC, (String)sql, (Object[])new Object[]{acctId}, (ResultSetHandler)new ResultSetHandler<Integer>(){

            public Integer handle(ResultSet rs) throws Exception {
                int count = 0;
                while (rs.next()) {
                    count = rs.getInt("count");
                }
                return count;
            }
        });
        return totalCount;
    }

    private QFilter getDetailFilter(long acctId) {
        QFilter filter = new QFilter("ismatchereceipt", "=", (Object)"0");
        filter.and("accountbank", "=", (Object)acctId);
        filter.and("isnoreceipt", "=", (Object)"0");
        filter.and("receiptno", "<>", (Object)"");
        return filter;
    }

    private QFilter getRuleDetailFilter(long acctId, Collection<DynamicObject> receipts) {
        QFilter filter = new QFilter("ismatchereceipt", "=", (Object)"0");
        filter.and("accountbank", "=", (Object)acctId);
        filter.and("receiptno", "is not null", null);
        Optional<Date> maxOpt = receipts.stream().map(t -> t.getDate("bizdate")).filter(Objects::nonNull).max(Date::compareTo);
        Optional<Date> minOpt = receipts.stream().map(t -> t.getDate("bizdate")).filter(Objects::nonNull).min(Date::compareTo);
        if (maxOpt.isPresent() && minOpt.isPresent()) {
            Date startTime = minOpt.get();
            Date endTime = maxOpt.get();
            endTime = DateUtils.getDataFormat((Date)endTime, (boolean)false);
            filter.and("bizdate", ">=", (Object)startTime).and("bizdate", "<=", (Object)endTime);
        }
        return filter;
    }

    private QFilter getReceiptFilter(long acctId) {
        QFilter filter = new QFilter("accountbank", "=", (Object)acctId);
        filter.and("ismatch", "=", (Object)"0");
        filter.and("receiptno", "<>", (Object)" ");
        return filter;
    }

    public Set<Long> checkBizBillGetReceipt(String billFormId, String detailBillFormId, Long detailId, String bankCheckFlag) {
        DynamicObject bill;
        HashSet<Long> checkResultSet = new HashSet<Long>(2);
        Set<Long> destBillIds = CasBotpHelper.getDestBillBySrcBill(detailId, detailBillFormId, billFormId);
        if (destBillIds != null && !destBillIds.isEmpty()) {
            checkResultSet.addAll(destBillIds);
            return checkResultSet;
        }
        if (EmptyUtil.isNoEmpty((String)bankCheckFlag) && (SourceBillTypeEnum.PAYBILL.getValue().equals(billFormId) || SourceBillTypeEnum.AGENTPAYBILL.getValue().equals(billFormId) || SourceBillTypeEnum.RECBILL.getValue().equals(billFormId)) && EmptyUtil.isNoEmpty((DynamicObject)(bill = QueryServiceHelper.queryOne((String)billFormId, (String)"id, bankcheckentity.ebankcheckflag bankcheckflag", (QFilter[])new QFilter[]{new QFilter("bankcheckentity.ebankcheckflag", "=", (Object)bankCheckFlag)})))) {
            checkResultSet.add(bill.getLong("id"));
        }
        return checkResultSet;
    }
}

