/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.elec;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.tmc.bei.business.ebservice.EBStatementService;
import kd.tmc.bei.business.opservice.param.ElecStatementPram;
import kd.tmc.bei.business.opservice.result.ELecStatementResult;
import kd.tmc.bei.common.resource.BeiBizResource;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.service.ebservice.errorcode.BeErrorCode;
import kd.tmc.fbp.service.ebservice.exception.BEBizException;

public class ElecStatemenDownService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(ElecStatemenDownService.class);

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("createorg.id");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>();
        ErrorCode errorCode = new BeErrorCode().COMMON();
        String month = (String)this.operationVariable.get("month");
        for (DynamicObject accountBank : dataEntities) {
            if (accountBank == null) continue;
            String bankAcctId = accountBank.getString("id");
            boolean isSuccess = MutexServiceHelper.request((String)bankAcctId, (String)"bd_accountbanks", (String)"op_statement");
            if (isSuccess) {
                try {
                    logger.info("\u83b7\u53d6\u9501\u6210\u529f\uff1a" + bankAcctId);
                    Date startDate = DateUtils.getFirstDayOfMonth((Date)DateUtils.getLastMonth((Date)new Date(), (int)Integer.parseInt(month)));
                    Date endDate = "0".equals(month) ? new Date() : DateUtils.getLastDayOfMonth((Date)DateUtils.getLastMonth((Date)new Date(), (int)1));
                    ElecStatementPram elecStatementPram = new ElecStatementPram(accountBank, startDate, endDate);
                    ELecStatementResult eLecStatementResult = new EBStatementService(elecStatementPram).downElecStatement();
                    if (eLecStatementResult.getErrMsg() == null) continue;
                    OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                    operateErrorInfo.setLevel(ErrorLevel.Error);
                    operateErrorInfo.setMessage(eLecStatementResult.getErrMsg());
                    operateErrorInfo.setPkValue((Object)accountBank.getLong("id"));
                    errorInfos.add(operateErrorInfo);
                    continue;
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    this.operationResult.setMessage(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    this.operationResult.setSuccess(false);
                    throw new BEBizException(errorCode, (Object[])new String[]{e.getMessage()});
                }
                finally {
                    MutexServiceHelper.release((String)bankAcctId, (String)"bd_accountbanks", (String)"op_statement");
                    logger.info("\u5df2\u91ca\u653e\u9501\uff1a" + bankAcctId);
                }
            }
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setLevel(ErrorLevel.Error);
            operateErrorInfo.setMessage(new BeiBizResource().getElecStatement_Lock());
            operateErrorInfo.setPkValue((Object)Long.valueOf(bankAcctId));
            errorInfos.add(operateErrorInfo);
        }
        if (errorInfos.size() > 0) {
            this.operationResult.setSuccess(false);
            this.operationResult.setAllErrorInfo(errorInfos);
            this.operationResult.setShowMessage(false);
        } else {
            this.operationResult.setSuccess(true);
        }
    }
}

