/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.elec;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.cache.AppCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bei.common.enums.BalanceDirectionEnum;
import kd.tmc.bei.common.helper.CodeRuleHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.bean.Reconciliation;
import kd.tmc.fbp.common.bean.ReconciliationRecord;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ElecStatementFileImportService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(ElecStatementFileImportService.class);

    public void process(DynamicObject[] dataEntities) throws KDException {
        Map variables = this.getOperationVariable();
        if (variables == null || variables.isEmpty()) {
            logger.error("OperationVariable is null.");
            return;
        }
        String importCancel = null;
        String cacheKey = "";
        if (variables.containsKey("pageId")) {
            cacheKey = "importCancel" + (String)variables.get("pageId");
            importCancel = (String)AppCache.get((String)((String)variables.get("appId"))).get(cacheKey, String.class);
        }
        if (Boolean.TRUE.toString().equals(importCancel)) {
            AppCache.get((String)((String)variables.get("appId"))).remove(cacheKey);
            logger.info("\u7535\u5b50\u5bf9\u8d26\u5355\u5f15\u5165\u53d6\u6d88\u64cd\u4f5c");
            throw new KDException(new ErrorCode("", "operation cancel"), new Object[0]);
        }
        logger.info("import cancel value {}", importCancel);
        String fileUrl = (String)variables.get("fileurl");
        String jsonStr = (String)variables.get("json");
        String isCover = (String)variables.get("iscover");
        String dataSource = (String)variables.get("datasource");
        Date currentDate = DateUtils.getCurrentDate();
        Timestamp currentTime = DateUtils.getCurrentTime();
        Reconciliation reconciliation = (Reconciliation)JSONObject.parseObject((String)jsonStr, Reconciliation.class);
        String accNo = reconciliation.getAccNo();
        QFilter accFilter = new QFilter("bankaccountnumber", "=", (Object)accNo);
        DynamicObject queryAcc = TmcDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (String)"id,createorg,openorg,bank,acctname", (QFilter[])accFilter.toArray());
        String currency = reconciliation.getCurrency();
        QFilter curFilter = new QFilter("number", "=", (Object)currency);
        DynamicObject queryCur = TmcDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)"id,number,name", (QFilter[])curFilter.toArray());
        String year = reconciliation.getYear();
        String month = reconciliation.getMonth();
        Date period = DateUtils.stringToDate((String)(year + month), (String)"yyyyMM");
        Long accountId = (Long)queryAcc.getPkValue();
        QFilter qFilter = new QFilter("accountbank", "=", (Object)accountId);
        Long currencyId = (Long)queryCur.getPkValue();
        qFilter.and("currency", "=", (Object)currencyId);
        qFilter.and("period", "=", (Object)period);
        qFilter.and("datasource", "=", (Object)dataSource);
        DynamicObject elecStatement = TmcDataServiceHelper.loadSingle((String)"bei_elecstatement", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isEmpty((DynamicObject)elecStatement)) {
            elecStatement = TmcDataServiceHelper.newDynamicObject((String)"bei_elecstatement");
            Object orgId = queryAcc.getDynamicObject("createorg").getPkValue();
            elecStatement.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            elecStatement.set("company", orgId);
            elecStatement.set("accountcompany", queryAcc.getDynamicObject("openorg").getPkValue());
            elecStatement.set("accountbank", (Object)accountId);
            elecStatement.set("currency", (Object)currencyId);
            elecStatement.set("period", (Object)period);
            String accName = reconciliation.getAccName();
            elecStatement.set("accountbankname", EmptyUtil.isEmpty((String)accName) ? queryAcc.get("acctname") : accName);
            elecStatement.set("bank", queryAcc.getDynamicObject("bank").getPkValue());
            elecStatement.set("joindate", (Object)currentDate);
            elecStatement.set("jointime", (Object)currentTime);
            elecStatement.set("createtime", (Object)currentTime);
            elecStatement.set("creator", (Object)RequestContext.get().getCurrUserId());
            elecStatement.set("billtype", (Object)"bei_elecstatement");
            String billno = CodeRuleHelper.generateNumber((String)"bei_elecstatement", (DynamicObject)elecStatement, (String)String.valueOf(orgId), null);
            elecStatement.set("billno", (Object)billno);
        }
        elecStatement.set("datasource", (Object)dataSource);
        elecStatement.set("modifytime", (Object)currentTime);
        elecStatement.set("modifier", (Object)RequestContext.get().getCurrUserId());
        elecStatement.set("identificationissuer", (Object)reconciliation.getIdentificationCode());
        elecStatement.set("bankbranchnumber", (Object)reconciliation.getBankBranch());
        elecStatement.set("bankcustomercode", (Object)reconciliation.getCodeCustomer());
        elecStatement.set("isfile", (Object)Boolean.TRUE);
        elecStatement.set("endacctamount", (Object)this.genAmoutField(reconciliation.getAccountBalance()));
        elecStatement.set("endretainamount", (Object)this.genAmoutField(reconciliation.getReserveBalance()));
        elecStatement.set("endfreezeamount", (Object)this.genAmoutField(reconciliation.getFrozenBalance()));
        elecStatement.set("endoverdraftamount", (Object)this.genAmoutField(reconciliation.getOverdraftBalance()));
        elecStatement.set("endavailableamount", (Object)this.genAmoutField(reconciliation.getAvailableBalance()));
        DynamicObjectCollection entity = elecStatement.getDynamicObjectCollection("entryentity");
        if ("true".equals(isCover)) {
            entity.clear();
        }
        List details = reconciliation.getDetails();
        int seq = entity.size();
        for (ReconciliationRecord detail : details) {
            DynamicObject addNew = entity.addNew();
            addNew.set("seq", (Object)seq);
            addNew.set("e_accountbank", (Object)accountId);
            addNew.set("e_currency", (Object)currencyId);
            addNew.set("e_bookjournal", (Object)detail.getJournalAccountOfBookkeeping());
            String transDate = detail.getTransDate();
            addNew.set("e_bookdate", EmptyUtil.isEmpty((String)transDate) ? null : DateUtils.stringToDate((String)transDate, (String)"yyyy-MM-dd"));
            String transTime = detail.getTransTime();
            addNew.set("e_booktime", EmptyUtil.isEmpty((String)transTime) ? null : DateUtils.stringToDate((String)transTime, (String)"yyyy-MM-dd HH:mm:ss"));
            String creditMark = detail.getIdentificationOfCreditOrDebit();
            addNew.set("e_creditmark", (Object)creditMark);
            BigDecimal transactionAmount = detail.getTransactionAmount();
            if (BalanceDirectionEnum.DEBIT.getValue().equals(creditMark)) {
                addNew.set("e_debitamount", (Object)transactionAmount);
            } else {
                addNew.set("e_creditamount", (Object)transactionAmount);
            }
            addNew.set("e_balancedirection", (Object)detail.getDebitOrCreditOfBalance());
            addNew.set("e_acctamount", (Object)this.genAmoutField(detail.getAccountBalance()));
            addNew.set("e_oppositeacct", (Object)detail.getOppAccNo());
            addNew.set("e_oppositeacctname", (Object)detail.getOppAccName());
            addNew.set("e_remark", (Object)detail.getNote());
            addNew.set("e_elecreceiptno", (Object)detail.getNumberOfBankElectronicReceipt());
            addNew.set("e_bizproduct", (Object)detail.getTypesOfBusinessProducts());
            addNew.set("e_sourcedocument", (Object)detail.getTypeOfSourceDocument());
            addNew.set("e_sourcedocumentno", (Object)detail.getNumberOfSourceDocument());
            addNew.set("e_transactioncode", (Object)detail.getTransactionCode());
            addNew.set("e_bookkeeper", (Object)detail.getBookkeeper());
            addNew.set("e_otherbookinfo", (Object)detail.getOtherAccountingInformation());
            addNew.set("e_businessserialnumber", (Object)detail.getBusinessSerialNumber());
            ++seq;
        }
        DynamicObjectCollection urlEntry = elecStatement.getDynamicObjectCollection("urlentry");
        if ("true".equals(isCover)) {
            urlEntry.clear();
        }
        DynamicObject urlAddNew = urlEntry.addNew();
        urlAddNew.set("e_fileservicepath", (Object)fileUrl);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{elecStatement});
    }

    private BigDecimal genAmoutField(String amount) {
        return EmptyUtil.isNoEmpty((String)amount) ? new BigDecimal(amount) : null;
    }
}

